/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars;

import cpw.mods.compactsolars.BlockCompactSolar;
import cpw.mods.compactsolars.CommonProxy;
import cpw.mods.compactsolars.CompactSolarType;
import cpw.mods.compactsolars.ItemCompactSolar;
import cpw.mods.compactsolars.ItemSolarHat;
import cpw.mods.compactsolars.Version;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod(modid="compactsolars", name="Compact Solar Arrays", dependencies="required-after:Forge@[12.17.0.1940,);required-after:IC2@[2.2,)", acceptedMinecraftVersions="[1.10.2]")
public class CompactSolars {
    @SidedProxy(clientSide="cpw.mods.compactsolars.client.ClientProxy", serverSide="cpw.mods.compactsolars.CommonProxy")
    public static CommonProxy proxy;
    public static BlockCompactSolar compactSolarBlock;
    public static ItemCompactSolar compactSolarItemBlock;
    public static int productionRate;
    @Mod.Instance(value="compactsolars")
    public static CompactSolars instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent preinit) {
        Version.init(preinit.getVersionProperties());
        preinit.getModMetadata().version = Version.version();
        Configuration cfg = new Configuration(preinit.getSuggestedConfigurationFile());
        try {
            cfg.load();
            compactSolarBlock = new BlockCompactSolar();
            compactSolarItemBlock = new ItemCompactSolar((Block)compactSolarBlock);
            CompactSolarType.buildHats();
            Property scale = cfg.get("general", "scaleFactor", 1);
            scale.setComment("The EU generation scaling factor. The average number of ticks needed to generate one EU packet.1 is every tick, 2 is every other tick etc. Each Solar will still generate a whole packet (8, 64, 512 EU).");
            productionRate = scale.getInt(1);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"CompactSolars was unable to load it's configuration successfully", (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            cfg.save();
        }
        compactSolarBlock.func_149663_c("compactsolars.compact_solar_block");
        compactSolarBlock.setRegistryName(new ResourceLocation("compactsolars", "compact_solar_block"));
        compactSolarItemBlock.func_77655_b("compactsolars.compact_solar_block");
        compactSolarItemBlock.setRegistryName(new ResourceLocation("compactsolars", "compact_solar_block"));
        GameRegistry.register((IForgeRegistryEntry)compactSolarBlock);
        GameRegistry.register((IForgeRegistryEntry)compactSolarItemBlock);
        for (CompactSolarType typ : CompactSolarType.values()) {
            GameRegistry.registerTileEntity(typ.clazz, (String)typ.tileEntityName());
        }
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent init) {
        proxy.registerTileEntityRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent postinit) {
        CompactSolarType.generateRecipes(compactSolarBlock);
        CompactSolarType.generateHatRecipes(compactSolarBlock);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent evt) {
        ItemSolarHat.clearRaining();
    }

    static {
        productionRate = 1;
    }
}

