/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseOrientation;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShapeBlock
extends BaseBlock<ShapeTE> {
    protected AxisAlignedBB boxHit;
    public static IProperty<Integer> LIGHT = PropertyInteger.func_177719_a((String)"light", (int)0, (int)15);

    public ShapeBlock() {
        super(Material.field_151576_e, ShapeTE.class);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(LIGHT);
    }

    @Override
    public int getNumSubtypes() {
        return 16;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient24WaysByTE;
    }

    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState iBlockState) {
        return false;
    }

    public RayTraceResult func_180636_a(IBlockState iBlockState, World world, BlockPos blockPos, Vec3d vec3d, Vec3d vec3d2) {
        int n;
        RayTraceResult rayTraceResult = null;
        double d = 0.0;
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, null);
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB axisAlignedBB = list.get(i);
                RayTraceResult rayTraceResult2 = axisAlignedBB.func_72327_a(vec3d, vec3d2);
                if (rayTraceResult2 == null) continue;
                rayTraceResult2.subHit = i;
                double d2 = vec3d.func_72436_e(rayTraceResult2.field_72307_f);
                if (rayTraceResult != null && !(d2 < d)) continue;
                rayTraceResult = rayTraceResult2;
                d = d2;
            }
        }
        if (rayTraceResult != null) {
            n = rayTraceResult.subHit;
            this.boxHit = list.get(n).func_72317_d((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
            rayTraceResult = new RayTraceResult(rayTraceResult.field_72307_f, rayTraceResult.field_178784_b, blockPos);
            rayTraceResult.subHit = n;
        }
        return rayTraceResult;
    }

    public AxisAlignedBB func_185496_a(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        ShapeTE shapeTE;
        if (this.boxHit != null && (shapeTE = ShapeTE.get(iBlockAccess, blockPos)) != null && shapeTE.shape.kind.highlightZones()) {
            return this.boxHit;
        }
        shapeTE = this.getLocalBounds(iBlockAccess, blockPos, iBlockState, null);
        if (shapeTE != null) {
            return shapeTE;
        }
        return super.func_185496_a(iBlockState, iBlockAccess, blockPos);
    }

    public void func_185477_a(IBlockState iBlockState, World world, BlockPos blockPos, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        List<AxisAlignedBB> list2 = this.getGlobalCollisionBoxes((IBlockAccess)world, blockPos, iBlockState, entity);
        if (list2 != null) {
            for (AxisAlignedBB axisAlignedBB2 : list2) {
                if (!axisAlignedBB.func_72326_a(axisAlignedBB2)) continue;
                list.add(axisAlignedBB2);
            }
        }
    }

    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)iBlockAccess.func_175625_s(blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation();
            return this.getCollisionBoxes(shapeTE, iBlockAccess, blockPos, iBlockState, trans3, entity);
        }
        return null;
    }

    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)iBlockAccess.func_175625_s(blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation(Vector3.zero);
            return this.getCollisionBoxes(shapeTE, iBlockAccess, blockPos, iBlockState, trans3, entity);
        }
        return null;
    }

    protected AxisAlignedBB getLocalBounds(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Entity entity) {
        ShapeTE shapeTE = (ShapeTE)iBlockAccess.func_175625_s(blockPos);
        if (shapeTE != null) {
            Trans3 trans3 = shapeTE.localToGlobalTransformation(Vector3.blockCenter);
            return shapeTE.shape.kind.getBounds(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3);
        }
        return null;
    }

    protected List<AxisAlignedBB> getCollisionBoxes(ShapeTE shapeTE, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, Trans3 trans3, Entity entity) {
        ArrayList<AxisAlignedBB> arrayList = new ArrayList<AxisAlignedBB>();
        shapeTE.shape.kind.addCollisionBoxesToList(shapeTE, iBlockAccess, blockPos, iBlockState, entity, trans3, arrayList);
        return arrayList;
    }

    public boolean canHarvestBlock(IBlockAccess iBlockAccess, BlockPos blockPos, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    protected List<ItemStack> getDropsFromTileEntity(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, int n) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (tileEntity instanceof ShapeTE) {
            ShapeTE shapeTE = (ShapeTE)tileEntity;
            ItemStack itemStack = shapeTE.shape.kind.newStack(shapeTE.shape, shapeTE.baseBlockState, 1);
            arrayList.add(itemStack);
            if (shapeTE.secondaryBlockState != null) {
                itemStack = shapeTE.shape.kind.newSecondaryMaterialStack(shapeTE.secondaryBlockState);
                arrayList.add(itemStack);
            }
        }
        return arrayList;
    }

    public ItemStack getPickBlock(IBlockState iBlockState, RayTraceResult rayTraceResult, World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        ShapeTE shapeTE = ShapeTE.get((IBlockAccess)world, blockPos);
        if (shapeTE != null) {
            return shapeTE.newItemStack(1);
        }
        return null;
    }

    public IBlockState getBaseBlockState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        ShapeTE shapeTE = (ShapeTE)this.getTileEntity(iBlockAccess, blockPos);
        if (shapeTE != null) {
            return shapeTE.baseBlockState;
        }
        return null;
    }

    public float func_180647_a(IBlockState iBlockState, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        float f = 1.0f;
        IBlockState iBlockState2 = this.getBaseBlockState((IBlockAccess)world, blockPos);
        if (iBlockState2 != null) {
            f = ShapeBlock.acBlockStrength(iBlockState2, entityPlayer, world, blockPos);
        }
        return f;
    }

    public static float acBlockStrength(IBlockState iBlockState, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        float f = iBlockState.func_177230_c().func_176195_g(iBlockState, world, blockPos);
        if (f < 0.0f) {
            return 0.0f;
        }
        float f2 = entityPlayer.getDigSpeed(iBlockState, blockPos) / f;
        if (!ShapeBlock.acCanHarvestBlock(iBlockState, entityPlayer)) {
            return f2 / 100.0f;
        }
        return f2 / 30.0f;
    }

    public static boolean acCanHarvestBlock(IBlockState iBlockState, EntityPlayer entityPlayer) {
        Block block = iBlockState.func_177230_c();
        if (block.func_149688_o(iBlockState).func_76229_l()) {
            return true;
        }
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        String string = block.getHarvestTool(iBlockState);
        if (itemStack == null || string == null) {
            return entityPlayer.func_184823_b(iBlockState);
        }
        int n = itemStack.func_77973_b().getHarvestLevel(itemStack, string);
        if (n < 0) {
            return entityPlayer.func_184823_b(iBlockState);
        }
        return n >= block.getHarvestLevel(iBlockState);
    }

    @Override
    public IBlockState getParticleState(IBlockAccess iBlockAccess, BlockPos blockPos) {
        IBlockState iBlockState = this.getBaseBlockState(iBlockAccess, blockPos);
        if (iBlockState != null) {
            return iBlockState;
        }
        return this.func_176223_P();
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer, EnumHand enumHand, ItemStack itemStack, EnumFacing enumFacing, float f, float f2, float f3) {
        ShapeTE shapeTE;
        ItemStack itemStack2 = entityPlayer.field_71071_by.func_70448_g();
        if (itemStack2 != null && (shapeTE = ShapeTE.get((IBlockAccess)world, blockPos)) != null) {
            return shapeTE.applySecondaryMaterial(itemStack2, entityPlayer);
        }
        return false;
    }

    public boolean canRenderInLayer(BlockRenderLayer blockRenderLayer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState iBlockState) {
        return 0.8f;
    }

    public int func_149750_m(IBlockState iBlockState) {
        return (Integer)iBlockState.func_177229_b(LIGHT);
    }
}

