/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.BaseDataChannel;
import gcewing.architecture.BaseGui;
import gcewing.architecture.SawbenchContainer;
import gcewing.architecture.SawbenchTE;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapePage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SawbenchGui
extends BaseGui.Screen {
    public static int pageMenuLeft = 176;
    public static int pageMenuTop = 19;
    public static int pageMenuWidth = 58;
    public static int pageMenuRowHeight = 10;
    public static float pageMenuScale = 1.0f;
    public static int shapeMenuLeft = 44;
    public static int shapeMenuTop = 23;
    public static int shapeMenuMargin = 4;
    public static int shapeMenuCellSize = 24;
    public static int shapeMenuRows = 4;
    public static int shapeMenuCols = 5;
    public static int shapeMenuWidth = shapeMenuCols * shapeMenuCellSize;
    public static int shapeMenuHeight = shapeMenuRows * shapeMenuCellSize;
    public static int selectedShapeTitleLeft = 40;
    public static int selectedShapeTitleTop = 128;
    public static int selectedShapeTitleRight = 168;
    public static int materialUsageLeft = 7;
    public static int materialUsageTop = 82;
    public static float shapeMenuScale = 2.0f;
    public static float shapeMenuItemScale = 2.0f;
    public static float shapeMenuItemUSize = 40.0f;
    public static float shapeMenuItemVSize = 45.0f;
    public static float shapeMenuItemWidth = shapeMenuItemUSize / shapeMenuItemScale;
    public static float shapeMenuItemHeight = shapeMenuItemVSize / shapeMenuItemScale;
    SawbenchTE te;

    public static SawbenchGui create(EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof SawbenchTE) {
            return new SawbenchGui(entityPlayer, (SawbenchTE)tileEntity);
        }
        return null;
    }

    public SawbenchGui(EntityPlayer entityPlayer, SawbenchTE sawbenchTE) {
        super(new SawbenchContainer(entityPlayer, sawbenchTE));
        this.te = sawbenchTE;
    }

    @Override
    protected void drawBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture("gui/gui_sawbench.png", 256, 256);
        this.drawTexturedRect(0.0, 0.0, this.field_146999_f, this.field_147000_g, 0.0, 0.0);
        this.drawShapeMenu();
        this.drawShapeSelection();
        this.drawPageMenu();
        this.drawSelectedShapeTitle();
        this.field_146289_q.func_78276_b("Sawbench", 7, 7, 0x404040);
    }

    void drawPageMenu() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)pageMenuLeft, (float)pageMenuTop, (float)0.0f);
        this.gSave();
        this.setColor(0.4, 0.8, 1.0);
        this.drawRect(0.0, this.te.selectedPage * pageMenuRowHeight, pageMenuWidth, pageMenuRowHeight);
        this.gRestore();
        int n = 0;
        while (true) {
            if (n >= SawbenchTE.pages.length) break;
            this.drawString(SawbenchTE.pages[n].title, 1, 1);
            GL11.glTranslatef((float)0.0f, (float)pageMenuRowHeight, (float)0.0f);
            ++n;
        }
        GL11.glPopMatrix();
    }

    void drawShapeMenu() {
        this.gSave();
        GL11.glPushMatrix();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)shapeMenuLeft, (float)shapeMenuTop, (float)0.0f);
        this.bindTexture("gui/shapemenu_bg.png", 256, 256);
        double d = shapeMenuWidth + 2 * shapeMenuMargin;
        double d2 = shapeMenuHeight + 2 * shapeMenuMargin;
        this.drawTexturedRect(-shapeMenuMargin, -shapeMenuMargin, d, d2, 0.0, 0.0, (double)shapeMenuScale * d, (double)shapeMenuScale * d2);
        this.bindTexture("gui/shapemenu_items.png", 512, 512);
        int n = this.te.selectedPage;
        if (n >= 0) {
            if (n < SawbenchTE.pages.length) {
                ShapePage shapePage = SawbenchTE.pages[n];
                if (shapePage != null) {
                    Shape[] shapeArray = shapePage.shapes;
                    for (int i = 0; i < shapeArray.length; ++i) {
                        Shape shape = shapeArray[i];
                        int n2 = i / shapeMenuCols;
                        int n3 = i % shapeMenuCols;
                        int n4 = shape.id;
                        int n5 = n4 / 10;
                        int n6 = n4 % 10;
                        this.drawTexturedRect(((double)n3 + 0.5) * (double)shapeMenuCellSize - 0.5 * (double)shapeMenuItemWidth, ((double)n2 + 0.5) * (double)shapeMenuCellSize - 0.5 * (double)shapeMenuItemHeight, shapeMenuItemWidth, shapeMenuItemHeight, (float)n6 * shapeMenuItemUSize, (float)n5 * shapeMenuItemVSize, shapeMenuItemUSize, shapeMenuItemVSize);
                    }
                }
            }
        }
        GL11.glPopMatrix();
        this.gRestore();
    }

    void drawShapeSelection() {
        int n = this.te.selectedSlots[this.te.selectedPage];
        int n2 = n / shapeMenuCols;
        int n3 = n % shapeMenuCols;
        int n4 = shapeMenuLeft + shapeMenuCellSize * n3;
        int n5 = shapeMenuTop + shapeMenuCellSize * n2;
        this.drawTexturedRect(n4, n5, 24.5, 24.5, 44.0, 23.0, 49.0, 49.0);
    }

    void drawSelectedShapeTitle() {
        Shape shape = this.te.getSelectedShape();
        if (shape != null) {
            int n = selectedShapeTitleLeft;
            int n2 = this.field_146289_q.func_78256_a(shape.title);
            if (n + n2 > selectedShapeTitleRight) {
                n = selectedShapeTitleRight - n2;
            }
            this.drawString(shape.title, n, selectedShapeTitleTop);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)materialUsageLeft, (float)materialUsageTop, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.drawString(String.format("%s makes %s", this.te.materialMultiple(), this.te.resultMultiple()), 0, 0);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void mousePressed(int n, int n2, int n3) {
        if (n >= pageMenuLeft && n2 >= pageMenuTop && n < pageMenuLeft + pageMenuWidth) {
            this.clickPageMenu(n - pageMenuLeft, n2 - pageMenuTop);
        } else if (n >= shapeMenuLeft && n2 >= shapeMenuTop && n < shapeMenuLeft + shapeMenuWidth && n2 < shapeMenuTop + shapeMenuHeight) {
            this.clickShapeMenu(n - shapeMenuLeft, n2 - shapeMenuTop);
        } else {
            super.mousePressed(n, n2, n3);
        }
    }

    void clickPageMenu(int n, int n2) {
        int n3 = n2 / pageMenuRowHeight;
        if (n3 >= 0) {
            if (n3 < SawbenchTE.pages.length) {
                this.sendSelectShape(n3, this.te.selectedSlots[n3]);
            }
        }
    }

    void clickShapeMenu(int n, int n2) {
        int n3 = n2 / shapeMenuCellSize;
        int n4 = n / shapeMenuCellSize;
        if (n3 >= 0 && n3 < shapeMenuRows && n4 >= 0 && n4 < shapeMenuCols) {
            int n5 = n3 * shapeMenuCols + n4;
            this.sendSelectShape(this.te.selectedPage, n5);
        }
    }

    protected void sendSelectShape(int n, int n2) {
        BaseDataChannel.ChannelOutput channelOutput = ArchitectureCraft.channel.openServerContainer("SelectShape");
        channelOutput.writeInt(n);
        channelOutput.writeInt(n2);
        channelOutput.close();
    }
}

