/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.common.collect.ImmutableList;
import gcewing.architecture.BaseBakedRenderTarget;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseModelRenderer;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.Trans3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseRenderingManager<MOD extends BaseMod<? extends BaseModClient>>
implements BaseModClient.IRenderingManager {
    public boolean debugRenderingManager = false;
    public boolean debugModelRegistration = false;
    protected BaseModClient<MOD> client;
    protected Map<Block, BaseModClient.ICustomRenderer> blockRenderers = new HashMap<Block, BaseModClient.ICustomRenderer>();
    protected Map<Item, BaseModClient.ICustomRenderer> itemRenderers = new HashMap<Item, BaseModClient.ICustomRenderer>();
    protected Map<IBlockState, BaseModClient.ICustomRenderer> stateRendererCache = new HashMap<IBlockState, BaseModClient.ICustomRenderer>();
    protected Map<ResourceLocation, BaseModClient.ITexture> textureCache = new HashMap<ResourceLocation, BaseModClient.ITexture>();
    protected boolean customRenderingRequired;
    protected CustomBlockStateMapper blockStateMapper = new CustomBlockStateMapper();
    protected List<CustomBakedModel> bakedModels = new ArrayList<CustomBakedModel>();
    protected static Trans3 itemTrans = Trans3.blockCenterSideTurn(0, 2);
    protected CustomItemBakedModel itemBakedModel;
    protected static String[] texturePrefixes = new String[]{"blocks/", "textures/"};
    protected BlockRendererDispatcher blockRendererDispatcher;

    public BaseRenderingManager(BaseModClient baseModClient) {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager: Creating\n", new Object[0]);
        }
        this.client = baseModClient;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void preInit() {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager.preInit\n", new Object[0]);
        }
        this.registerDefaultRenderers();
        this.registerDefaultModelLocations();
    }

    @Override
    public void postInit() {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager.postInit: customRenderingRequired = %s\n", this.customRenderingRequired);
        }
        if (this.customRenderingRequired) {
            this.enableCustomRendering();
        }
    }

    protected void registerDefaultRenderers() {
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            String string;
            if (!(block instanceof BaseMod.IBlock) || this.blockRenderers.containsKey(block) || (string = ((BaseMod.IBlock)block).getQualifiedRendererClassName()) == null) continue;
            try {
                Class<?> clazz = Class.forName(string);
                this.addBlockRenderer(block, (BaseModClient.ICustomRenderer)clazz.newInstance());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public void addBlockRenderer(Block block, BaseModClient.ICustomRenderer iCustomRenderer) {
        this.blockRenderers.put(block, iCustomRenderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addItemRenderer(item, iCustomRenderer);
        }
    }

    @Override
    public void addItemRenderer(Item item, BaseModClient.ICustomRenderer iCustomRenderer) {
        this.itemRenderers.put(item, iCustomRenderer);
    }

    protected CustomItemBakedModel getItemBakedModel() {
        if (this.itemBakedModel == null) {
            this.itemBakedModel = new CustomItemBakedModel();
        }
        return this.itemBakedModel;
    }

    protected void registerDefaultModelLocations() {
        CustomItemBakedModel customItemBakedModel = this.getItemBakedModel();
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (this.blockNeedsCustomRendering(block)) {
                this.registerBakedModelsForBlock(block);
                if (item == null) continue;
                this.registerModelLocationForItem(item, customItemBakedModel);
                continue;
            }
            this.registerInventoryLocationForItem(item, block.func_149739_a());
        }
        for (Item item : ((BaseMod)this.client.base).registeredItems) {
            if (this.itemNeedsCustomRendering(item)) {
                this.registerModelLocationForItem(item, customItemBakedModel);
                continue;
            }
            this.registerInventoryLocationForItem(item, item.func_77658_a());
        }
    }

    protected void registerBakedModelsForBlock(Block block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)this.blockStateMapper);
        for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation modelResourceLocation = this.blockStateMapper.func_178132_a(iBlockState);
            BlockParticleModel blockParticleModel = new BlockParticleModel(iBlockState, modelResourceLocation);
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerBakedModelsForBlock: Squirrelling %s --> %s\n", modelResourceLocation, blockParticleModel);
            }
            this.bakedModels.add(blockParticleModel);
        }
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object object) {
        return object instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)object).getTextureNames() != null;
    }

    protected void registerModelLocationForItem(Item item, CustomItemBakedModel customItemBakedModel) {
        this.registerModelLocationForSubtypes(item, customItemBakedModel.location);
    }

    protected void registerInventoryLocationForItem(Item item, String string) {
        String string2 = string.substring(5);
        this.registerModelLocationForSubtypes(item, new ModelResourceLocation(string2, "inventory"));
    }

    protected void registerModelLocationForSubtypes(Item item, ModelResourceLocation modelResourceLocation) {
        int n = this.getNumItemSubtypes(item);
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient: Registering model location %s for %d subtypes of %s\n", modelResourceLocation, n, item.func_77658_a());
        }
        for (int i = 0; i < n; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
    }

    private int getNumBlockSubtypes(Block block) {
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getNumSubtypes();
        }
        return 1;
    }

    private int getNumItemSubtypes(Item item) {
        if (item instanceof BaseMod.IItem) {
            return ((BaseMod.IItem)item).getNumSubtypes();
        }
        if (item instanceof ItemBlock) {
            return this.getNumBlockSubtypes(Block.func_149634_a((Item)item));
        }
        return 1;
    }

    protected BaseModClient.ICustomRenderer getCustomRenderer(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        Block block = iBlockState.func_177230_c();
        BaseModClient.ICustomRenderer iCustomRenderer = this.blockRenderers.get(block);
        if (iCustomRenderer == null && block instanceof BaseMod.IBlock) {
            IBlockState iBlockState2 = block.func_176221_a(iBlockState, iBlockAccess, blockPos);
            iCustomRenderer = this.getCustomRendererForState(iBlockState2);
        }
        return iCustomRenderer;
    }

    protected BaseModClient.ICustomRenderer getCustomRendererForSpec(int n, BaseMod.ModelSpec modelSpec) {
        BaseModClient.IModel iModel = this.getModel(modelSpec.modelName);
        BaseModClient.ITexture[] iTextureArray = new BaseModClient.ITexture[modelSpec.textureNames.length];
        for (int i = 0; i < iTextureArray.length; ++i) {
            iTextureArray[i] = this.getTexture(n, modelSpec.textureNames[i]);
        }
        return new BaseModelRenderer(iModel, modelSpec.origin, iTextureArray);
    }

    protected BaseModClient.ICustomRenderer getCustomRendererForState(IBlockState iBlockState) {
        BaseMod.ModelSpec modelSpec;
        Block block;
        BaseModClient.ICustomRenderer iCustomRenderer = this.stateRendererCache.get(iBlockState);
        if (iCustomRenderer == null && (block = iBlockState.func_177230_c()) instanceof BaseMod.IBlock && (modelSpec = ((BaseMod.IBlock)block).getModelSpec(iBlockState)) != null) {
            iCustomRenderer = this.getCustomRendererForSpec(0, modelSpec);
            this.stateRendererCache.put(iBlockState, iCustomRenderer);
        }
        return iCustomRenderer;
    }

    public static void renderBlockUsingModelSpec(BaseModClient baseModClient, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget, BlockRenderLayer blockRenderLayer, Trans3 trans3) {
        ((BaseRenderingManager)baseModClient.renderingManager).renderBlockUsingModelSpec(iBlockAccess, blockPos, iBlockState, iRenderTarget, blockRenderLayer, trans3);
    }

    public void renderBlockUsingModelSpec(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget, BlockRenderLayer blockRenderLayer, Trans3 trans3) {
        BaseModClient.ICustomRenderer iCustomRenderer = this.getCustomRendererForState(iBlockState);
        if (iCustomRenderer != null) {
            iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, iRenderTarget, blockRenderLayer, trans3);
        }
    }

    public static void renderItemStackUsingModelSpec(BaseModClient baseModClient, ItemStack itemStack, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3) {
        ((BaseRenderingManager)baseModClient.renderingManager).renderItemStackUsingModelSpec(itemStack, iRenderTarget, trans3);
    }

    public void renderItemStackUsingModelSpec(ItemStack itemStack, BaseModClient.IRenderTarget iRenderTarget, Trans3 trans3) {
        IBlockState iBlockState = BaseBlockUtils.getBlockStateFromItemStack(itemStack);
        BaseMod.IBlock iBlock = (BaseMod.IBlock)iBlockState.func_177230_c();
        BaseMod.ModelSpec modelSpec = iBlock.getModelSpec(iBlockState);
        BaseModClient.ICustomRenderer iCustomRenderer = this.getCustomRendererForSpec(0, modelSpec);
        iCustomRenderer.renderItemStack(itemStack, iRenderTarget, trans3);
    }

    @Override
    public BaseModClient.IModel getModel(String string) {
        return ((BaseMod)this.client.base).getModel(string);
    }

    public ResourceLocation textureResourceLocation(int n, String string) {
        return ((BaseMod)this.client.base).resourceLocation(texturePrefixes[n] + string);
    }

    public BaseModClient.ITexture getTexture(int n, String string) {
        ResourceLocation resourceLocation = this.textureResourceLocation(n, string);
        return this.textureCache.get(resourceLocation);
    }

    public TextureAtlasSprite getIcon(int n, String string) {
        return ((BaseTexture.Sprite)this.getTexture((int)n, (String)string)).icon;
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre pre) {
        this.textureCache.clear();
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            this.registerSprites(0, pre.getMap(), block);
        }
        for (Item item : ((BaseMod)this.client.base).registeredItems) {
            this.registerSprites(1, pre.getMap(), item);
        }
    }

    protected void registerSprites(int n, TextureMap textureMap, Object object) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.registerSprites: for %s\n", object);
        }
        if (object instanceof BaseMod.ITextureConsumer) {
            String[] stringArray = ((BaseMod.ITextureConsumer)object).getTextureNames();
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerSprites: texture names = %s\n", new Object[]{stringArray});
            }
            if (stringArray != null) {
                this.customRenderingRequired = true;
                for (String string : stringArray) {
                    ResourceLocation resourceLocation = this.textureResourceLocation(n, string);
                    if (this.textureCache.get(resourceLocation) != null) continue;
                    TextureAtlasSprite textureAtlasSprite = textureMap.func_174942_a(resourceLocation);
                    BaseTexture.Sprite sprite = BaseTexture.fromSprite(textureAtlasSprite);
                    this.textureCache.put(resourceLocation, sprite);
                }
            }
        }
    }

    protected IBakedModel customRenderBlockToBakedModel(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.ICustomRenderer iCustomRenderer) {
        BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos);
        Trans3 trans3 = Trans3.blockCenter;
        BlockRenderLayer blockRenderLayer = MinecraftForgeClient.getRenderLayer();
        BlockModelShapes blockModelShapes = this.blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(this.getBlockParticleState(iBlockState, iBlockAccess, blockPos));
        iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, blockRenderLayer, trans3);
        return baseBakedRenderTarget.getBakedModel(textureAtlasSprite);
    }

    public IBlockState getBlockParticleState(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        Block block = iBlockState.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getParticleState(iBlockAccess, blockPos);
        }
        return block.func_176221_a(iBlockState, iBlockAccess, blockPos);
    }

    public static boolean renderAlternateBlock(BaseModClient baseModClient, IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget) {
        return ((BaseRenderingManager)baseModClient.renderingManager).renderAlternateBlock(iBlockAccess, blockPos, iBlockState, iRenderTarget);
    }

    public boolean renderAlternateBlock(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, BaseModClient.IRenderTarget iRenderTarget) {
        Block block = iBlockState.func_177230_c();
        if (!block.hasTileEntity(iBlockState)) {
            try {
                VertexBuffer vertexBuffer = ((BaseWorldRenderTarget)iRenderTarget).getWorldRenderer();
                return this.blockRendererDispatcher.func_175018_a(iBlockState, blockPos, iBlockAccess, vertexBuffer);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent modelBakeEvent) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.ModelBakeEvent\n", new Object[0]);
        }
        this.getItemBakedModel().install(modelBakeEvent);
        for (CustomBakedModel customBakedModel : this.bakedModels) {
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.onModelBakeEvent: Installing %s --> %s\n", customBakedModel.location, customBakedModel);
            }
            customBakedModel.install(modelBakeEvent);
        }
    }

    protected void enableCustomRendering() {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.blockRendererDispatcher = minecraft.func_175602_ab();
    }

    protected class CustomItemBakedModel
    extends CustomBakedModel {
        protected ItemOverrideList itemOverrideList;

        public CustomItemBakedModel() {
            this.itemOverrideList = new CustomItemRenderOverrideList();
            this.location = BaseRenderingManager.this.client.modelResourceLocation("__custitem__", "");
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    }

    protected class CustomItemRenderOverrideList
    extends ItemOverrideList {
        public CustomItemRenderOverrideList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel iBakedModel, ItemStack itemStack, World world, EntityLivingBase entityLivingBase) {
            Object object;
            Item item = itemStack.func_77973_b();
            BaseModClient.ICustomRenderer iCustomRenderer = BaseRenderingManager.this.itemRenderers.get(item);
            if (iCustomRenderer == null && item instanceof BaseMod.IItem && (object = ((BaseMod.IItem)item).getModelSpec(itemStack)) != null) {
                iCustomRenderer = BaseRenderingManager.this.getCustomRendererForSpec(1, (BaseMod.ModelSpec)object);
            }
            if (iCustomRenderer == null && (object = Block.func_149634_a((Item)item)) != null) {
                iCustomRenderer = BaseRenderingManager.this.getCustomRendererForState(object.func_176223_P());
            }
            if (iCustomRenderer != null) {
                GlStateManager.func_179103_j((int)7425);
                object = new BaseBakedRenderTarget();
                iCustomRenderer.renderItemStack(itemStack, (BaseModClient.IRenderTarget)object, itemTrans);
                return ((BaseBakedRenderTarget)object).getBakedModel();
            }
            return null;
        }
    }

    protected class BlockParticleModel
    extends CustomBakedModel {
        protected IBlockState state;

        public BlockParticleModel(IBlockState iBlockState, ModelResourceLocation modelResourceLocation) {
            this.state = iBlockState;
            this.location = modelResourceLocation;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }

        @Override
        public TextureAtlasSprite func_177554_e() {
            String[] stringArray;
            Block block = this.state.func_177230_c();
            if (block instanceof BaseMod.IBlock && (stringArray = ((BaseMod.IBlock)block).getTextureNames()) != null && stringArray.length > 0) {
                return BaseRenderingManager.this.getIcon(0, stringArray[0]);
            }
            return null;
        }
    }

    protected abstract class CustomBakedModel
    implements IBakedModel {
        public ModelResourceLocation location;

        protected CustomBakedModel() {
        }

        public void install(ModelBakeEvent modelBakeEvent) {
            if (BaseRenderingManager.this.debugModelRegistration) {
                System.out.printf("BaseModClient: Installing %s at %s\n", this, this.location);
            }
            modelBakeEvent.getModelRegistry().func_82595_a((Object)this.location, (Object)this);
        }

        public List<BakedQuad> func_188616_a(IBlockState iBlockState, EnumFacing enumFacing, long l) {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }
    }

    protected static class CustomBlockStateMapper
    extends DefaultStateMapper {
        protected CustomBlockStateMapper() {
        }

        public ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return super.func_178132_a(iBlockState);
        }
    }
}

