/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctm;

import java.beans.ConstructorProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import team.chisel.client.render.ctm.ISubmap;

public class Submap
implements ISubmap {
    private final float width;
    private final float height;
    private final float xOffset;
    private final float yOffset;
    private final SubmapNormalized normalized = new SubmapNormalized(this);
    private static final float FACTOR = 16.0f;

    @Override
    public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
        return sprite.func_94214_a((double)(this.getXOffset() + u / this.getWidth()));
    }

    @Override
    public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
        return sprite.func_94207_b((double)(this.getYOffset() + v / this.getWidth()));
    }

    @Override
    public float[] toArray() {
        return new float[]{this.getXOffset(), this.getYOffset(), this.getXOffset() + this.getWidth(), this.getYOffset() + this.getHeight()};
    }

    @Override
    public SubmapNormalized normalize() {
        return this.normalized;
    }

    @Override
    public ISubmap relativize() {
        return this;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getXOffset() {
        return this.xOffset;
    }

    @Override
    public float getYOffset() {
        return this.yOffset;
    }

    public SubmapNormalized getNormalized() {
        return this.normalized;
    }

    @ConstructorProperties(value={"width", "height", "xOffset", "yOffset"})
    public Submap(float width, float height, float xOffset, float yOffset) {
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    private static class SubmapNormalized
    implements ISubmap {
        private final ISubmap parent;

        @Override
        public float getXOffset() {
            return this.parent.getXOffset() / 16.0f;
        }

        @Override
        public float getYOffset() {
            return this.parent.getYOffset() / 16.0f;
        }

        @Override
        public float getWidth() {
            return this.parent.getWidth() / 16.0f;
        }

        @Override
        public float getHeight() {
            return this.parent.getHeight() / 16.0f;
        }

        @Override
        public ISubmap relativize() {
            return this.parent;
        }

        @Override
        public ISubmap normalize() {
            return this;
        }

        @Override
        public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
            return this.parent.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
            return this.parent.getInterpolatedV(sprite, v);
        }

        @Override
        public float[] toArray() {
            return this.parent.toArray();
        }

        @ConstructorProperties(value={"parent"})
        public SubmapNormalized(ISubmap parent) {
            this.parent = parent;
        }
    }
}

