/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.common.util.NBTUtil;

public class PacketChiselNBT
implements IMessage {
    private NBTTagCompound tag;
    private int chiselSlot;

    public PacketChiselNBT(NBTTagCompound tag, int chiselSlot) {
        this.tag = tag;
        this.chiselSlot = chiselSlot;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeByte(this.chiselSlot);
    }

    public void fromBytes(ByteBuf buf) {
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.chiselSlot = buf.readByte();
    }

    public PacketChiselNBT() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselNBT, IMessage> {
        public IMessage onMessage(PacketChiselNBT message, MessageContext ctx) {
            ItemStack stack = ctx.getServerHandler().field_147369_b.field_71071_by.func_70301_a(message.chiselSlot);
            if (stack != null) {
                NBTUtil.setChiselTag(stack, message.tag);
            }
            return null;
        }
    }
}

