/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.BlankAdvancedGuiHandler;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.CastingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.CraftingStationRecipeTransferInfo;
import slimeknights.tconstruct.plugin.jei.DryingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.DryingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.PatternSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.TableRecipeHandler;
import slimeknights.tconstruct.plugin.jei.TableSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.ToolPartSubtypeInterpreter;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.client.GuiTinkerTank;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static ICraftingGridHelper craftingGridHelper;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        TableSubtypeInterpreter tableInterpreter = new TableSubtypeInterpreter();
        PatternSubtypeInterpreter patternInterpreter = new PatternSubtypeInterpreter();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerGadgets.rack), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolTables), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolForge), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            ToolPartSubtypeInterpreter toolPartInterpreter = new ToolPartSubtypeInterpreter();
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!(part instanceof Item)) continue;
                registry.registerSubtypeInterpreter((Item)part, (ISubtypeRegistry.ISubtypeInterpreter)toolPartInterpreter);
            }
            registry.registerSubtypeInterpreter((Item)TinkerTools.pattern, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            registry.registerSubtypeInterpreter((Item)TinkerSmeltery.cast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
            registry.registerSubtypeInterpreter((Item)TinkerSmeltery.clayCast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
        }
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new String[]{"minecraft.crafting"});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            CastingRecipe recipe;
            CastingRecipeCategory castingCategory = new CastingRecipeCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(guiHelper), new AlloyRecipeCategory(guiHelper), castingCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new TableRecipeHandler(), new SmeltingRecipeHandler(), new AlloyRecipeHandler(), new CastingRecipeHandler()});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.smelteryController), new String[]{SmeltingRecipeCategory.CATEGORY, AlloyRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.TABLE.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCategoryCraftingItem(new ItemStack(TinkerSmeltery.searedFurnaceController), new String[]{"minecraft.smelting"});
            registry.addRecipes(TinkerRegistry.getAllMeltingRecipies());
            registry.addRecipes(TinkerRegistry.getAlloys());
            HashMap castDict = Maps.newHashMap();
            for (ICastingRecipe irecipe : TinkerRegistry.getAllTableCastingRecipes()) {
                if (!(irecipe instanceof CastingRecipe)) continue;
                recipe = (CastingRecipe)irecipe;
                if (recipe.cast != null && recipe.getResult() != null && recipe.getResult().func_77973_b() instanceof Cast) {
                    Triple output = Triple.of((Object)recipe.getResult().func_77973_b(), (Object)Cast.getPartFromTag(recipe.getResult()), (Object)recipe.getFluid().getFluid());
                    if (!castDict.containsKey(output)) {
                        LinkedList list = Lists.newLinkedList();
                        castDict.put(output, list);
                        registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(list, recipe, castingCategory.castingTable))));
                    }
                    ((List)castDict.get(output)).addAll(recipe.cast.getInputs());
                    continue;
                }
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingTable))));
            }
            for (ICastingRecipe irecipe : TinkerRegistry.getAllBasinCastingRecipes()) {
                if (!(irecipe instanceof CastingRecipe)) continue;
                recipe = (CastingRecipe)irecipe;
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingBasin))));
            }
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiTinkerTank>(GuiTinkerTank.class), new TinkerGuiTankHandler<GuiSmeltery>(GuiSmeltery.class)});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(guiHelper)});
            registry.addRecipeHandlers(new IRecipeHandler[]{new DryingRecipeHandler()});
            registry.addRecipes(TinkerRegistry.getAllDryingRecipes());
            registry.addRecipeCategoryCraftingItem(BlockTable.createItemstack(TinkerGadgets.rack, 1, (Block)Blocks.field_150376_bx, 0), new String[]{DryingRecipeCategory.CATEGORY});
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }

    private static class TinkerGuiTankHandler<T extends GuiContainer>
    extends BlankAdvancedGuiHandler<T> {
        private Class<T> clazz;

        public TinkerGuiTankHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public Class<T> getGuiContainerClass() {
            return this.clazz;
        }

        @Nullable
        public Object getIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
            return ((IGuiLiquidTank)guiContainer).getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

