/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import slimeknights.tconstruct.gadgets.Exploder;
import slimeknights.tconstruct.gadgets.entity.ExplosionEFLN;
import slimeknights.tconstruct.gadgets.item.ItemThrowball;
import slimeknights.tconstruct.shared.TinkerCommons;

public class EntityThrowball
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public ItemThrowball.ThrowballType type;

    public EntityThrowball(World worldIn) {
        super(worldIn);
    }

    public EntityThrowball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityThrowball(World worldIn, EntityLivingBase throwerIn, ItemThrowball.ThrowballType type) {
        super(worldIn, throwerIn);
        this.type = type;
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        if (this.type != null) {
            switch (this.type) {
                case GLOW: {
                    this.placeGlow(result);
                    break;
                }
                case EFLN: {
                    this.explode(6.0f);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70106_y();
        }
    }

    private void placeGlow(RayTraceResult result) {
        if (!this.func_130014_f_().field_72995_K) {
            BlockPos pos = result.func_178782_a();
            if (pos == null && result.field_72308_g != null) {
                pos = result.field_72308_g.func_180425_c();
            }
            EnumFacing facing = EnumFacing.DOWN;
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                pos = pos.func_177972_a(result.field_178784_b);
                facing = result.field_178784_b.func_176734_d();
            }
            TinkerCommons.blockGlow.addGlow(this.func_130014_f_(), pos, facing);
        }
    }

    protected void explode(float strength) {
        if (!this.func_130014_f_().field_72995_K) {
            Exploder.startExplosion(this.func_130014_f_(), new ExplosionEFLN(this.func_130014_f_(), (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, false, false), (Entity)this, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), strength, strength);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.ensureType();
        compound.func_74768_a("type", this.type.ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.type = ItemThrowball.ThrowballType.values()[compound.func_74762_e("type")];
        this.ensureType();
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.ensureType();
        buffer.writeInt(this.type.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = ItemThrowball.ThrowballType.values()[additionalData.readInt()];
        this.ensureType();
    }

    private void ensureType() {
        if (this.type == null) {
            this.type = ItemThrowball.ThrowballType.GLOW;
        }
    }
}

