/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.CustomFontRenderer;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.crosshair.CrosshairRenderEvents;
import slimeknights.tconstruct.library.client.material.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.material.deserializers.BlockRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.material.deserializers.ColoredRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.material.deserializers.InverseMultiColorRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.material.deserializers.MetalRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.material.deserializers.MultiColorRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.material.deserializers.TexturedMetalRenderInfoDeserializer;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModelLoader;
import slimeknights.tconstruct.library.client.particle.EntitySlimeFx;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.MaterialGUI;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.shared.client.ParticleEndspeed;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackCleaver;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackFrypan;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackHammer;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackHatchet;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackLongsword;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackLumberAxe;
import slimeknights.tconstruct.tools.common.client.particle.ParticleAttackRapier;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

public abstract class ClientProxy
extends CommonProxy {
    public static Material[] RenderMaterials;
    public static Material RenderMaterialString;
    public static final ResourceLocation BOOK_MODIFY;
    private static final Minecraft mc;
    public static CustomFontRenderer fontRenderer;
    protected static final ToolModelLoader loader;
    protected static final MaterialModelLoader materialLoader;
    protected static final ModifierModelLoader modifierLoader;

    public static void initClient() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)materialLoader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)modifierLoader);
        MaterialRenderInfoLoader.addRenderInfo("colored", ColoredRenderInfoDeserializer.class);
        MaterialRenderInfoLoader.addRenderInfo("multicolor", MultiColorRenderInfoDeserializer.class);
        MaterialRenderInfoLoader.addRenderInfo("inverse_multicolor", InverseMultiColorRenderInfoDeserializer.class);
        MaterialRenderInfoLoader.addRenderInfo("metal", MetalRenderInfoDeserializer.class);
        MaterialRenderInfoLoader.addRenderInfo("metal_textured", TexturedMetalRenderInfoDeserializer.class);
        MaterialRenderInfoLoader.addRenderInfo("block", BlockRenderInfoDeserializer.class);
    }

    public static void initRenderMaterials() {
        RenderMaterials = new Material[4];
        ClientProxy.RenderMaterials[0] = new MaterialGUI("_internal_render1");
        RenderMaterials[0].setRenderInfo(6835742);
        ClientProxy.RenderMaterials[1] = new MaterialGUI("_internal_render2");
        RenderMaterials[1].setRenderInfo(0xC1C1C1);
        ClientProxy.RenderMaterials[2] = new MaterialGUI("_internal_render3");
        RenderMaterials[2].setRenderInfo(2324189);
        ClientProxy.RenderMaterials[3] = new MaterialGUI("_internal_render4");
        RenderMaterials[3].setRenderInfo(7423664);
        RenderMaterialString = new MaterialGUI("_internal_renderString");
        RenderMaterialString.setRenderInfo(0xFFFFFF);
        Stream.concat(Stream.of(RenderMaterials), Stream.of(RenderMaterialString)).forEach(TinkerRegistry::addMaterial);
        if (TinkerHarvestTools.pickaxe != null) {
            TinkerRegistry.tabTools.setDisplayIcon(TinkerHarvestTools.pickaxe.buildItemForRendering((List<Material>)ImmutableList.of((Object)((Object)RenderMaterials[0]), (Object)((Object)RenderMaterials[1]), (Object)((Object)RenderMaterials[2]))));
        }
        if (TinkerTools.pickHead != null) {
            TinkerRegistry.tabParts.setDisplayIcon(TinkerTools.pickHead.getItemstackWithMaterial(RenderMaterials[2]));
        }
    }

    public static void initRenderer() {
        CustomTextureCreator creator = CustomTextureCreator.INSTANCE;
        MinecraftForge.EVENT_BUS.register((Object)creator);
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)mc.func_110442_L();
        resourceManager.func_110542_a((IResourceManagerReloadListener)MaterialRenderInfoLoader.INSTANCE);
        resourceManager.func_110542_a((IResourceManagerReloadListener)AbstractColoredTexture.CacheClearer.INSTANCE);
        resourceManager.func_110542_a((IResourceManagerReloadListener)creator);
        fontRenderer = new CustomFontRenderer(ClientProxy.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), ClientProxy.mc.field_71446_o);
        if (ClientProxy.mc.field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78264_a(mc.func_135016_M().func_135042_a() || ClientProxy.mc.field_71474_y.field_151455_aw);
            fontRenderer.func_78275_b(mc.func_135016_M().func_135044_b());
        }
        resourceManager.func_110542_a((IResourceManagerReloadListener)fontRenderer);
        CustomFontRenderer bookRenderer = new CustomFontRenderer(ClientProxy.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), ClientProxy.mc.field_71446_o);
        bookRenderer.func_78264_a(true);
        if (ClientProxy.mc.field_71474_y.field_74363_ab != null) {
            fontRenderer.func_78275_b(mc.func_135016_M().func_135044_b());
        }
        TinkerBook.INSTANCE.fontRenderer = bookRenderer;
        MinecraftForge.EVENT_BUS.register((Object)CrosshairRenderEvents.INSTANCE);
    }

    @Deprecated
    protected ResourceLocation registerModel(Item item, String ... customVariants) {
        return this.registerModel(item, 0, customVariants);
    }

    @Deprecated
    protected ResourceLocation registerModel(Item item, int meta, String ... customVariants) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item);
        if (o == null) {
            TConstruct.log.error("Trying to register a model for an unregistered item: %s" + item.func_77658_a());
            return null;
        }
        ResourceLocation location = o;
        location = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        if (customVariants.length > 0) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        }
        for (String customVariant : customVariants) {
            String custom = location.func_110624_b() + ":" + customVariant;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(custom)});
        }
        return location;
    }

    protected void registerItemModelTiC(ItemStack item, String name) {
        if (item != null && !StringUtils.func_151246_b((String)name)) {
            ModelRegisterUtil.registerItemModel(item, Util.getResource(name));
        }
    }

    @Override
    public void sendPacketToServerOnly(AbstractPacket packet) {
        TinkerNetwork.sendToServer(packet);
    }

    @Override
    public void spawnParticle(Particles particleType, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        if (world == null) {
            world = ClientProxy.mc.field_71441_e;
        }
        Particle effect = ClientProxy.createParticle(particleType, world, x, y, z, xSpeed, ySpeed, zSpeed, data);
        ClientProxy.mc.field_71452_i.func_78873_a(effect);
        if (particleType == Particles.EFFECT && data[0] > 1) {
            for (int i = 0; i < data[0] - 1; ++i) {
                effect = ClientProxy.createParticle(particleType, world, x, y, z, xSpeed, ySpeed, zSpeed, data);
                ClientProxy.mc.field_71452_i.func_78873_a(effect);
            }
        }
    }

    @Override
    public void spawnSlimeParticle(World world, double x, double y, double z) {
        ClientProxy.mc.field_71452_i.func_78873_a((Particle)new EntitySlimeFx(world, x, y, z, TinkerCommons.matSlimeBallBlue.func_77973_b(), TinkerCommons.matSlimeBallBlue.func_77952_i()));
    }

    public static Particle createParticle(Particles type, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... data) {
        switch (type) {
            case BLUE_SLIME: {
                return new EntitySlimeFx(world, x, y, z, TinkerCommons.matSlimeBallBlue.func_77973_b(), TinkerCommons.matSlimeBallBlue.func_77952_i());
            }
            case CLEAVER_ATTACK: {
                return new ParticleAttackCleaver(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case LONGSWORD_ATTACK: {
                return new ParticleAttackLongsword(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case RAPIER_ATTACK: {
                return new ParticleAttackRapier(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case HATCHET_ATTACK: {
                return new ParticleAttackHatchet(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case LUMBERAXE_ATTACK: {
                return new ParticleAttackLumberAxe(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case FRYPAN_ATTACK: {
                return new ParticleAttackFrypan(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case HAMMER_ATTACK: {
                return new ParticleAttackHammer(world, x, y, z, xSpeed, ySpeed, zSpeed, mc.func_110434_K());
            }
            case EFFECT: {
                return new ParticleEffect(data[1], world, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            case ENDSPEED: {
                return new ParticleEndspeed(world, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
        return null;
    }

    @Override
    public void preventPlayerSlowdown(Entity player, float originalSpeed, Item item) {
        EntityPlayerSP playerSP;
        ItemStack usingItem;
        if (player instanceof EntityPlayerSP && (usingItem = (playerSP = (EntityPlayerSP)player).func_184607_cu()) != null && usingItem.func_77973_b() == item) {
            playerSP.field_71158_b.field_78900_b *= originalSpeed * 5.0f;
            playerSP.field_71158_b.field_78902_a *= originalSpeed * 5.0f;
        }
    }

    @Override
    public void customExplosion(World world, Explosion explosion) {
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            // empty if block
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }

    @Override
    public void updateEquippedItemForRendering(EnumHand hand) {
        mc.func_175597_ag().func_187460_a(hand);
        mc.func_175597_ag().func_78441_a();
    }

    static {
        BOOK_MODIFY = Util.getResource("textures/gui/book/modify.png");
        mc = Minecraft.func_71410_x();
        loader = new ToolModelLoader();
        materialLoader = new MaterialModelLoader();
        modifierLoader = new ModifierModelLoader();
    }

    public static class PatternMeshDefinition
    implements ItemMeshDefinition {
        private final ResourceLocation baseLocation;

        public PatternMeshDefinition(ResourceLocation baseLocation) {
            this.baseLocation = baseLocation;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            Item item = Pattern.getPartFromTag(stack);
            String suffix = "";
            if (item != null) {
                suffix = Pattern.getTextureIdentifier(item);
            }
            return new ModelResourceLocation(new ResourceLocation(this.baseLocation.func_110624_b(), this.baseLocation.func_110623_a() + suffix), "inventory");
        }
    }
}

