/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class IMCIntegration {
    static final Logger log = Util.getLogger("IMC");

    private IMCIntegration() {
    }

    public static void integrateSmeltery(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String fluidName = tag.func_74779_i("fluid");
        String ore = tag.func_74779_i("ore");
        boolean toolforge = tag.func_74767_n("toolforge");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null && ore != null && !ore.isEmpty()) {
            boolean isNew = true;
            for (MaterialIntegration mi : TinkerIntegration.integrationList) {
                if (mi.fluid == null || !mi.fluid.getName().equals(fluidName)) continue;
                isNew = false;
            }
            if (isNew) {
                MaterialIntegration materialIntegration = new MaterialIntegration(null, fluid, ore);
                if (toolforge) {
                    materialIntegration.toolforge();
                }
                TinkerIntegration.integrationList.add(materialIntegration);
                materialIntegration.integrate();
                log.debug("Added integration smelting for " + ore + " from " + message.getSender());
            }
        }
        if (tag.func_74764_b("alloy")) {
            IMCIntegration.alloy(tag.func_150295_c("alloy", 10));
        }
    }

    public static void alloy(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            return;
        }
        IMCIntegration.alloy(message.getNBTValue().func_150295_c("alloy", 10));
    }

    private static void alloy(NBTTagList tagList) {
        TinkerIntegration.alloys.add(tagList);
    }

    public static void blacklistMelting(FMLInterModComms.IMCMessage message) {
        if (!message.isStringMessage() && !message.isItemStackMessage()) {
            return;
        }
        if (message.getMessageType() == String.class) {
            TinkerSmeltery.meltingBlacklist.addAll(OreDictionary.getOres((String)message.getStringValue(), (boolean)false));
            log.debug("Blacklisted oredictionary entry " + message.getStringValue() + " from melting");
        } else {
            TinkerSmeltery.meltingBlacklist.add(message.getItemStackValue());
            log.debug("Blacklisted " + message.getItemStackValue().func_77977_a() + " from melting");
        }
    }

    public static void addDryingRecipe(FMLInterModComms.IMCMessage message) {
        String ore;
        if (!message.isNBTMessage()) {
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        ItemStack input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("input"));
        ItemStack output = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("output"));
        int time = tag.func_74762_e("time") * 20;
        if (input != null && output != null && time > 0) {
            TinkerRegistry.registerDryingRecipe(input, output, time);
            log.debug("Added drying rack recipe from " + input.func_77977_a() + " to " + output.func_77977_a());
        } else if (input == null && !(ore = tag.func_74779_i("input")).isEmpty()) {
            TinkerRegistry.registerDryingRecipe(ore, output, time);
            log.debug("Added drying rack recipe from oredictionary " + ore + " to " + output.func_77977_a());
        }
    }
}

