/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.util;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.config.Config;
import landmaster.plustic.fluids.FluidMolten;
import landmaster.plustic.modifiers.ModEndlectric;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.smeltery.block.BlockMolten;

public class Utils {
    public static void integrate(Map<String, Material> materials, Map<String, MaterialIntegration> materialIntegrations) {
        materials.entrySet().forEach(ent -> {
            MaterialIntegration mi = ((Material)ent.getValue()).getFluid() != null ? new MaterialIntegration((Material)ent.getValue(), ((Material)ent.getValue()).getFluid(), StringUtils.capitalize((String)((String)ent.getKey()))).toolforge() : new MaterialIntegration((Material)ent.getValue());
            mi.integrate();
            mi.integrateRecipes();
            materialIntegrations.put((String)ent.getKey(), mi);
        });
    }

    public static void registerModifiers() {
        if (Config.enderIO && Loader.isModLoaded((String)"EnderIO")) {
            TinkerRegistry.registerModifier((IModifier)ModEndlectric.endlectric);
            Utils.addModifierItem((Modifier)ModEndlectric.endlectric, "enderio", "itemBasicCapacitor", 2);
        }
    }

    public static void addModifierItem(Modifier modifier, String modid, String name) {
        Utils.addModifierItem(modifier, modid, name, 0);
    }

    public static void addModifierItem(Modifier modifier, String modid, String name, int meta) {
        if (modifier == null) {
            return;
        }
        ItemStack is = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)), 1, meta);
        modifier.addItem(is, 1, 1);
    }

    public static FluidMolten fluidMetal(String name, int color) {
        return Utils.registerFluid(new FluidMolten(name, color));
    }

    public static void initFluidMetal(Fluid fluid) {
        Utils.registerMoltenBlock(fluid);
        PlusTiC.proxy.registerFluidModels(fluid);
    }

    public static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName("plustic." + fluid.getName().toLowerCase(Locale.US));
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    public static <T extends Block> T registerBlock(T block, String name) {
        block.func_149663_c("plustic." + name);
        block.setRegistryName("plustic." + name);
        Item ib = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)ib);
        return block;
    }

    public static BlockMolten registerMoltenBlock(Fluid fluid) {
        BlockMolten block = new BlockMolten(fluid);
        return Utils.registerBlock(block, "molten_" + fluid.getName());
    }

    public static void setDispItem(Material mat, String modid, String name) {
        if (mat == null) {
            return;
        }
        mat.setRepresentativeItem((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)));
    }

    public static void setDispItem(Material mat, String modid, String name, int meta) {
        if (mat == null) {
            return;
        }
        ItemStack is = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name)), 1, meta);
        mat.setRepresentativeItem(is);
    }

    public static void setDispItem(Material mat, String ore) {
        List ores = OreDictionary.getOres((String)ore);
        if (mat == null || ores.size() < 1) {
            return;
        }
        mat.setRepresentativeItem((ItemStack)ores.get(0));
    }

    public static int gcd(int a, int b, int ... rest) {
        if (rest.length > 0) {
            int[] rest1 = new int[rest.length - 1];
            System.arraycopy(rest, 1, rest1, 0, rest1.length);
            return Utils.gcd(Utils.gcd(a, b, new int[0]), rest[0], rest1);
        }
        return b == 0 ? a : Utils.gcd(b, a % b, new int[0]);
    }
}

