/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import landmaster.plustic.api.Toggle;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketSetPortal;
import landmaster.plustic.proxy.CommonProxy;
import landmaster.plustic.util.Coord4D;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class NickOfTime
extends AbstractTrait {
    public static final NickOfTime nickOfTime = new NickOfTime();
    public static final int ENDER_COST = 8;

    public NickOfTime() {
        super("nickoftime", 16775566);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.toggleable.add(this.identifier);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && FMLCommonHandler.instance().getSide().isClient() && CommonProxy.keyBindings.get(2).func_151468_f()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetPortal());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void timing(LivingHurtEvent event) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)event.getEntityLiving().func_184614_ca());
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayerMP && event.getEntityLiving().func_110143_aJ() <= event.getAmount() && TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)this.identifier) && Toggle.getToggleState(nbt, this.identifier) && nbt.func_150297_b("nickoftime", 10)) {
            Coord4D coord = Coord4D.fromNBT(nbt.func_74775_l("nickoftime"));
            if (this.canTeleport((EntityPlayer)event.getEntity(), coord)) {
                IItemHandler ih = (IItemHandler)event.getEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < ih.getSlots(); ++i) {
                    ItemStack is = ih.extractItem(i, 8, true);
                    if (is == null || is.func_77973_b() != Items.field_151079_bi || is.field_77994_a < 8) continue;
                    NickOfTime.teleportPlayerTo((EntityPlayerMP)event.getEntity(), coord);
                    ih.extractItem(i, 8, false);
                    event.setCanceled(true);
                    event.getEntityLiving().func_184589_d(MobEffects.field_82731_v);
                    event.getEntityLiving().func_184589_d(MobEffects.field_76436_u);
                    event.getEntityLiving().func_70066_B();
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 160));
                    event.getEntity().func_145747_a((ITextComponent)new TextComponentTranslation("msg.plustic.nickmodifier.use", new Object[0]));
                    return;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.isCanceled() || event.getItemStack() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            return;
        }
        if (nbt0.func_150297_b("nickoftime", 10)) {
            NBTTagCompound nbt = nbt0.func_74775_l("nickoftime");
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.plustic.nickmodifier.info", (Object[])new Object[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim")}));
        }
    }

    private boolean canTeleport(EntityPlayer player, Coord4D dest) {
        if (dest == null) {
            return false;
        }
        for (int i = 1; i <= 2; ++i) {
            if (dest.add(0, i, 0).blockState().func_177230_c() == Blocks.field_150350_a) continue;
            return false;
        }
        return true;
    }

    public static void teleportPlayerTo(EntityPlayerMP player, Coord4D coord) {
        if (player.field_71093_bK != coord.dimensionId) {
            int id = player.field_71093_bK;
            WorldServer oldWorld = player.field_71133_b.func_71218_a(player.field_71093_bK);
            player.field_71093_bK = coord.dimensionId;
            WorldServer newWorld = player.field_71133_b.func_71218_a(player.field_71093_bK);
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            oldWorld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            if (player.func_70089_S()) {
                newWorld.func_72838_d((Entity)player);
                player.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
                newWorld.func_72866_a((Entity)player, false);
                player.func_70029_a((World)newWorld);
            }
            player.field_71133_b.func_184103_al().func_72375_a(player, oldWorld);
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
            player.field_71134_c.func_73080_a(newWorld);
            player.field_71133_b.func_184103_al().func_72354_b(player, newWorld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, id, coord.dimensionId);
        } else {
            player.field_71135_a.func_147364_a((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, player.field_70177_z, player.field_70125_A);
        }
    }
}

