/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import java.util.ListIterator;
import landmaster.plustic.api.Toggle;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class Global
extends AbstractTrait {
    public static final Global global = new Global();

    public Global() {
        super("global", 16769265);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.toggleable.add(this.identifier);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K || event.getHarvester() == null) {
            return;
        }
        ItemStack tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)event.getHarvester(), (IBlockState)event.getState());
        if (!TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.getIdentifier())) {
            return;
        }
        this.__blockHarvestDrops(tool, event);
    }

    private void __blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (!Toggle.getToggleState(tool, this.identifier)) {
            return;
        }
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)tool);
        if (nbt0.func_150297_b("global", 10) && ToolHelper.isToolEffective2((ItemStack)tool, (IBlockState)event.getState())) {
            NBTTagCompound nbt = nbt0.func_74775_l("global");
            WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("dim"));
            if (world == null) {
                return;
            }
            TileEntity te = world.func_175625_s(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
            if (te == null) {
                return;
            }
            IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
            if (ih == null) {
                return;
            }
            ListIterator<ItemStack> it = event.getDrops().listIterator();
            block0: while (it.hasNext()) {
                ItemStack stk = (ItemStack)it.next();
                for (int j = 0; j < ih.getSlots(); ++j) {
                    ItemStack res = ih.insertItem(j, stk, false);
                    if (res == null || res.field_77994_a <= 0) {
                        it.remove();
                        continue block0;
                    }
                    it.set(res);
                    stk = res;
                }
            }
            te.func_70296_d();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        World world0 = event.getEntity().field_70170_p;
        if (world0.field_72995_K || event.getEntityLiving().func_110143_aJ() > 0.0f) {
            return;
        }
        ItemStack weapon = this.getWeapon(event.getSource());
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)weapon);
        if (TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            if (!Toggle.getToggleState(weapon, this.identifier)) {
                return;
            }
            if (nbt0.func_150297_b("global", 10)) {
                NBTTagCompound nbt = nbt0.func_74775_l("global");
                WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("dim"));
                if (world == null) {
                    return;
                }
                TileEntity te = world.func_175625_s(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
                if (te == null) {
                    return;
                }
                IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
                if (ih == null) {
                    return;
                }
                ListIterator it = event.getDrops().listIterator();
                block0: while (it.hasNext()) {
                    EntityItem enti = (EntityItem)it.next();
                    ItemStack stk = enti.func_92059_d();
                    for (int j = 0; j < ih.getSlots(); ++j) {
                        ItemStack res = ih.insertItem(j, stk, false);
                        if (res == null || res.field_77994_a <= 0) {
                            it.remove();
                            continue block0;
                        }
                        enti.func_92058_a(res);
                        stk = res;
                    }
                }
                te.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.getWorld().field_72995_K || event.isCanceled() || !event.getEntityPlayer().func_70093_af() || event.getItemStack() == null || event.getFace() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)this.getIdentifier())) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te == null || te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, event.getFace()) == null) {
            return;
        }
        NBTTagCompound global = new NBTTagCompound();
        global.func_74768_a("x", event.getPos().func_177958_n());
        global.func_74768_a("y", event.getPos().func_177956_o());
        global.func_74768_a("z", event.getPos().func_177952_p());
        global.func_74768_a("dim", event.getWorld().field_73011_w.getDimension());
        global.func_74774_a("facing", (byte)event.getFace().ordinal());
        nbt.func_74782_a("global", (NBTBase)global);
        event.getItemStack().func_77982_d(nbt);
        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("msg.plustic.globalmodifier.set", new Object[]{event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), event.getWorld().field_73011_w.getDimension()}));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.isCanceled() || event.getItemStack() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            return;
        }
        if (nbt0.func_150297_b("global", 10)) {
            NBTTagCompound nbt = nbt0.func_74775_l("global");
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.plustic.globalmodifier.info", (Object[])new Object[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim")}));
        }
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_184614_ca();
        }
        return null;
    }
}

