/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic;

import java.util.HashMap;
import java.util.Map;
import landmaster.plustic.api.Toggle;
import landmaster.plustic.block.MetalBlock;
import landmaster.plustic.config.Config;
import landmaster.plustic.fluids.FluidMolten;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.proxy.CommonProxy;
import landmaster.plustic.traits.Anticorrosion;
import landmaster.plustic.traits.Apocalypse;
import landmaster.plustic.traits.BloodyMary;
import landmaster.plustic.traits.DevilsStrength;
import landmaster.plustic.traits.DivineShield;
import landmaster.plustic.traits.Elemental;
import landmaster.plustic.traits.Explosive;
import landmaster.plustic.traits.Global;
import landmaster.plustic.traits.Light;
import landmaster.plustic.traits.Mana;
import landmaster.plustic.traits.NaturesBlessing;
import landmaster.plustic.traits.NaturesPower;
import landmaster.plustic.traits.NaturesWrath;
import landmaster.plustic.traits.NickOfTime;
import landmaster.plustic.traits.Portly;
import landmaster.plustic.traits.Terrafirma;
import landmaster.plustic.traits.Thundering;
import landmaster.plustic.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerTraits;

@Mod(modid="plustic", name="PlusTiC", version="3.1", dependencies="required-after:mantle;required-after:tconstruct;after:Mekanism;after:BiomesOPlenty;after:Botania;after:advancedRocketry;after:armorplus;after:EnderIO;after:projectred-exploration;after:thermalfoundation", acceptedMinecraftVersions="[1.10.2]")
public class PlusTiC {
    public static final String MODID = "plustic";
    public static final String NAME = "PlusTiC";
    public static final String VERSION = "3.1";
    public static final String DEPENDS = "required-after:mantle;required-after:tconstruct;after:Mekanism;after:BiomesOPlenty;after:Botania;after:advancedRocketry;after:armorplus;after:EnderIO;after:projectred-exploration;after:thermalfoundation";
    public static Config config;
    @Mod.Instance(value="plustic")
    public static PlusTiC INSTANCE;
    @SidedProxy(serverSide="landmaster.plustic.proxy.CommonProxy", clientSide="landmaster.plustic.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static Map<String, Material> materials;
    public static Map<String, MaterialIntegration> materialIntegrations;
    public static final BowMaterialStats justWhy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config config = new Config(event);
        config.sync();
        this.initBase();
        this.initBoP();
        this.initMekanism();
        this.initBotania();
        this.initAdvRocketry();
        this.initArmorPlus();
        this.initEnderIO();
        this.initTF();
        Utils.integrate(materials, materialIntegrations);
        Utils.registerModifiers();
    }

    private void initBase() {
        if (Config.base) {
            Material tnt = new Material("tnt", TextFormatting.RED);
            tnt.addTrait((ITrait)Explosive.explosive);
            tnt.addItem(Blocks.field_150335_W, 144);
            tnt.setRepresentativeItem(Blocks.field_150335_W);
            tnt.setCraftable(true);
            proxy.setRenderInfo(tnt, 0xFF4F4F);
            TinkerRegistry.addMaterialStats((Material)tnt, (IMaterialStats)new ArrowShaftMaterialStats(0.95f, 0));
            materials.put("tnt", tnt);
            if (TinkerIntegration.isIntegrated((Fluid)TinkerFluids.aluminum)) {
                Item alumiteIngot = (Item)new Item().func_77655_b("alumiteingot").setRegistryName("alumiteingot");
                alumiteIngot.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
                GameRegistry.register((IForgeRegistryEntry)alumiteIngot);
                OreDictionary.registerOre((String)"ingotAlumite", (Item)alumiteIngot);
                proxy.registerItemRenderer(alumiteIngot, 0, "alumiteingot");
                Item alumiteNugget = (Item)new Item().func_77655_b("alumitenugget").setRegistryName("alumitenugget");
                alumiteNugget.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
                GameRegistry.register((IForgeRegistryEntry)alumiteNugget);
                OreDictionary.registerOre((String)"nuggetAlumite", (Item)alumiteNugget);
                proxy.registerItemRenderer(alumiteNugget, 0, "alumitenugget");
                MetalBlock alumiteBlock = new MetalBlock("alumiteblock");
                alumiteBlock.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
                ItemBlock alumiteBlock_item = new ItemBlock((Block)alumiteBlock);
                GameRegistry.register((IForgeRegistryEntry)alumiteBlock);
                GameRegistry.register((IForgeRegistryEntry)alumiteBlock_item, (ResourceLocation)alumiteBlock.getRegistryName());
                OreDictionary.registerOre((String)"blockAlumite", (Block)alumiteBlock);
                proxy.registerItemRenderer((Item)alumiteBlock_item, 0, "alumiteblock");
                Material alumite = new Material("alumite", TextFormatting.RED);
                alumite.addTrait((ITrait)Global.global);
                alumite.addItem("ingotAlumite", 1, 144);
                alumite.setCraftable(false).setCastable(true);
                alumite.setRepresentativeItem(alumiteIngot);
                proxy.setRenderInfo(alumite, 16769265);
                FluidMolten alumiteFluid = Utils.fluidMetal("alumite", 16769265);
                alumiteFluid.setTemperature(890);
                Utils.initFluidMetal((Fluid)alumiteFluid);
                alumite.setFluid((Fluid)alumiteFluid);
                TinkerRegistry.registerAlloy((FluidStack)new FluidStack((Fluid)alumiteFluid, 3), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.aluminum, 5), new FluidStack((Fluid)TinkerFluids.iron, 2), new FluidStack((Fluid)TinkerFluids.obsidian, 2)});
                TinkerRegistry.addMaterialStats((Material)alumite, (IMaterialStats)new HeadMaterialStats(700, 6.8f, 5.5f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.1f, 70), new ExtraMaterialStats(80), new BowMaterialStats(0.65f, 1.6f, 7.0f)});
                materials.put("alumite", alumite);
            }
        }
    }

    private void initBoP() {
        if (Config.bop && Loader.isModLoaded((String)"BiomesOPlenty") || Config.projectRed && Loader.isModLoaded((String)"projectred-exploration")) {
            Material sapphire = new Material("sapphire", TextFormatting.BLUE);
            sapphire.addTrait((ITrait)TinkerTraits.aquadynamic);
            sapphire.addItem("gemSapphire", 1, 144);
            sapphire.setCraftable(true);
            proxy.setRenderInfo(sapphire, 255);
            TinkerRegistry.addMaterialStats((Material)sapphire, (IMaterialStats)new HeadMaterialStats(700, 5.0f, 6.4f, 4));
            TinkerRegistry.addMaterialStats((Material)sapphire, (IMaterialStats)new HandleMaterialStats(1.0f, 100));
            TinkerRegistry.addMaterialStats((Material)sapphire, (IMaterialStats)new ExtraMaterialStats(120));
            TinkerRegistry.addMaterialStats((Material)sapphire, (IMaterialStats)new BowMaterialStats(1.0f, 1.5f, 4.0f));
            materials.put("sapphire", sapphire);
            Material ruby = new Material("ruby", TextFormatting.RED);
            ruby.addTrait((ITrait)BloodyMary.bloodymary);
            ruby.addTrait((ITrait)TinkerTraits.sharp, "head");
            ruby.addItem("gemRuby", 1, 144);
            ruby.setCraftable(true);
            proxy.setRenderInfo(ruby, 0xFF0000);
            TinkerRegistry.addMaterialStats((Material)ruby, (IMaterialStats)new HeadMaterialStats(660, 4.6f, 6.4f, 4));
            TinkerRegistry.addMaterialStats((Material)ruby, (IMaterialStats)new HandleMaterialStats(1.2f, 0));
            TinkerRegistry.addMaterialStats((Material)ruby, (IMaterialStats)new ExtraMaterialStats(20));
            TinkerRegistry.addMaterialStats((Material)ruby, (IMaterialStats)new BowMaterialStats(1.5f, 1.4f, 4.0f));
            materials.put("ruby", ruby);
            Material peridot = new Material("peridot", TextFormatting.GREEN);
            peridot.addTrait((ITrait)NaturesBlessing.naturesblessing);
            peridot.addItem("gemPeridot", 1, 144);
            peridot.setCraftable(true);
            proxy.setRenderInfo(peridot, 12515932);
            TinkerRegistry.addMaterialStats((Material)peridot, (IMaterialStats)new HeadMaterialStats(640, 4.0f, 6.1f, 4));
            TinkerRegistry.addMaterialStats((Material)peridot, (IMaterialStats)new HandleMaterialStats(1.3f, -30));
            TinkerRegistry.addMaterialStats((Material)peridot, (IMaterialStats)new ExtraMaterialStats(20));
            TinkerRegistry.addMaterialStats((Material)peridot, (IMaterialStats)new BowMaterialStats(1.4f, 1.4f, 4.0f));
            materials.put("peridot", peridot);
        }
        if (Config.bop && Loader.isModLoaded((String)"BiomesOPlenty")) {
            Material malachite = new Material("malachite_gem", TextFormatting.DARK_GREEN);
            malachite.addTrait((ITrait)NaturesWrath.natureswrath);
            malachite.addItem("gemMalachite", 1, 144);
            malachite.setCraftable(true);
            Utils.setDispItem(malachite, "biomesoplenty", "gem", 5);
            proxy.setRenderInfo(malachite, 29987);
            TinkerRegistry.addMaterialStats((Material)malachite, (IMaterialStats)new HeadMaterialStats(640, 3.0f, 6.1f, 4));
            TinkerRegistry.addMaterialStats((Material)malachite, (IMaterialStats)new HandleMaterialStats(1.3f, -30));
            TinkerRegistry.addMaterialStats((Material)malachite, (IMaterialStats)new ExtraMaterialStats(20));
            TinkerRegistry.addMaterialStats((Material)malachite, (IMaterialStats)new BowMaterialStats(1.4f, 1.4f, 4.0f));
            materials.put("malachite", malachite);
            Material amber = new Material("amber", TextFormatting.GOLD);
            amber.addTrait((ITrait)TinkerTraits.shocking);
            amber.addTrait((ITrait)Thundering.thundering, "projectile");
            amber.addTrait((ITrait)Thundering.thundering, "shaft");
            amber.addItem("gemAmber", 1, 144);
            amber.setCraftable(true);
            Utils.setDispItem(amber, "biomesoplenty", "gem", 7);
            proxy.setRenderInfo(amber, 0xFFD000);
            TinkerRegistry.addMaterialStats((Material)amber, (IMaterialStats)new HeadMaterialStats(730, 4.6f, 5.7f, 4));
            TinkerRegistry.addMaterialStats((Material)amber, (IMaterialStats)new HandleMaterialStats(1.0f, 30));
            TinkerRegistry.addMaterialStats((Material)amber, (IMaterialStats)new ExtraMaterialStats(100));
            TinkerRegistry.addMaterialStats((Material)amber, (IMaterialStats)justWhy);
            TinkerRegistry.addMaterialStats((Material)amber, (IMaterialStats)new ArrowShaftMaterialStats(1.0f, 5));
            materials.put("amber", amber);
            Material topaz = new Material("topaz", TextFormatting.GOLD);
            topaz.addTrait((ITrait)NaturesPower.naturespower);
            topaz.addItem("gemTopaz", 1, 144);
            topaz.setCraftable(true);
            Utils.setDispItem(topaz, "biomesoplenty", "gem", 3);
            proxy.setRenderInfo(topaz, 0xFFFF00);
            TinkerRegistry.addMaterialStats((Material)topaz, (IMaterialStats)new HeadMaterialStats(690, 6.0f, 6.0f, 4));
            TinkerRegistry.addMaterialStats((Material)topaz, (IMaterialStats)new HandleMaterialStats(0.8f, 70));
            TinkerRegistry.addMaterialStats((Material)topaz, (IMaterialStats)new ExtraMaterialStats(65));
            TinkerRegistry.addMaterialStats((Material)topaz, (IMaterialStats)new BowMaterialStats(0.4f, 1.4f, 7.0f));
            materials.put("topaz", topaz);
            Material tanzanite = new Material("tanzanite", TextFormatting.LIGHT_PURPLE);
            tanzanite.addTrait((ITrait)TinkerTraits.freezing);
            tanzanite.addItem("gemTanzanite", 1, 144);
            tanzanite.setCraftable(true);
            Utils.setDispItem(tanzanite, "biomesoplenty", "gem", 4);
            proxy.setRenderInfo(tanzanite, 6422783);
            TinkerRegistry.addMaterialStats((Material)tanzanite, (IMaterialStats)new HeadMaterialStats(650, 3.0f, 7.0f, 4));
            TinkerRegistry.addMaterialStats((Material)tanzanite, (IMaterialStats)new HandleMaterialStats(0.7f, 0));
            TinkerRegistry.addMaterialStats((Material)tanzanite, (IMaterialStats)new ExtraMaterialStats(25));
            TinkerRegistry.addMaterialStats((Material)tanzanite, (IMaterialStats)justWhy);
            materials.put("tanzanite", tanzanite);
            Material amethyst = new Material("amethyst", TextFormatting.LIGHT_PURPLE);
            amethyst.addTrait((ITrait)Apocalypse.apocalypse);
            amethyst.addItem((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("biomesoplenty", "gem")), 1, 144);
            amethyst.setCraftable(true);
            Utils.setDispItem(amethyst, "biomesoplenty", "gem");
            proxy.setRenderInfo(amethyst, 0xFF00FF);
            TinkerRegistry.addMaterialStats((Material)amethyst, (IMaterialStats)new HeadMaterialStats(1200, 6.0f, 10.0f, 4));
            TinkerRegistry.addMaterialStats((Material)amethyst, (IMaterialStats)new HandleMaterialStats(1.6f, 100));
            TinkerRegistry.addMaterialStats((Material)amethyst, (IMaterialStats)new ExtraMaterialStats(100));
            TinkerRegistry.addMaterialStats((Material)amethyst, (IMaterialStats)new BowMaterialStats(0.65f, 1.7f, 6.5f));
            materials.put("amethyst", amethyst);
        }
    }

    private void initMekanism() {
        if (Config.mekanism && Loader.isModLoaded((String)"Mekanism")) {
            Item tinDust = (Item)new Item().func_77655_b("tindust").setRegistryName("tindust");
            tinDust.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
            GameRegistry.register((IForgeRegistryEntry)tinDust);
            OreDictionary.registerOre((String)"dustTin", (Item)tinDust);
            proxy.registerItemRenderer(tinDust, 0, "tindust");
            Item osmiumDust = (Item)new Item().func_77655_b("osmiumdust").setRegistryName("osmiumdust");
            osmiumDust.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
            GameRegistry.register((IForgeRegistryEntry)osmiumDust);
            OreDictionary.registerOre((String)"dustOsmium", (Item)osmiumDust);
            proxy.registerItemRenderer(osmiumDust, 0, "osmiumdust");
            Item steelDust = (Item)new Item().func_77655_b("steeldust").setRegistryName("steeldust");
            steelDust.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
            GameRegistry.register((IForgeRegistryEntry)steelDust);
            OreDictionary.registerOre((String)"dustSteel", (Item)steelDust);
            proxy.registerItemRenderer(steelDust, 0, "steeldust");
            Item bronzeNugget = (Item)new Item().func_77655_b("bronzenugget").setRegistryName("bronzenugget");
            bronzeNugget.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
            GameRegistry.register((IForgeRegistryEntry)bronzeNugget);
            OreDictionary.registerOre((String)"nuggetBronze", (Item)bronzeNugget);
            proxy.registerItemRenderer(bronzeNugget, 0, "bronzenugget");
            Item bronzeIngot = (Item)new Item().func_77655_b("bronzeingot").setRegistryName("bronzeingot");
            bronzeIngot.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
            GameRegistry.register((IForgeRegistryEntry)bronzeIngot);
            OreDictionary.registerOre((String)"ingotBronze", (Item)bronzeIngot);
            proxy.registerItemRenderer(bronzeIngot, 0, "bronzeingot");
            if (OreDictionary.getOres((String)"ingotTin").size() == 0 || TinkerRegistry.getMelting((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0))) == null) {
                MaterialIntegration tinI = new MaterialIntegration(null, (Fluid)TinkerFluids.tin, "Tin");
                tinI.integrate();
                tinI.integrateRecipes();
                materialIntegrations.put("tin", tinI);
            }
            Material osmium = new Material("osmium", TextFormatting.BLUE);
            osmium.addTrait((ITrait)TinkerTraits.dense);
            osmium.addTrait((ITrait)TinkerTraits.established);
            osmium.addItem("ingotOsmium", 1, 144);
            osmium.setCraftable(false).setCastable(true);
            proxy.setRenderInfo(osmium, 12570879);
            FluidMolten osmiumFluid = Utils.fluidMetal("osmium", 12570879);
            osmiumFluid.setTemperature(820);
            Utils.initFluidMetal((Fluid)osmiumFluid);
            osmium.setFluid((Fluid)osmiumFluid);
            TinkerRegistry.addMaterialStats((Material)osmium, (IMaterialStats)new HeadMaterialStats(500, 6.0f, 5.8f, 2));
            TinkerRegistry.addMaterialStats((Material)osmium, (IMaterialStats)new HandleMaterialStats(1.2f, 45));
            TinkerRegistry.addMaterialStats((Material)osmium, (IMaterialStats)new ExtraMaterialStats(40));
            TinkerRegistry.addMaterialStats((Material)osmium, (IMaterialStats)new BowMaterialStats(0.65f, 1.3f, 5.7f));
            materials.put("osmium", osmium);
            Material refinedObsidian = new Material("refinedObsidian", TextFormatting.LIGHT_PURPLE);
            refinedObsidian.addTrait((ITrait)TinkerTraits.dense);
            refinedObsidian.addTrait((ITrait)TinkerTraits.duritos);
            refinedObsidian.addItem("ingotRefinedObsidian", 1, 144);
            refinedObsidian.setCraftable(false).setCastable(true);
            proxy.setRenderInfo(refinedObsidian, 6095103);
            FluidMolten refinedObsidianFluid = Utils.fluidMetal("refinedObsidian", 6095103);
            refinedObsidianFluid.setTemperature(860);
            Utils.initFluidMetal((Fluid)refinedObsidianFluid);
            refinedObsidian.setFluid((Fluid)refinedObsidianFluid);
            TinkerRegistry.addMaterialStats((Material)refinedObsidian, (IMaterialStats)new HeadMaterialStats(2500, 7.0f, 11.0f, 4));
            TinkerRegistry.addMaterialStats((Material)refinedObsidian, (IMaterialStats)new HandleMaterialStats(1.5f, -100));
            TinkerRegistry.addMaterialStats((Material)refinedObsidian, (IMaterialStats)new ExtraMaterialStats(160));
            TinkerRegistry.addMaterialStats((Material)refinedObsidian, (IMaterialStats)justWhy);
            materials.put("refinedObsidian", refinedObsidian);
        }
    }

    private void initBotania() {
        if (Config.botania && Loader.isModLoaded((String)"Botania")) {
            Material terrasteel = new Material("terrasteel", TextFormatting.GREEN);
            terrasteel.addTrait((ITrait)Mana.mana);
            terrasteel.addTrait((ITrait)Terrafirma.terrafirma[0]);
            terrasteel.addTrait((ITrait)Terrafirma.terrafirma[1], "head");
            terrasteel.addItem("ingotTerrasteel", 1, 144);
            terrasteel.setCraftable(false).setCastable(true);
            Utils.setDispItem(terrasteel, "botania", "manaResource", 4);
            proxy.setRenderInfo(terrasteel, 65280);
            FluidMolten terrasteelFluid = Utils.fluidMetal("terrasteel", 65280);
            terrasteelFluid.setTemperature(760);
            Utils.initFluidMetal((Fluid)terrasteelFluid);
            terrasteel.setFluid((Fluid)terrasteelFluid);
            TinkerRegistry.addMaterialStats((Material)terrasteel, (IMaterialStats)new HeadMaterialStats(1562, 9.0f, 5.0f, 3));
            TinkerRegistry.addMaterialStats((Material)terrasteel, (IMaterialStats)new HandleMaterialStats(1.0f, 10));
            TinkerRegistry.addMaterialStats((Material)terrasteel, (IMaterialStats)new ExtraMaterialStats(10));
            TinkerRegistry.addMaterialStats((Material)terrasteel, (IMaterialStats)new BowMaterialStats(0.4f, 2.0f, 9.0f));
            materials.put("terrasteel", terrasteel);
            Material elementium = new Material("elementium", TextFormatting.LIGHT_PURPLE);
            elementium.addTrait((ITrait)Mana.mana);
            elementium.addTrait((ITrait)Elemental.elemental, "head");
            elementium.addItem("ingotElvenElementium", 1, 144);
            elementium.setCraftable(false).setCastable(true);
            Utils.setDispItem(elementium, "botania", "manaResource", 7);
            proxy.setRenderInfo(elementium, 16149245);
            FluidMolten elementiumFluid = Utils.fluidMetal("elementium", 16149245);
            elementiumFluid.setTemperature(800);
            Utils.initFluidMetal((Fluid)elementiumFluid);
            elementium.setFluid((Fluid)elementiumFluid);
            TinkerRegistry.addMaterialStats((Material)elementium, (IMaterialStats)new HeadMaterialStats(204, 6.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.85f, 60), new ExtraMaterialStats(50)});
            TinkerRegistry.addMaterialStats((Material)elementium, (IMaterialStats)new BowMaterialStats(0.5f, 1.5f, 7.0f));
            materials.put("elvenElementium", elementium);
            Material manasteel = new Material("manasteel", TextFormatting.BLUE);
            manasteel.addTrait((ITrait)Mana.mana);
            manasteel.addItem("ingotManasteel", 1, 144);
            manasteel.setCraftable(false).setCastable(true);
            Utils.setDispItem(manasteel, "botania", "manaResource");
            proxy.setRenderInfo(manasteel, 5563903);
            FluidMolten manasteelFluid = Utils.fluidMetal("manasteel", 5563903);
            manasteelFluid.setTemperature(681);
            Utils.initFluidMetal((Fluid)manasteelFluid);
            manasteel.setFluid((Fluid)manasteelFluid);
            TinkerRegistry.addMaterialStats((Material)manasteel, (IMaterialStats)new HeadMaterialStats(540, 7.0f, 6.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.25f, 150), new ExtraMaterialStats(60)});
            TinkerRegistry.addMaterialStats((Material)manasteel, (IMaterialStats)new BowMaterialStats(1.0f, 1.1f, 1.0f));
            materials.put("manasteel", manasteel);
        }
    }

    private void initAdvRocketry() {
        if (Config.advancedRocketry && Loader.isModLoaded((String)"libVulpes")) {
            Material iridium = new Material("iridium", TextFormatting.GRAY);
            iridium.addTrait((ITrait)TinkerTraits.dense);
            iridium.addTrait((ITrait)TinkerTraits.alien, "head");
            iridium.addItem("ingotIridium", 1, 144);
            iridium.setCraftable(false).setCastable(true);
            Utils.setDispItem(iridium, "libvulpes", "productingot", 10);
            proxy.setRenderInfo(iridium, 0xE5E5E5);
            FluidMolten iridiumFluid = Utils.fluidMetal("iridium", 0xE5E5E5);
            iridiumFluid.setTemperature(810);
            Utils.initFluidMetal((Fluid)iridiumFluid);
            iridium.setFluid((Fluid)iridiumFluid);
            TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new HeadMaterialStats(520, 6.0f, 5.8f, 2));
            TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new HandleMaterialStats(1.15f, -20));
            TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)new ExtraMaterialStats(60));
            TinkerRegistry.addMaterialStats((Material)iridium, (IMaterialStats)justWhy);
            materials.put("iridium", iridium);
            Material titanium = new Material("titanium", TextFormatting.WHITE);
            titanium.addTrait((ITrait)Light.light);
            titanium.addTrait((ITrait)Anticorrosion.anticorrosion, "head");
            titanium.addItem("ingotTitanium", 1, 144);
            titanium.setCraftable(false).setCastable(true);
            Utils.setDispItem(titanium, "libvulpes", "productingot", 7);
            proxy.setRenderInfo(titanium, 14475754);
            FluidMolten titaniumFluid = Utils.fluidMetal("titanium", 14475754);
            titaniumFluid.setTemperature(790);
            Utils.initFluidMetal((Fluid)titaniumFluid);
            titanium.setFluid((Fluid)titaniumFluid);
            TinkerRegistry.addMaterialStats((Material)titanium, (IMaterialStats)new HeadMaterialStats(560, 6.0f, 6.0f, 3));
            TinkerRegistry.addMaterialStats((Material)titanium, (IMaterialStats)new HandleMaterialStats(1.4f, 0));
            TinkerRegistry.addMaterialStats((Material)titanium, (IMaterialStats)new ExtraMaterialStats(40));
            TinkerRegistry.addMaterialStats((Material)titanium, (IMaterialStats)new BowMaterialStats(1.15f, 1.3f, 6.6f));
            TinkerRegistry.addMaterialStats((Material)titanium, (IMaterialStats)new FletchingMaterialStats(1.0f, 1.3f));
            materials.put("titanium", titanium);
            if (Config.mekanism && Loader.isModLoaded((String)"Mekanism")) {
                Item osmiridiumIngot = (Item)new Item().func_77655_b("osmiridiumingot").setRegistryName("osmiridiumingot");
                osmiridiumIngot.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
                GameRegistry.register((IForgeRegistryEntry)osmiridiumIngot);
                OreDictionary.registerOre((String)"ingotOsmiridium", (Item)osmiridiumIngot);
                proxy.registerItemRenderer(osmiridiumIngot, 0, "osmiridiumingot");
                Item osmiridiumNugget = (Item)new Item().func_77655_b("osmiridiumnugget").setRegistryName("osmiridiumnugget");
                osmiridiumNugget.func_77637_a((CreativeTabs)TinkerRegistry.tabGeneral);
                GameRegistry.register((IForgeRegistryEntry)osmiridiumNugget);
                OreDictionary.registerOre((String)"nuggetOsmiridium", (Item)osmiridiumNugget);
                proxy.registerItemRenderer(osmiridiumNugget, 0, "osmiridiumnugget");
                MetalBlock osmiridiumBlock = new MetalBlock("osmiridiumblock");
                osmiridiumBlock.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
                ItemBlock osmiridiumBlock_item = new ItemBlock((Block)osmiridiumBlock);
                GameRegistry.register((IForgeRegistryEntry)osmiridiumBlock);
                GameRegistry.register((IForgeRegistryEntry)osmiridiumBlock_item, (ResourceLocation)osmiridiumBlock.getRegistryName());
                OreDictionary.registerOre((String)"blockOsmiridium", (Block)osmiridiumBlock);
                proxy.registerItemRenderer((Item)osmiridiumBlock_item, 0, "osmiridiumblock");
                Material osmiridium = new Material("osmiridium", TextFormatting.LIGHT_PURPLE);
                osmiridium.addTrait((ITrait)DevilsStrength.devilsstrength);
                osmiridium.addTrait((ITrait)Anticorrosion.anticorrosion, "head");
                osmiridium.addItem("ingotOsmiridium", 1, 144);
                osmiridium.setCraftable(false).setCastable(true);
                osmiridium.setRepresentativeItem(osmiridiumIngot);
                proxy.setRenderInfo(osmiridium, 0x666DFF);
                FluidMolten osmiridiumFluid = Utils.fluidMetal("osmiridium", 0x666DFF);
                osmiridiumFluid.setTemperature(840);
                Utils.initFluidMetal((Fluid)osmiridiumFluid);
                osmiridium.setFluid((Fluid)osmiridiumFluid);
                TinkerRegistry.registerAlloy((FluidStack)new FluidStack((Fluid)osmiridiumFluid, 2), (FluidStack[])new FluidStack[]{new FluidStack(materials.get("osmium").getFluid(), 1), new FluidStack((Fluid)iridiumFluid, 1)});
                TinkerRegistry.addMaterialStats((Material)osmiridium, (IMaterialStats)new HeadMaterialStats(1300, 6.8f, 8.0f, 4));
                TinkerRegistry.addMaterialStats((Material)osmiridium, (IMaterialStats)new HandleMaterialStats(1.5f, 30));
                TinkerRegistry.addMaterialStats((Material)osmiridium, (IMaterialStats)new ExtraMaterialStats(80));
                TinkerRegistry.addMaterialStats((Material)osmiridium, (IMaterialStats)new BowMaterialStats(0.38f, 2.05f, 10.0f));
                materials.put("osmiridium", osmiridium);
            }
        }
    }

    private void initArmorPlus() {
        if (Config.armorPlus && Loader.isModLoaded((String)"armorplus")) {
            Material witherBone = new Material("witherbone", TextFormatting.BLACK);
            witherBone.addTrait((ITrait)Apocalypse.apocalypse);
            witherBone.addItem("witherBone", 1, 144);
            witherBone.setCraftable(true);
            proxy.setRenderInfo(witherBone, 0);
            TinkerRegistry.addMaterialStats((Material)witherBone, (IMaterialStats)new ArrowShaftMaterialStats(1.0f, 20));
            materials.put("witherbone", witherBone);
            Material guardianScale = new Material("guardianscale", TextFormatting.AQUA);
            guardianScale.addTrait((ITrait)DivineShield.divineShield, "head");
            guardianScale.addTrait((ITrait)TinkerTraits.aquadynamic);
            guardianScale.addItem("scaleGuardian", 1, 144);
            guardianScale.setCraftable(true);
            proxy.setRenderInfo(guardianScale, 65535);
            TinkerRegistry.addMaterialStats((Material)guardianScale, (IMaterialStats)new HeadMaterialStats(600, 6.2f, 7.0f, 4));
            TinkerRegistry.addMaterialStats((Material)guardianScale, (IMaterialStats)new HandleMaterialStats(0.9f, 40));
            TinkerRegistry.addMaterialStats((Material)guardianScale, (IMaterialStats)new ExtraMaterialStats(80));
            TinkerRegistry.addMaterialStats((Material)guardianScale, (IMaterialStats)new BowMaterialStats(0.85f, 1.2f, 5.5f));
            materials.put("guardianscale", guardianScale);
        }
    }

    private void initEnderIO() {
        if (Config.enderIO && Loader.isModLoaded((String)"EnderIO")) {
            FluidMolten coalFluid = Utils.fluidMetal("coal", 0x111111);
            coalFluid.setTemperature(500);
            Utils.initFluidMetal((Fluid)coalFluid);
            TinkerRegistry.registerMelting((String)"coal", (Fluid)coalFluid, (int)100);
            TinkerRegistry.registerBasinCasting((ItemStack)new ItemStack(Blocks.field_150402_ci), null, (Fluid)coalFluid, (int)900);
            TinkerRegistry.registerTableCasting((ItemStack)new ItemStack(Items.field_151044_h), null, (Fluid)coalFluid, (int)100);
            Material darkSteel = new Material("darksteel_plustic_enderio", TextFormatting.DARK_GRAY);
            darkSteel.addTrait((ITrait)Portly.portly, "head");
            darkSteel.addTrait((ITrait)TinkerTraits.coldblooded);
            darkSteel.addItem("ingotDarkSteel", 1, 144);
            darkSteel.setCraftable(false).setCastable(true);
            Utils.setDispItem(darkSteel, "enderio", "itemAlloy", 6);
            proxy.setRenderInfo(darkSteel, 0x333333);
            Fluid darkSteelFluid = FluidRegistry.getFluid((String)"darksteel");
            darkSteel.setFluid(darkSteelFluid);
            TinkerRegistry.registerAlloy((FluidStack)new FluidStack(darkSteelFluid, 36), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.obsidian, 72), new FluidStack((Fluid)TinkerFluids.iron, 36), new FluidStack((Fluid)coalFluid, 25)});
            TinkerRegistry.addMaterialStats((Material)darkSteel, (IMaterialStats)new HeadMaterialStats(666, 7.0f, 4.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, 40), new ExtraMaterialStats(40), new BowMaterialStats(0.38f, 2.05f, 10.0f)});
            materials.put("darkSteel", darkSteel);
        }
    }

    private void initTF() {
        if (Config.thermalFoundation && Loader.isModLoaded((String)"thermalfoundation")) {
            Material signalum = new Material("signalum_plustic", TextFormatting.RED);
            signalum.addTrait((ITrait)BloodyMary.bloodymary);
            signalum.addItem("ingotSignalum", 1, 144);
            signalum.setCraftable(false).setCastable(true);
            Utils.setDispItem(signalum, "ingotSignalum");
            proxy.setRenderInfo(signalum, 14172416);
            FluidMolten signalumFluid = Utils.fluidMetal("signalum", 14172416);
            signalumFluid.setTemperature(930);
            Utils.initFluidMetal((Fluid)signalumFluid);
            signalum.setFluid((Fluid)signalumFluid);
            TinkerRegistry.registerAlloy((FluidStack)new FluidStack((Fluid)signalumFluid, 72), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.copper, 54), new FluidStack((Fluid)TinkerFluids.silver, 18), new FluidStack(FluidRegistry.getFluid((String)"redstone"), 125)});
            TinkerRegistry.addMaterialStats((Material)signalum, (IMaterialStats)new HeadMaterialStats(690, 7.5f, 5.2f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 0), new ExtraMaterialStats(55), new BowMaterialStats(1.2f, 1.6f, 4.4f)});
            materials.put("signalum", signalum);
            Material enderium = new Material("enderium_plustic", TextFormatting.DARK_GREEN);
            enderium.addTrait((ITrait)Portly.portly, "head");
            enderium.addTrait((ITrait)Global.global);
            enderium.addTrait((ITrait)TinkerTraits.enderference);
            enderium.addTrait((ITrait)TinkerTraits.endspeed, "projectile");
            enderium.addTrait((ITrait)TinkerTraits.endspeed, "shaft");
            enderium.addItem("ingotEnderium", 1, 144);
            enderium.setCraftable(false).setCastable(true);
            Utils.setDispItem(enderium, "ingotEnderium");
            proxy.setRenderInfo(enderium, 28776);
            FluidMolten platinumFluid = Utils.fluidMetal("platinum", 12052479);
            platinumFluid.setTemperature(680);
            Utils.initFluidMetal((Fluid)platinumFluid);
            MaterialIntegration platinumI = new MaterialIntegration(null, (Fluid)platinumFluid, "Platinum");
            platinumI.integrate();
            platinumI.integrateRecipes();
            materialIntegrations.put("platinum", platinumI);
            FluidMolten enderiumFluid = Utils.fluidMetal("enderium", 28776);
            enderiumFluid.setTemperature(970);
            Utils.initFluidMetal((Fluid)enderiumFluid);
            enderium.setFluid((Fluid)enderiumFluid);
            TinkerRegistry.registerAlloy((FluidStack)new FluidStack((Fluid)enderiumFluid, 144), (FluidStack[])new FluidStack[]{new FluidStack((Fluid)TinkerFluids.tin, 72), new FluidStack((Fluid)TinkerFluids.silver, 36), new FluidStack((Fluid)platinumFluid, 36), new FluidStack(FluidRegistry.getFluid((String)"ender"), 250), new FluidStack(FluidRegistry.getFluid((String)"pyrotheum"), 125)});
            TinkerRegistry.addMaterialStats((Material)enderium, (IMaterialStats)new HeadMaterialStats(800, 7.5f, 7.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, -5), new ExtraMaterialStats(65), new BowMaterialStats(0.9f, 1.9f, 8.0f), new ArrowShaftMaterialStats(1.0f, 12)});
            materials.put("enderium", enderium);
            Material nickel = new Material("nickel", TextFormatting.YELLOW);
            nickel.addTrait((ITrait)NickOfTime.nickOfTime, "head");
            nickel.addTrait((ITrait)TinkerTraits.magnetic);
            nickel.addItem("ingotNickel", 1, 144);
            nickel.setCraftable(false).setCastable(true);
            Utils.setDispItem(nickel, "ingotNickel");
            proxy.setRenderInfo(nickel, 16775566);
            nickel.setFluid((Fluid)TinkerFluids.nickel);
            TinkerRegistry.addMaterialStats((Material)nickel, (IMaterialStats)new HeadMaterialStats(460, 6.0f, 4.5f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, -5), new ExtraMaterialStats(70), justWhy, new FletchingMaterialStats(0.95f, 1.05f)});
            materials.put("nickel", nickel);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(Toggle.class);
        proxy.registerKeyBindings();
        PacketHandler.init();
        Utils.setDispItem(materials.get("refinedObsidian"), "mekanism", "Ingot");
        Utils.setDispItem(materials.get("osmium"), "mekanism", "Ingot", 1);
        Utils.setDispItem(materials.get("witherbone"), "armorplus", "wither_bone");
        Utils.setDispItem(materials.get("guardianscale"), "armorplus", "guardian_scale");
        Utils.setDispItem(materials.get("sapphire"), "gemSapphire");
        Utils.setDispItem(materials.get("ruby"), "gemRuby");
        Utils.setDispItem(materials.get("peridot"), "gemPeridot");
        Item bronzeNugget = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "bronzenugget"));
        Item bronzeIngot = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "bronzeingot"));
        Block osmiridiumBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "osmiridiumblock"));
        Item osmiridiumIngot = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "osmiridiumingot"));
        Item osmiridiumNugget = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "osmiridiumnugget"));
        Block alumiteBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "alumiteblock"));
        Item alumiteIngot = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "alumiteingot"));
        Item alumiteNugget = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MODID, "alumitenugget"));
        if (bronzeNugget != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(bronzeIngot), new Object[]{"III", "III", "III", Character.valueOf('I'), "nuggetBronze"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(bronzeNugget, 9), new Object[]{"ingotBronze"}));
        }
        if (osmiridiumNugget != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(osmiridiumBlock), new Object[]{"III", "III", "III", Character.valueOf('I'), "ingotOsmiridium"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(osmiridiumIngot, 9), (Object[])new Object[]{osmiridiumBlock});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(osmiridiumIngot), new Object[]{"III", "III", "III", Character.valueOf('I'), "nuggetOsmiridium"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(osmiridiumNugget, 9), (Object[])new Object[]{osmiridiumIngot});
        }
        if (alumiteNugget != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(alumiteBlock), new Object[]{"III", "III", "III", Character.valueOf('I'), "ingotAlumite"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(alumiteIngot, 9), (Object[])new Object[]{alumiteBlock});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(alumiteIngot), new Object[]{"III", "III", "III", Character.valueOf('I'), "nuggetAlumite"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(alumiteNugget, 9), (Object[])new Object[]{alumiteIngot});
        }
    }

    static {
        materials = new HashMap<String, Material>();
        materialIntegrations = new HashMap<String, MaterialIntegration>();
        justWhy = new BowMaterialStats(0.2f, 0.4f, -1.0f);
    }
}

