/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.world.WorldSleepState;

public class MorpheusEventHandler {
    @SubscribeEvent
    public void loggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.func_130014_f_().func_73046_m().func_71218_a((int)event.player.field_71093_bK).field_72995_K) {
            if (Morpheus.playerSleepStatus.get(event.player.field_71093_bK) == null) {
                Morpheus.playerSleepStatus.put(event.player.field_71093_bK, new WorldSleepState(event.player.field_71093_bK));
            }
            Morpheus.playerSleepStatus.get(event.player.field_71093_bK).setPlayerAwake(event.player.func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void loggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.func_130014_f_().func_73046_m().func_71218_a((int)event.player.field_71093_bK).field_72995_K) {
            if (Morpheus.playerSleepStatus.get(event.player.field_71093_bK) == null) {
                return;
            }
            Morpheus.playerSleepStatus.get(event.player.field_71093_bK).removePlayer(event.player.func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void changedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.func_130014_f_().func_73046_m().func_71218_a((int)event.player.field_71093_bK).field_72995_K) {
            if (!Morpheus.playerSleepStatus.containsKey(event.toDim)) {
                Morpheus.playerSleepStatus.put(event.toDim, new WorldSleepState(event.toDim));
            }
            if (Morpheus.playerSleepStatus.get(event.fromDim) != null) {
                Morpheus.playerSleepStatus.get(event.fromDim).removePlayer(event.player.func_146103_bH().getName());
            }
            Morpheus.playerSleepStatus.get(event.toDim).setPlayerAwake(event.player.func_146103_bH().getName());
        }
    }

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.world.func_72820_D() % 20L == 10L && event.phase == TickEvent.Phase.END) {
            if (event.world.field_73010_i.size() > 0) {
                if (!Morpheus.playerSleepStatus.containsKey(event.world.field_73011_w.getDimension())) {
                    Morpheus.playerSleepStatus.put(event.world.field_73011_w.getDimension(), new WorldSleepState(event.world.field_73011_w.getDimension()));
                }
                Morpheus.checker.updatePlayerStates(event.world);
            } else {
                Morpheus.playerSleepStatus.remove(event.world.field_73011_w.getDimension());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void bedClicked(PlayerInteractEvent.RightClickBlock event) {
        if (Morpheus.setSpawnDaytime) {
            IBlockState state;
            BlockPos pos = event.getPos();
            EntityPlayer player = event.getEntityPlayer();
            if (!event.getWorld().field_72995_K && event.getWorld().func_72935_r() && !player.func_70093_af() && (player.func_180470_cg() == null || player.func_180470_cg().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) > 4.0) && (state = event.getWorld().func_180495_p(pos)).func_177230_c() instanceof BlockBed) {
                if (state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD) {
                    pos = event.getPos().func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D));
                    state = event.getWorld().func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof BlockBed) || state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD) {
                        return;
                    }
                }
                if (event.getWorld().field_73011_w.func_76567_e() && event.getWorld().field_73011_w.getBiomeForCoords(pos) != Biomes.field_76778_j && !((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) {
                    player.func_180473_a(event.getEntityPlayer().func_180425_c(), false);
                    player.setSpawnChunk(pos, false, event.getWorld().field_73011_w.getDimension());
                    player.func_146105_b((ITextComponent)new TextComponentString("New spawnpoint has been set!"));
                    event.setCanceled(true);
                }
            }
        }
    }
}

