/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.item.ICustomDamageItem;
import ic2.core.init.MainConfig;
import ic2.core.recipe.AdvRecipe;
import ic2.core.util.StackUtil;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class GradualRecipe
implements IRecipe {
    public ICustomDamageItem item;
    public ItemStack chargeMaterial;
    public int amount;
    public boolean hidden;

    public static void addAndRegister(ItemStack itemToFill, int amount, Object ... args) {
        block10: {
            try {
                if (itemToFill == null) {
                    AdvRecipe.displayError("Null item to fill", null, null, true);
                } else {
                    if (!(itemToFill.func_77973_b() instanceof ICustomDamageItem)) {
                        AdvRecipe.displayError("Filling item must extends ItemGradualInt", null, itemToFill, true);
                    }
                    ICustomDamageItem fillingItem = (ICustomDamageItem)itemToFill.func_77973_b();
                    Boolean hidden = false;
                    ItemStack filler = null;
                    for (Object o : args) {
                        if (o instanceof Boolean) {
                            hidden = (Boolean)o;
                            continue;
                        }
                        try {
                            filler = AdvRecipe.getRecipeObject(o).getInputs().get(0);
                            break;
                        }
                        catch (IndexOutOfBoundsException e) {
                            AdvRecipe.displayError("Invalid filler item: " + o, null, itemToFill, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            AdvRecipe.displayError("unknown type", "O: " + o + "\nT: " + o.getClass().getName(), itemToFill, true);
                        }
                    }
                    CraftingManager.func_77594_a().func_77592_b().add(new GradualRecipe(fillingItem, filler, amount, hidden));
                }
            }
            catch (RuntimeException e) {
                if (MainConfig.ignoreInvalidRecipes) break block10;
                throw e;
            }
        }
    }

    public GradualRecipe(ICustomDamageItem item, ItemStack chargeMaterial, int amount) {
        this(item, chargeMaterial, amount, false);
    }

    public GradualRecipe(ICustomDamageItem item, ItemStack chargeMaterial, int amount, boolean hidden) {
        this.item = item;
        this.chargeMaterial = chargeMaterial;
        this.amount = amount;
        this.hidden = hidden;
    }

    public boolean func_77569_a(InventoryCrafting ic, World world) {
        return this.func_77572_b(ic) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        ItemStack gridItem = null;
        int chargeMats = 0;
        for (int slot = 0; slot < ic.func_70302_i_(); ++slot) {
            ItemStack stack = ic.func_70301_a(slot);
            if (stack == null) continue;
            if (gridItem == null && stack.func_77973_b() == this.item) {
                gridItem = stack;
                continue;
            }
            if (StackUtil.checkItemEquality(stack, this.chargeMaterial)) {
                ++chargeMats;
                continue;
            }
            return null;
        }
        if (gridItem != null && chargeMats > 0) {
            ItemStack stack = gridItem.func_77946_l();
            int damage = this.item.getCustomDamage(stack) - this.amount * chargeMats;
            if (damage > this.item.getMaxCustomDamage(stack)) {
                damage = this.item.getMaxCustomDamage(stack);
            } else if (damage < 0) {
                damage = 0;
            }
            this.item.setCustomDamage(stack, damage);
            return stack;
        }
        return null;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)this.item);
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean canShow() {
        return AdvRecipe.canShow(new Object[]{this.chargeMaterial}, new ItemStack((Item)this.item), this.hidden);
    }
}

