/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrade;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import ic2.api.network.ClientModifiable;
import ic2.core.ContainerBase;
import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.gui.EnumCycleHandler;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IEnableHandler;
import ic2.core.gui.MouseButton;
import ic2.core.gui.SlotGrid;
import ic2.core.gui.TextBox;
import ic2.core.gui.VanillaButton;
import ic2.core.init.Localization;
import ic2.core.item.ContainerHandHeldInventory;
import ic2.core.item.upgrade.HandHeldAdvancedUpgrade;
import ic2.core.item.upgrade.HandHeldUpgradeOption;
import ic2.core.slot.SlotHologramSlot;
import ic2.core.util.StackUtil;
import java.util.Locale;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HandHeldMeta
extends HandHeldUpgradeOption {
    protected final boolean initialActivity;
    protected final String initialSettings;

    public HandHeldMeta(HandHeldAdvancedUpgrade upgradeGUI) {
        super(upgradeGUI, "meta");
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(this.containerStack).func_74775_l("metaSettings");
        this.initialActivity = nbt.func_74767_n("active");
        this.initialSettings = nbt.func_74779_i("settings");
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new ContainerEditMeta();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiEditMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiEditMeta
    extends GuiIC2<ContainerEditMeta> {
        protected HandHeldUpgradeOption.BoxSettings currentBoxes;
        protected String rightBox;
        protected String leftBox;
        protected HandHeldUpgradeOption.ComparisonSettings rightComparison;
        protected HandHeldUpgradeOption.ComparisonSettings leftComparison;

        public GuiEditMeta() {
            HandHeldUpgradeOption.ComparisonSettings rightBoxSetting;
            String rightBox;
            super(new ContainerEditMeta());
            if (HandHeldMeta.this.initialActivity) {
                HandHeldUpgradeOption.ComparisonSettings.ComparisonContainer settings;
                if (HandHeldMeta.this.initialSettings.length() > 0) {
                    settings = HandHeldUpgradeOption.ComparisonSettings.breakNBT("meta", HandHeldMeta.this.initialSettings);
                } else {
                    settings = new HandHeldUpgradeOption.ComparisonSettings.ComparisonContainer();
                    settings.rightSetting = HandHeldUpgradeOption.ComparisonSettings.EQUAL;
                    settings.rightBox = HandHeldMeta.this.initialSettings;
                }
                rightBox = settings.rightBox;
                rightBoxSetting = settings.rightSetting;
                if (settings.leftBox != null) {
                    this.currentBoxes = HandHeldUpgradeOption.BoxSettings.RANGE;
                    String leftBox = settings.leftBox;
                    HandHeldUpgradeOption.ComparisonSettings leftBoxSetting = settings.leftSetting;
                } else {
                    this.currentBoxes = HandHeldUpgradeOption.BoxSettings.COMPARISON;
                    String leftBox = "";
                    HandHeldUpgradeOption.ComparisonSettings leftBoxSetting = rightBoxSetting;
                }
            } else {
                this.currentBoxes = HandHeldUpgradeOption.BoxSettings.IGNORED;
                rightBox = "";
                String leftBox = "";
                HandHeldUpgradeOption.ComparisonSettings leftBoxSetting = rightBoxSetting = HandHeldUpgradeOption.ComparisonSettings.EQUAL;
            }
            IEnableHandler notIgnored = new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return GuiEditMeta.this.currentBoxes != HandHeldUpgradeOption.BoxSettings.IGNORED;
                }
            };
            IEnableHandler rangeOnly = new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return GuiEditMeta.this.currentBoxes == HandHeldUpgradeOption.BoxSettings.RANGE;
                }
            };
            this.addElement(HandHeldUpgradeOption.getBackButton(this));
            this.addElement((GuiElement<?>)new VanillaButton(this, 10, 25, 50, 10, new EnumCycleHandler<HandHeldUpgradeOption.BoxSettings>(HandHeldUpgradeOption.BoxSettings.values(), this.currentBoxes){

                @Override
                public void onClick(MouseButton button) {
                    super.onClick(button);
                    GuiEditMeta.this.currentBoxes = (HandHeldUpgradeOption.BoxSettings)((Object)this.getCurrentValue());
                    GuiEditMeta.this.handleSettingChange();
                }
            }).withText(new Supplier<String>(){

                public String get() {
                    return Localization.translate("ic2.upgrade.advancedGUI." + GuiEditMeta.this.currentBoxes.toString().toLowerCase(Locale.ENGLISH));
                }
            }));
            this.rightComparison = rightBoxSetting;
            this.addElement((GuiElement<?>)((VanillaButton)new VanillaButton(this, 10, 40, 20, 10, new EnumCycleHandler<HandHeldUpgradeOption.ComparisonSettings>(HandHeldUpgradeOption.ComparisonSettings.values(), this.rightComparison){

                @Override
                public void onClick(MouseButton button) {
                    super.onClick(button);
                    GuiEditMeta.this.rightComparison = (HandHeldUpgradeOption.ComparisonSettings)((Object)this.getCurrentValue());
                    GuiEditMeta.this.handleSettingChange();
                }
            }).withEnableHandler(notIgnored)).withText(new Supplier<String>(){

                public String get() {
                    return GuiEditMeta.this.rightComparison.symbol;
                }
            }));
            this.addElement(((TextBox)new TextBox(this, 10, 45, 80, 20, rightBox).withEnableHandler(notIgnored)).withTextValidator(new Predicate<String>(){

                public boolean apply(String input) {
                    return true;
                }
            }).withTextWatcher(new TextBox.ITextBoxWatcher(){

                @Override
                public void onChanged(String newValue) {
                    GuiEditMeta.this.rightBox = newValue;
                    GuiEditMeta.this.handleSettingChange();
                }
            }));
            this.addElement(new SlotGrid(this, 7, 7, 9, 1, SlotGrid.SlotStyle.Normal));
            this.addElement(new SlotGrid(this, 7, 83, 9, 3, SlotGrid.SlotStyle.Normal));
            this.addElement(new SlotGrid(this, 7, 141, 9, 1, SlotGrid.SlotStyle.Normal));
        }

        @Override
        protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
            int side;
            GuiElement.bindCommonTexture();
            this.drawTexturedRect(-16.0, -16.0, 32.0, 32.0, 0.0, 0.0);
            this.drawTexturedRect(this.field_146999_f - 16, -16.0, 32.0, 32.0, 64.0, 0.0);
            this.drawTexturedRect(-16.0, this.field_147000_g - 16, 32.0, 32.0, 0.0, 64.0);
            this.drawTexturedRect(this.field_146999_f - 16, this.field_147000_g - 16, 32.0, 32.0, 64.0, 64.0);
            for (side = 0; side < 2; ++side) {
                int y = this.field_147000_g * side - 16;
                int v = 64 * side;
                for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                    this.drawTexturedRect(x, y, Math.min(32, this.field_146999_f - 16 - x), 32.0, 32.0, v);
                }
            }
            for (side = 0; side < 2; ++side) {
                int x = this.field_146999_f * side - 16;
                int u = 64 * side;
                for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                    this.drawTexturedRect(x, y, 32.0, Math.min(32, this.field_147000_g - 16 - y), u, 32.0);
                }
            }
            for (int y = 16; y < this.field_147000_g - 16; y += 32) {
                int height = Math.min(32, this.field_147000_g - 16 - y);
                for (int x = 16; x < this.field_146999_f - 16; x += 32) {
                    this.drawTexturedRect(x, y, Math.min(32, this.field_146999_f - 16 - x), height, 32.0, 32.0);
                }
            }
        }

        @Override
        protected ResourceLocation getTexture() {
            return null;
        }

        public void handleSettingChange() {
            ((ContainerEditMeta)this.container).textBox = this.rightComparison.constructFromBox("meta", this.rightBox);
            IC2.network.get(false).sendContainerField(this.container, "textBox");
        }
    }

    public class ContainerEditMeta
    extends ContainerHandHeldInventory<HandHeldMeta> {
        @ClientModifiable
        protected boolean active;
        @ClientModifiable
        protected String textBox;

        public ContainerEditMeta() {
            super(HandHeldMeta.this);
            this.active = HandHeldMeta.this.initialActivity;
            this.textBox = HandHeldMeta.this.initialSettings;
            this.addPlayerInventorySlots(HandHeldMeta.this.player, 166);
            for (int slot = 0; slot < 9; slot = (int)((byte)(slot + 1))) {
                this.func_75146_a(new SlotHologramSlot(HandHeldMeta.this.inventory, slot, 6 + 18 * slot, 10, 1, null));
            }
        }

        @Override
        public void onContainerEvent(String event) {
            if ("back".equals(event)) {
                assert (!((HandHeldMeta)HandHeldMeta.this).player.field_70170_p.field_72995_K);
                IC2.platform.launchGui(HandHeldMeta.this.player, HandHeldMeta.this.previousGUI);
            } else {
                super.onContainerEvent(event);
            }
        }

        @Override
        public void func_75134_a(EntityPlayer player) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(HandHeldMeta.this.containerStack).func_74775_l("metaSettings");
            nbt.func_74757_a("active", this.active);
            nbt.func_74778_a("settings", this.textBox);
            super.func_75134_a(player);
        }
    }
}

