/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.leg;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.energy.leg.EnergyNetLocalLeg;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

class Tile {
    final IEnergyTile entity;
    final IEnergyTile subTile;
    final Tile[] neighbors = new Tile[6];

    Tile(EnergyNetLocalLeg enet, IEnergyTile te, IEnergyTile subTile) {
        this.entity = te;
        this.subTile = subTile;
        BlockPos pos = EnergyNet.instance.getPos(subTile);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos coords = pos.func_177972_a(dir);
            int index = dir.ordinal();
            this.neighbors[index] = enet.registeredTiles.get(coords);
            if (this.neighbors[index] == null) continue;
            this.neighbors[index].neighbors[dir.func_176734_d().ordinal()] = this;
        }
    }

    void destroy() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Tile neighbor = this.neighbors[dir.ordinal()];
            if (neighbor == null) continue;
            neighbor.neighbors[dir.func_176734_d().ordinal()] = null;
        }
    }

    public String toString() {
        return super.toString() + "{" + this.entity + "," + this.subTile + "}";
    }

    int getAmountNeighbors() {
        int n = 0;
        for (Tile t : this.neighbors) {
            if (t == null) continue;
            ++n;
        }
        return n;
    }
}

