/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.IEnergyNet;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.leg.EnergyNetGlobalLeg;
import ic2.core.energy.leg.EnergyNetLocalLeg;
import net.minecraft.world.World;

public final class EnergyNetGateway {
    private static final boolean useEnergyNetLeg = System.getProperty("IC2ExpEnet") == null;

    private EnergyNetGateway() {
    }

    public static IEnergyNet init() {
        if (EnergyNetGateway.useEnergyNetLeg()) {
            return EnergyNetGlobalLeg.initialize();
        }
        return EnergyNetGlobal.initialize();
    }

    public static EnergyNetLocal create(World world) {
        if (EnergyNetGateway.useEnergyNetLeg()) {
            return null;
        }
        return new EnergyNetLocal(world);
    }

    public static EnergyNetLocalLeg createLeg(World world) {
        if (EnergyNetGateway.useEnergyNetLeg()) {
            return new EnergyNetLocalLeg(world);
        }
        return null;
    }

    public static boolean useEnergyNetLeg() {
        return useEnergyNetLeg;
    }

    public static void onTickEnd(World world) {
        if (!EnergyNetGateway.useEnergyNetLeg()) {
            EnergyNetGlobal.onTickEnd(world);
        }
    }
}

