/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RitualFelling
extends Ritual {
    public static final String FELLING_RANGE = "fellingRange";
    public static final String CHEST_RANGE = "chest";
    private ArrayList<BlockPos> treePartsCache;
    private Iterator<BlockPos> blockPosIterator;
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualFelling() {
        super("ritualFelling", 0, 20000, "ritual.BloodMagic.fellingRitual");
        this.addBlockRange(FELLING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -3, -10), new BlockPos(11, 27, 11)));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FELLING_RANGE, 14000, 15, 30);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
        this.treePartsCache = new ArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (!this.cached || this.treePartsCache.isEmpty()) {
            for (BlockPos blockPos : this.getBlockRange(FELLING_RANGE).getContainedPositions(masterRitualStone.getBlockPos())) {
                if (this.treePartsCache.contains(blockPos) || world.func_175623_d(blockPos) || !world.func_180495_p(blockPos).func_177230_c().isWood((IBlockAccess)world, blockPos) && !world.func_180495_p(blockPos).func_177230_c().isLeaves(world.func_180495_p(blockPos), (IBlockAccess)world, blockPos)) continue;
                this.treePartsCache.add(blockPos);
            }
            this.cached = true;
            this.blockPosIterator = this.treePartsCache.iterator();
        }
        if (this.blockPosIterator.hasNext() && tileInventory != null && tileInventory instanceof IInventory) {
            masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
            this.currentPos = this.blockPosIterator.next();
            this.placeInInventory(world.func_180495_p(this.currentPos), world, this.currentPos, chestRange.getContainedPositions(masterPos).get(0));
            world.func_175698_g(this.currentPos);
            this.blockPosIterator.remove();
        }
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 1, EnumRuneType.EARTH);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFelling();
    }

    private void placeInInventory(IBlockState blockState, World world, BlockPos blockPos, BlockPos tileEntityPos) {
        TileEntity tile = world.func_175625_s(tileEntityPos);
        if (tile != null && blockState.func_177230_c().getDrops((IBlockAccess)world, blockPos, world.func_180495_p(blockPos), 0) != null && tile instanceof IInventory) {
            for (ItemStack stack : blockState.func_177230_c().getDrops((IBlockAccess)world, blockPos, world.func_180495_p(blockPos), 0)) {
                ItemStack copyStack = stack.func_77946_l();
                Utils.insertStackIntoInventory(copyStack, (IInventory)tile, EnumFacing.DOWN);
                if (copyStack.field_77994_a <= 0) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)blockPos.func_177958_n() + 0.4, (double)(blockPos.func_177956_o() + 2), (double)blockPos.func_177952_p() + 0.4, copyStack));
            }
        }
    }
}

