/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.item.ItemComponent;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualCobblestone
extends Ritual {
    public static final String COBBLESTONE_RANGE = "cobblestoneRange";

    public RitualCobblestone() {
        super("ritualCobblestone", 0, 500, "ritual.BloodMagic.cobblestoneRitual");
        this.addBlockRange(COBBLESTONE_RANGE, new AreaDescriptor.Cross(new BlockPos(0, 1, 0), 1));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        TileAlchemyArray alchemyArray;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        TileEntity tileEntity = world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a());
        Block block = Blocks.field_150347_e;
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor cobblestoneRange = this.getBlockRange(COBBLESTONE_RANGE);
        if (tileEntity != null && tileEntity instanceof TileAlchemyArray && (alchemyArray = (TileAlchemyArray)tileEntity).func_70301_a(0) != null && alchemyArray.func_70301_a(0).func_77973_b() instanceof ItemComponent) {
            switch (alchemyArray.func_70301_a(0).func_77952_i()) {
                case 0: {
                    block = Blocks.field_150343_Z;
                    alchemyArray.func_70298_a(0, 1);
                    world.func_175698_g(alchemyArray.func_174877_v());
                    break;
                }
                case 1: {
                    block = Blocks.field_150424_aL;
                    alchemyArray.func_70298_a(0, 1);
                    world.func_175698_g(alchemyArray.func_174877_v());
                    break;
                }
            }
        }
        for (BlockPos blockPos : cobblestoneRange.getContainedPositions(masterRitualStone.getBlockPos())) {
            if (world.func_175623_d(blockPos)) {
                world.func_175656_a(blockPos, block.func_176223_P());
                ++totalEffects;
            }
            if (totalEffects < maxEffects) continue;
            break;
        }
        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshCost() {
        return 25;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 1, 0, EnumRuneType.WATER);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCobblestone();
    }
}

