/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemSigilLava
extends ItemSigilBase {
    public ItemSigilLava() {
        super("lava", 1000);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult rayTrace;
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K && !this.isUnusable(stack) && (rayTrace = this.func_77621_a(world, player, false)) != null) {
            ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)rayTrace);
            if (ret != null) {
                return ret;
            }
            if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = rayTrace.func_178782_a();
                if (!world.func_175660_a(player, blockpos)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                if (!player.func_175151_a(blockpos.func_177972_a(rayTrace.field_178784_b), rayTrace.field_178784_b, stack)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                BlockPos blockpos1 = blockpos.func_177972_a(rayTrace.field_178784_b);
                if (!player.func_175151_a(blockpos1, rayTrace.field_178784_b, stack)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
                if (this.canPlaceLava(world, blockpos1) && NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed()) && this.tryPlaceLava(world, blockpos1)) {
                    return super.func_77659_a(stack, world, player, hand);
                }
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || player.func_70093_af() || this.isUnusable(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!world.canMineBlockBody(player, blockPos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof IFluidHandler) {
            FluidStack fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            int amount = ((IFluidHandler)tile).fill(side, fluid, false);
            if (amount > 0 && NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage(player, this.getLpUsed())) {
                ((IFluidHandler)tile).fill(side, fluid, true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    public boolean canPlaceLava(World world, BlockPos blockPos) {
        if (!world.func_175623_d(blockPos) && world.func_180495_p(blockPos).func_177230_c().func_149688_o(world.func_180495_p(blockPos)).func_76220_a()) {
            return false;
        }
        if ((world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150356_k) && world.func_180495_p(blockPos).func_177230_c().func_176201_c(world.func_180495_p(blockPos)) == 0) {
            return false;
        }
        world.func_180501_a(blockPos, Blocks.field_150356_k.func_176194_O().func_177621_b(), 3);
        return true;
    }

    public boolean tryPlaceLava(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos));
        return world.func_175623_d(pos) && !material.func_76220_a();
    }
}

