/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.api.altar.IBloodAltar;
import WayofTime.bloodmagic.api.iface.IAltarReader;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.item.sigil.ItemSigilBase;
import WayofTime.bloodmagic.tile.TileIncenseAltar;
import WayofTime.bloodmagic.tile.TileInversionPillar;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemSigilDivination
extends ItemSigilBase
implements IAltarReader {
    public ItemSigilDivination() {
        super("divination");
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            super.func_77659_a(stack, world, player, hand);
            RayTraceResult position = this.func_77621_a(world, player, false);
            if (position == null) {
                int currentEssence = NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).getCurrentEssence();
                ArrayList<TextComponentTranslation> toSend = new ArrayList<TextComponentTranslation>();
                if (!this.getOwnerName(stack).equals(PlayerHelper.getUsernameFromPlayer(player))) {
                    toSend.add(new TextComponentTranslation(this.tooltipBase + "otherNetwork", new Object[]{this.getOwnerName(stack)}));
                }
                toSend.add(new TextComponentTranslation(this.tooltipBase + "currentEssence", new Object[]{currentEssence}));
                ChatUtil.sendNoSpam(player, toSend.toArray(new ITextComponent[toSend.size()]));
            } else if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
                TileEntity tile = world.func_175625_s(position.func_178782_a());
                if (tile != null && tile instanceof IBloodAltar) {
                    IBloodAltar altar = (IBloodAltar)tile;
                    int tier = altar.getTier().ordinal() + 1;
                    int currentEssence = altar.getCurrentBlood();
                    int capacity = altar.getCapacity();
                    altar.checkTier();
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation(this.tooltipBase + "currentAltarTier", new Object[]{NumeralHelper.toRoman(tier)}), new TextComponentTranslation(this.tooltipBase + "currentEssence", new Object[]{currentEssence}), new TextComponentTranslation(this.tooltipBase + "currentAltarCapacity", new Object[]{capacity})});
                } else if (tile != null && tile instanceof TileIncenseAltar) {
                    TileIncenseAltar altar = (TileIncenseAltar)tile;
                    altar.recheckConstruction();
                    double tranquility = altar.tranquility;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation(this.tooltipBase + "currentTranquility", new Object[]{(int)(100.0 * (double)((int)(100.0 * tranquility)) / 100.0)}), new TextComponentTranslation(this.tooltipBase + "currentBonus", new Object[]{(int)(100.0 * altar.incenseAddition)})});
                } else if (tile != null && tile instanceof TileInversionPillar) {
                    TileInversionPillar pillar = (TileInversionPillar)tile;
                    double inversion = pillar.getCurrentInversion();
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation(this.tooltipBase + "currentInversion", new Object[]{(double)((int)(10.0 * inversion)) / 10.0})});
                } else {
                    int currentEssence = NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).getCurrentEssence();
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation(this.tooltipBase + "currentEssence", new Object[]{currentEssence})});
                }
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }
}

