/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import WayofTime.bloodmagic.api.altar.IAltarManipulator;
import WayofTime.bloodmagic.api.iface.IDocumentedBlock;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSanguineBook
extends Item
implements IVariantProvider,
IAltarManipulator {
    private EnumAltarTier currentDisplayedTier = EnumAltarTier.ONE;

    public ItemSanguineBook() {
        this.func_77655_b("BloodMagic.sanguineBook");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState hitState = world.func_180495_p(pos);
        if (player.func_70093_af() && hitState.func_177230_c() instanceof IDocumentedBlock) {
            this.trySetDisplayedTier(world, pos);
            IDocumentedBlock documentedBlock = (IDocumentedBlock)hitState.func_177230_c();
            List<ITextComponent> docs = documentedBlock.getDocumentation(player, world, pos, hitState);
            if (!docs.isEmpty()) {
                ChatUtil.sendNoSpam(player, docs.toArray(new ITextComponent[docs.size()]));
                return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return super.func_77659_a(stack, world, player, hand);
        }
        stack = NBTHelper.checkNBT(stack);
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null || rayTrace.field_72313_a == RayTraceResult.Type.MISS || rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (stack.func_77978_p().func_74762_e("currentTier") >= EnumAltarTier.MAXTIERS - 1) {
                stack.func_77978_p().func_74768_a("currentTier", 0);
            } else {
                stack.func_77978_p().func_74768_a("currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1);
            }
            this.currentDisplayedTier = EnumAltarTier.values()[stack.func_77978_p().func_74762_e("currentTier")];
            ChatUtil.sendNoSpam(player, TextHelper.localizeEffect("chat.BloodMagic.altarMaker.setTier", NumeralHelper.toRoman(stack.func_77978_p().func_74762_e("currentTier") + 1)));
            return super.func_77659_a(stack, world, player, hand);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public boolean trySetDisplayedTier(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAltar) {
            return !((TileAltar)tile).setCurrentTierDisplayed(this.currentDisplayedTier);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.book.shifting", new Object[0]));
        tooltip.add(TextFormatting.OBFUSCATED + "~ILikeTehNutsAndICannotLie");
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1));
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        return Collections.singletonList(Pair.of((Object)0, (Object)"type=normal"));
    }
}

