/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.util.helper.RitualHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.handler.event.ClientHandler;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class ItemRitualDiviner
extends Item
implements IVariantProvider {
    public static String[] names = new String[]{"normal", "dusk", "dawn"};
    public static final String tooltipBase = "tooltip.BloodMagic.diviner.";

    public ItemRitualDiviner() {
        this.func_77655_b("BloodMagic.ritualDiviner");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        if (Strings.isNullOrEmpty((String)this.getCurrentRitual(stack))) {
            return displayName;
        }
        Ritual ritual = RitualRegistry.getRitualForId(this.getCurrentRitual(stack));
        if (ritual == null) {
            return displayName;
        }
        return displayName + ": " + TextHelper.localize(ritual.getUnlocalizedName(), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < names.length; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                this.trySetDisplayedRitual(stack, world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.addRuneToRitual(stack, world, pos, player)) {
            if (world.field_72995_K) {
                ItemRitualDiviner.spawnParticles(world, pos.func_177984_a(), 15);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean addRuneToRitual(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        Ritual ritual;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone && (ritual = RitualRegistry.getRitualForId(this.getCurrentRitual(stack))) != null) {
            EnumFacing direction = this.getDirection(stack);
            for (RitualComponent component : ritual.getComponents()) {
                if (!this.canPlaceRitualStone(component.getRuneType(), stack)) {
                    return false;
                }
                BlockPos offset = component.getOffset(direction);
                BlockPos newPos = pos.func_177971_a((Vec3i)offset);
                IBlockState state = world.func_180495_p(newPos);
                Block block = state.func_177230_c();
                if (RitualHelper.isRune(world, newPos)) {
                    if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) {
                        if (!world.field_72995_K) continue;
                        this.undisplayHologram();
                        continue;
                    }
                    RitualHelper.setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                if (block.isAir(state, (IBlockAccess)world, newPos) || block.func_176200_f((IBlockAccess)world, newPos)) {
                    if (!this.consumeStone(stack, world, player)) {
                        return false;
                    }
                    int meta = component.getRuneType().ordinal();
                    IBlockState newState = ModBlocks.RITUAL_STONE.func_176203_a(meta);
                    world.func_175656_a(newPos, newState);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void trySetDisplayedRitual(ItemStack itemStack, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            Ritual ritual = RitualRegistry.getRitualForId(this.getCurrentRitual(itemStack));
            TileMasterRitualStone masterRitualStone = (TileMasterRitualStone)tile;
            if (ritual != null) {
                EnumFacing direction = this.getDirection(itemStack);
                ClientHandler.setRitualHolo(masterRitualStone, ritual, direction, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void undisplayHologram() {
        ClientHandler.setRitualHoloToNull();
    }

    public boolean consumeStone(ItemStack stack, World world, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inventory.length; ++i) {
            Block block;
            Item item;
            ItemStack newStack = inventory[i];
            if (newStack == null || !((item = newStack.func_77973_b()) instanceof ItemBlock) || (block = ((ItemBlock)item).func_179223_d()) != ModBlocks.RITUAL_STONE) continue;
            --newStack.field_77994_a;
            if (newStack.field_77994_a <= 0) {
                inventory[i] = null;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        Ritual ritual = RitualRegistry.getRitualForId(this.getCurrentRitual(stack));
        if (ritual != null) {
            boolean extraInfo;
            tooltip.add(TextHelper.localize("tooltip.BloodMagic.diviner.currentRitual", new Object[0]) + TextHelper.localize(ritual.getUnlocalizedName(), new Object[0]));
            boolean sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            boolean bl = extraInfo = sneaking && Keyboard.isKeyDown((int)50);
            if (extraInfo) {
                tooltip.add("");
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    if (!TextHelper.canTranslate(ritual.getUnlocalizedName() + "." + type.func_176610_l().toLowerCase() + ".info")) continue;
                    tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect(ritual.getUnlocalizedName() + "." + type.func_176610_l().toLowerCase() + ".info", new Object[0]))));
                }
            } else if (sneaking) {
                tooltip.add(TextHelper.localize("tooltip.BloodMagic.diviner.currentDirection", Utils.toFancyCasing(this.getDirection(stack).func_176610_l())));
                tooltip.add("");
                ArrayList<RitualComponent> componentList = ritual.getComponents();
                int blankRunes = 0;
                int airRunes = 0;
                int waterRunes = 0;
                int fireRunes = 0;
                int earthRunes = 0;
                int duskRunes = 0;
                int dawnRunes = 0;
                int totalRunes = componentList.size();
                for (RitualComponent component : componentList) {
                    switch (component.getRuneType()) {
                        case BLANK: {
                            ++blankRunes;
                            break;
                        }
                        case AIR: {
                            ++airRunes;
                            break;
                        }
                        case EARTH: {
                            ++earthRunes;
                            break;
                        }
                        case FIRE: {
                            ++fireRunes;
                            break;
                        }
                        case WATER: {
                            ++waterRunes;
                            break;
                        }
                        case DUSK: {
                            ++duskRunes;
                            break;
                        }
                        case DAWN: {
                            ++dawnRunes;
                        }
                    }
                }
                if (blankRunes > 0) {
                    tooltip.add(EnumRuneType.BLANK.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.blankRune", blankRunes));
                }
                if (waterRunes > 0) {
                    tooltip.add(EnumRuneType.WATER.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.waterRune", waterRunes));
                }
                if (airRunes > 0) {
                    tooltip.add(EnumRuneType.AIR.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.airRune", airRunes));
                }
                if (fireRunes > 0) {
                    tooltip.add(EnumRuneType.FIRE.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.fireRune", fireRunes));
                }
                if (earthRunes > 0) {
                    tooltip.add(EnumRuneType.EARTH.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.earthRune", earthRunes));
                }
                if (duskRunes > 0) {
                    tooltip.add(EnumRuneType.DUSK.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.duskRune", duskRunes));
                }
                if (dawnRunes > 0) {
                    tooltip.add(EnumRuneType.DAWN.colorCode + TextHelper.localize("tooltip.BloodMagic.diviner.dawnRune", dawnRunes));
                }
                tooltip.add("");
                tooltip.add(TextHelper.localize("tooltip.BloodMagic.diviner.totalRune", totalRunes));
            } else {
                tooltip.add("");
                if (TextHelper.canTranslate(ritual.getUnlocalizedName() + ".info")) {
                    tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect(ritual.getUnlocalizedName() + ".info", new Object[0]))));
                    tooltip.add("");
                }
                tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.diviner.extraInfo", new Object[0]));
                tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.diviner.extraExtraInfo", new Object[0]));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult ray = this.func_77621_a(world, player, false);
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.cycleRitual(stack, player);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            RayTraceResult ray = this.func_77621_a(player.func_130014_f_(), player, false);
            if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
                return false;
            }
            if (!player.field_82175_bq) {
                if (player.func_70093_af()) {
                    this.cycleRitualBackwards(stack, player);
                } else {
                    this.cycleDirection(stack, player);
                }
            }
        }
        return false;
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=basic"));
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)1, (Object)"type=dusk"));
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)2, (Object)"type=dawn"));
        return ret;
    }

    public void cycleDirection(ItemStack stack, EntityPlayer player) {
        EnumFacing newDirection;
        EnumFacing direction = this.getDirection(stack);
        switch (direction) {
            case NORTH: {
                newDirection = EnumFacing.EAST;
                break;
            }
            case EAST: {
                newDirection = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                newDirection = EnumFacing.WEST;
                break;
            }
            case WEST: {
                newDirection = EnumFacing.NORTH;
                break;
            }
            default: {
                newDirection = EnumFacing.NORTH;
            }
        }
        this.setDirection(stack, newDirection);
        this.notifyDirectionChange(newDirection, player);
    }

    public void notifyDirectionChange(EnumFacing direction, EntityPlayer player) {
        ChatUtil.sendNoSpam(player, TextHelper.localize("tooltip.BloodMagic.diviner.currentDirection", Utils.toFancyCasing(direction.func_176610_l())));
    }

    public void setDirection(ItemStack stack, EnumFacing direction) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("direction", direction.func_176745_a());
    }

    public EnumFacing getDirection(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return EnumFacing.NORTH;
        }
        NBTTagCompound tag = stack.func_77978_p();
        int dir = tag.func_74762_e("direction");
        if (dir == 0) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.field_82609_l[tag.func_74762_e("direction")];
    }

    public void cycleRitual(ItemStack stack, EntityPlayer player) {
        String key = this.getCurrentRitual(stack);
        ArrayList<String> idList = RitualRegistry.getOrderedIds();
        String firstId = "";
        boolean foundId = false;
        boolean foundFirst = false;
        for (String str : idList) {
            Ritual ritual = RitualRegistry.getRitualForId(str);
            if (!RitualRegistry.ritualEnabled(ritual) || !this.canDivinerPerformRitual(stack, ritual)) continue;
            if (!foundFirst) {
                firstId = str;
                foundFirst = true;
            }
            if (foundId) {
                this.setCurrentRitual(stack, str);
                this.notifyRitualChange(str, player);
                return;
            }
            if (!str.equals(key)) continue;
            foundId = true;
        }
        if (foundFirst) {
            this.setCurrentRitual(stack, firstId);
            this.notifyRitualChange(firstId, player);
        }
    }

    public void cycleRitualBackwards(ItemStack stack, EntityPlayer player) {
        String key = this.getCurrentRitual(stack);
        ArrayList<String> idList = RitualRegistry.getOrderedIds();
        String firstId = "";
        boolean foundId = false;
        boolean foundFirst = false;
        for (int i = idList.size() - 1; i >= 0; --i) {
            String str = (String)idList.get(i);
            Ritual ritual = RitualRegistry.getRitualForId(str);
            if (!RitualRegistry.ritualEnabled(ritual) || !this.canDivinerPerformRitual(stack, ritual)) continue;
            if (!foundFirst) {
                firstId = str;
                foundFirst = true;
            }
            if (foundId) {
                this.setCurrentRitual(stack, str);
                this.notifyRitualChange(str, player);
                return;
            }
            if (!str.equals(key)) continue;
            foundId = true;
        }
        if (foundFirst) {
            this.setCurrentRitual(stack, firstId);
            this.notifyRitualChange(firstId, player);
        }
    }

    public boolean canDivinerPerformRitual(ItemStack stack, Ritual ritual) {
        if (ritual == null) {
            return false;
        }
        ArrayList<RitualComponent> components = ritual.getComponents();
        for (RitualComponent component : components) {
            if (this.canPlaceRitualStone(component.getRuneType(), stack)) continue;
            return false;
        }
        return true;
    }

    public void notifyRitualChange(String key, EntityPlayer player) {
        Ritual ritual = RitualRegistry.getRitualForId(key);
        if (ritual != null) {
            ChatUtil.sendNoSpam(player, TextHelper.localize("tooltip.BloodMagic.diviner.currentRitual", new Object[0]) + TextHelper.localize(ritual.getUnlocalizedName(), new Object[0]));
        }
    }

    public void setCurrentRitual(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("currentRitual", key);
    }

    public String getCurrentRitual(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74779_i("currentRitual");
    }

    public boolean canPlaceRitualStone(EnumRuneType rune, ItemStack stack) {
        int meta = stack.func_77952_i();
        switch (rune) {
            case BLANK: 
            case AIR: 
            case EARTH: 
            case FIRE: 
            case WATER: {
                return true;
            }
            case DUSK: {
                return meta >= 1;
            }
            case DAWN: {
                return meta >= 2;
            }
        }
        return false;
    }

    public static void spawnParticles(World worldIn, BlockPos pos, int amount) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block.isAir(state, (IBlockAccess)worldIn, pos)) {
            for (int i = 0; i < amount; ++i) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat(), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }
}

