/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemExperienceBook
extends Item
implements IVariantProvider {
    public ItemExperienceBook() {
        this.func_77655_b("BloodMagic.experienceTome");
        this.func_77625_d(1);
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.experienceTome", new Object[0]));
        if (!stack.func_77942_o()) {
            return;
        }
        double storedExp = ItemExperienceBook.getStoredExperience(stack);
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.experienceTome.exp", (int)storedExp));
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.experienceTome.expLevel", ItemExperienceBook.getLevelForExperience(storedExp)));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.absorbOneLevelExpFromPlayer(stack, player);
            } else {
                this.giveOneLevelExpToPlayer(stack, player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add((Pair<Integer, String>)new ImmutablePair((Object)0, (Object)"type=experiencetome"));
        return ret;
    }

    public void giveOneLevelExpToPlayer(ItemStack stack, EntityPlayer player) {
        float progress = player.field_71106_cc;
        int expToNext = ItemExperienceBook.getExperienceForNextLevel(player.field_71068_ca);
        int neededExp = (int)Math.ceil((1.0f - progress) * (float)expToNext);
        float containedExp = (float)ItemExperienceBook.getStoredExperience(stack);
        System.out.println("Needed: " + neededExp + ", contained: " + containedExp + ", exp to next: " + expToNext);
        if (containedExp >= (float)neededExp) {
            ItemExperienceBook.setStoredExperience(stack, containedExp - (float)neededExp);
            ItemExperienceBook.addPlayerXP(player, neededExp);
            if (player.field_71068_ca % 5 == 0) {
                float f = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187802_ec, player.func_184176_by(), f * 0.75f, 1.0f);
            }
        } else {
            ItemExperienceBook.setStoredExperience(stack, 0.0);
            ItemExperienceBook.addPlayerXP(player, (int)containedExp);
        }
    }

    public void absorbOneLevelExpFromPlayer(ItemStack stack, EntityPlayer player) {
        float progress = player.field_71106_cc;
        if (progress > 0.0f) {
            int expDeduction = (int)ItemExperienceBook.getExperienceAcquiredToNext(player);
            if (expDeduction > 0) {
                ItemExperienceBook.addPlayerXP(player, -expDeduction);
                ItemExperienceBook.addExperience(stack, expDeduction);
            }
        } else if (progress == 0.0f && player.field_71068_ca > 0) {
            int expDeduction = ItemExperienceBook.getExperienceForNextLevel(player.field_71068_ca - 1);
            ItemExperienceBook.addPlayerXP(player, -expDeduction);
            ItemExperienceBook.addExperience(stack, expDeduction);
        }
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)ItemExperienceBook.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, ItemExperienceBook.getPlayerXP(player) + amount);
        player.field_71068_ca = ItemExperienceBook.getLevelForExperience(experience);
        int expForLevel = ItemExperienceBook.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static void setStoredExperience(ItemStack stack, double exp) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("experience", exp);
    }

    public static double getStoredExperience(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("experience");
    }

    public static void addExperience(ItemStack stack, double exp) {
        ItemExperienceBook.setStoredExperience(stack, ItemExperienceBook.getStoredExperience(stack) + exp);
    }

    public static int getExperienceForNextLevel(int currentLevel) {
        if (currentLevel < 16) {
            return 2 * currentLevel + 7;
        }
        if (currentLevel < 31) {
            return 5 * currentLevel - 38;
        }
        return 9 * currentLevel - 158;
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        if (level == 0) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < level; ++i) {
            res += ItemExperienceBook.getExperienceForNextLevel(i);
        }
        return res;
    }

    public static double getExperienceAcquiredToNext(EntityPlayer player) {
        return player.field_71106_cc * (float)player.func_71050_bK();
    }

    public static int getLevelForExperience(double exp) {
        if (exp <= 352.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(1.0, 6.0, -exp));
        }
        if (exp <= 1507.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(2.5, -40.5, 360.0 - exp));
        }
        return (int)Math.floor(ItemExperienceBook.solveParabola(4.5, -162.5, 2220.0 - exp));
    }

    public static double solveParabola(double a, double b, double c) {
        return (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
    }
}

