/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.entity.ai.EntityAIEatAndCorruptBlock;
import WayofTime.bloodmagic.entity.ai.EntityAIProtectAlly;
import WayofTime.bloodmagic.entity.mob.EntityAspectedDemonBase;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCorruptedSheep
extends EntityAspectedDemonBase
implements IShearable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityCorruptedSheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);
    private int sheepTimer;
    private int castTimer = 0;
    private EntityAIEatAndCorruptBlock entityAIEatGrass;
    private EntityAIProtectAlly entityAIProtectAlly;
    private EntityAIAttackMelee aiAttackOnCollide;
    private final int attackPriority = 3;
    public int protectionCooldown = 0;
    public static int maxProtectionCooldown = 1800;

    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public EntityCorruptedSheep(World world) {
        this(world, EnumDemonWillType.DEFAULT);
    }

    public EntityCorruptedSheep(World world, EnumDemonWillType type) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.setType(type);
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIEatAndCorruptBlock(this);
        this.entityAIProtectAlly = new EntityAIProtectAlly(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.entityAIProtectAlly);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new EntityAspectedDemonBase.TeamAttackPredicate(this, this)));
    }

    @Override
    public void setCombatTask() {
        if (this.aiAttackOnCollide != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
        this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, this.getBaseSprintModifier(this.getType()), false);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttackOnCollide);
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        this.castTimer = this.entityAIProtectAlly.getCastTimer();
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        if (this.func_130014_f_().field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
            this.castTimer = Math.max(0, this.castTimer - 1);
            if (this.castTimer == 70) {
                this.func_184185_a(this.func_184601_bQ(), this.func_70599_aP() * 2.0f, this.func_70647_i());
            }
        }
        this.protectionCooldown = Math.max(0, this.protectionCooldown - 1);
        super.func_70636_d();
    }

    public boolean canProtectAlly(EntityLivingBase entity) {
        return this.protectionCooldown <= 0 && entity.func_110143_aJ() < entity.func_110138_aP() && !entity.func_70644_a(MobEffects.field_76429_m);
    }

    public boolean applyProtectionToAlly(EntityLivingBase entity) {
        if (this.canProtectAlly(entity)) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 400, 3));
            this.protectionCooldown = maxProtectionCooldown;
        }
        return false;
    }

    @Override
    public double getBaseHP(EnumDemonWillType type) {
        return super.getBaseHP(type) * 0.75;
    }

    @Override
    public double getBaseMeleeDamage(EnumDemonWillType type) {
        return super.getBaseMeleeDamage(type) * 0.75;
    }

    @Override
    public double getBaseSpeed(EnumDemonWillType type) {
        return super.getBaseSpeed(type);
    }

    @Override
    public double getBaseSprintModifier(EnumDemonWillType type) {
        return super.getBaseSprintModifier(type);
    }

    @Override
    public double getBaseKnockbackResist(EnumDemonWillType type) {
        return super.getBaseKnockbackResist(type) + 0.2;
    }

    @Override
    public double getMeleeResist() {
        return 0.2;
    }

    @Override
    public double getProjectileResist() {
        return 0.6;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else if (id == 53) {
            this.castTimer = 100;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float partialTick) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - partialTick) / 4.0f : -((float)(this.sheepTimer - 40) - partialTick) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float partialTick) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Sheared", this.getSheared());
        tag.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
        tag.func_74768_a("protection", this.protectionCooldown);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setSheared(tag.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)tag.func_74771_c("Color")));
        this.protectionCooldown = tag.func_74762_e("protection");
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    @Override
    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187761_eI;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public static EnumDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? EnumDyeColor.BLACK : (i < 10 ? EnumDyeColor.GRAY : (i < 15 ? EnumDyeColor.SILVER : (i < 18 ? EnumDyeColor.BROWN : (random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE))));
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_70691_i(3.0f);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setFleeceColor(EntityCorruptedSheep.getRandomSheepColor(this.func_130014_f_().field_73012_v));
        return livingdata;
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public int getCastTimer() {
        return this.castTimer;
    }

    static {
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{1.0f, 1.0f, 1.0f});
        DYE_TO_RGB.put(EnumDyeColor.ORANGE, new float[]{0.85f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.MAGENTA, new float[]{0.7f, 0.3f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.LIGHT_BLUE, new float[]{0.4f, 0.6f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.YELLOW, new float[]{0.9f, 0.9f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.LIME, new float[]{0.5f, 0.8f, 0.1f});
        DYE_TO_RGB.put(EnumDyeColor.PINK, new float[]{0.95f, 0.5f, 0.65f});
        DYE_TO_RGB.put(EnumDyeColor.GRAY, new float[]{0.3f, 0.3f, 0.3f});
        DYE_TO_RGB.put(EnumDyeColor.SILVER, new float[]{0.6f, 0.6f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.CYAN, new float[]{0.3f, 0.5f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.PURPLE, new float[]{0.5f, 0.25f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BLUE, new float[]{0.2f, 0.3f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BROWN, new float[]{0.4f, 0.3f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.GREEN, new float[]{0.4f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.RED, new float[]{0.6f, 0.2f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.BLACK, new float[]{0.1f, 0.1f, 0.1f});
    }
}

