/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.Constants;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import WayofTime.bloodmagic.api.orb.BloodOrb;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OrbRegistry {
    private static List<BloodOrb> orbs = new ArrayList<BloodOrb>();
    private static ArrayListMultimap<Integer, ItemStack> tierMap = ArrayListMultimap.create();
    private static Item orbItem = Constants.BloodMagicItem.BLOOD_ORB.getItem();

    public static void registerOrb(BloodOrb orb) {
        if (!orbs.contains(orb)) {
            orbs.add(orb);
            OrbRegistry.registerOrbForTier(orb.getTier(), OrbRegistry.getOrbStack(orb));
        } else {
            BloodMagicAPI.getLogger().error("Error adding orb %s. Orb already exists!", orb.toString());
        }
    }

    public static void registerOrbForTier(int tier, ItemStack stack) {
        if (stack.func_77973_b() instanceof IBloodOrb) {
            tierMap.put((Object)tier, (Object)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerOrbTexture(BloodOrb orb, ResourceLocation resourceLocation) {
        int meta = OrbRegistry.getIndexOf(orb);
        ModelBakery.registerItemVariants((Item)orbItem, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
        ModelLoader.setCustomModelResourceLocation((Item)orbItem, (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
    }

    public static BloodOrb getOrb(int index) {
        return orbs.get(index);
    }

    public static int getIndexOf(BloodOrb orb) {
        return orbs.indexOf(orb);
    }

    public static boolean isEmpty() {
        return orbs.isEmpty();
    }

    public static int getSize() {
        return orbs.size();
    }

    public static List<ItemStack> getOrbsForTier(int tier) {
        if (OrbRegistry.getTierMap().containsKey((Object)tier)) {
            return OrbRegistry.getTierMap().get((Object)tier);
        }
        return Collections.emptyList();
    }

    public static List<ItemStack> getOrbsUpToTier(int tier) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 1; i <= tier; ++i) {
            ret.addAll(OrbRegistry.getOrbsForTier(i));
        }
        return ret;
    }

    public static List<ItemStack> getOrbsDownToTier(int tier) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = EnumAltarTier.MAXTIERS; i >= tier; --i) {
            ret.addAll(OrbRegistry.getOrbsForTier(i));
        }
        return ret;
    }

    public static ItemStack getOrbStack(BloodOrb orb) {
        return new ItemStack(orbItem, 1, OrbRegistry.getIndexOf(orb));
    }

    public static List<BloodOrb> getOrbs() {
        return new ArrayList<BloodOrb>(orbs);
    }

    public static ArrayListMultimap<Integer, ItemStack> getTierMap() {
        return ArrayListMultimap.create(tierMap);
    }
}

