/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.iface.IHarvestHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;

public class HarvestRegistry {
    private static List<IHarvestHandler> handlerList = new ArrayList<IHarvestHandler>();
    private static Map<Block, Integer> standardCrops = new HashMap<Block, Integer>();
    private static Set<BlockStack> tallCrops = new HashSet<BlockStack>();
    private static Map<BlockStack, BlockStack> stemCrops = new HashMap<BlockStack, BlockStack>();
    private static Map<BlockStack, Integer> amplifierMap = new HashMap<BlockStack, Integer>();

    public static void registerHandler(IHarvestHandler handler) {
        if (!handlerList.contains(handler)) {
            handlerList.add(handler);
        }
    }

    public static void registerStandardCrop(Block crop, int matureMeta) {
        if (!standardCrops.containsKey(crop)) {
            standardCrops.put(crop, matureMeta);
        }
    }

    public static void registerTallCrop(BlockStack crop) {
        if (!tallCrops.contains(crop)) {
            tallCrops.add(crop);
        }
    }

    public static void registerStemCrop(BlockStack crop, BlockStack stem) {
        if (!stemCrops.containsKey(crop) && stem.getBlock() instanceof BlockStem) {
            stemCrops.put(stem, crop);
        }
    }

    public static void registerRangeAmplifier(BlockStack blockStack, int range) {
        if (!amplifierMap.containsKey(blockStack)) {
            amplifierMap.put(blockStack, range);
        }
    }

    public static List<IHarvestHandler> getHandlerList() {
        return new ArrayList<IHarvestHandler>(handlerList);
    }

    public static Map<Block, Integer> getStandardCrops() {
        return new HashMap<Block, Integer>(standardCrops);
    }

    public static Set<BlockStack> getTallCrops() {
        return new HashSet<BlockStack>(tallCrops);
    }

    public static Map<BlockStack, BlockStack> getStemCrops() {
        return new HashMap<BlockStack, BlockStack>(stemCrops);
    }

    public static Map<BlockStack, Integer> getAmplifierMap() {
        return new HashMap<BlockStack, Integer>(amplifierMap);
    }
}

