/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.recipe;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class LivingArmourDowngradeRecipe {
    protected LivingArmourUpgrade upgrade = null;
    protected ItemStack keyStack = null;
    protected ArrayList<Object> input = new ArrayList();

    public LivingArmourDowngradeRecipe(LivingArmourUpgrade upgrade, ItemStack keyStack, Object ... recipe) {
        this.upgrade = upgrade;
        this.keyStack = keyStack;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid living armour downgrade recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + upgrade.toString();
            throw new RuntimeException(ret);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public LivingArmourUpgrade getRecipeOutput() {
        return this.upgrade;
    }

    public boolean matches(ItemStack key, List<ItemStack> checkedList, World world, BlockPos pos) {
        if (!OreDictionary.itemMatches((ItemStack)this.keyStack, (ItemStack)key, (boolean)false)) {
            return false;
        }
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < checkedList.size(); ++x) {
            ItemStack slot = checkedList.get(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public ItemStack getKey() {
        return this.keyStack;
    }

    public void consumeInventory(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            if (stack.func_77973_b().hasContainerItem(stack)) {
                inv.extractItem(i, stack.field_77994_a, false);
                inv.insertItem(i, stack.func_77973_b().getContainerItem(stack), false);
                continue;
            }
            inv.extractItem(i, 1, false);
        }
    }

    protected ItemStack getContainerItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack copyStack = stack.func_77946_l();
        if (copyStack.func_77973_b().hasContainerItem(stack)) {
            return copyStack.func_77973_b().getContainerItem(copyStack);
        }
        --copyStack.field_77994_a;
        if (copyStack.field_77994_a <= 0) {
            return null;
        }
        return copyStack;
    }
}

