/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import java.util.List;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.blocks.BlockSeat;
import jds.bibliocraft.entity.EntitySeat;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.items.ItemSeatBack;
import jds.bibliocraft.items.ItemSeatBack2;
import jds.bibliocraft.items.ItemSeatBack3;
import jds.bibliocraft.items.ItemSeatBack4;
import jds.bibliocraft.items.ItemSeatBack5;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntitySeat
extends BiblioTileEntity
implements ITickable {
    public int hasBack;
    public boolean northConnect;
    public boolean southConnect;
    public boolean eastConnect;
    public boolean westConnect;
    public EnumColor seatColor = EnumColor.WHITE;
    public BiblioWoodBlock.EnumWoodType backWoodType = BiblioWoodBlock.EnumWoodType.OAK;
    public String customBackTex = "none";
    public boolean hasSitter = false;
    private int counter = 0;

    public TileEntitySeat() {
        super(3, true);
    }

    public void func_73660_a() {
        if (!this.hasSitter) {
            if (this.counter >= 100 && !this.field_145850_b.field_72995_K) {
                this.counter = 0;
                this.scaneForEntityes();
            } else {
                ++this.counter;
            }
        }
    }

    public void scaneForEntityes() {
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 2.0, (double)this.field_174879_c.func_177956_o() - 1.0, (double)this.field_174879_c.func_177952_p() - 2.0, (double)this.field_174879_c.func_177958_n() + 3.0, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 3.0);
        List checkEntities = this.field_145850_b.func_72872_a(EntityCreature.class, bb);
        for (int x = 0; x < checkEntities.size(); ++x) {
            EntityCreature guy = (EntityCreature)checkEntities.get(x);
            if (guy.func_95999_t().length() <= 0 || this.hasSitter || guy.func_184187_bx() != null) continue;
            this.sitDown((EntityLiving)guy);
        }
    }

    public void dismountEntity() {
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 1.0);
        List checkEntities = this.field_145850_b.func_72872_a(EntityCreature.class, bb);
        for (int x = 0; x < checkEntities.size(); ++x) {
            EntityCreature guy = (EntityCreature)checkEntities.get(x);
            if (guy.func_95999_t().length() <= 0 || guy.func_184187_bx() == null) continue;
            guy.func_184187_bx().func_70106_y();
            this.counter = 0;
            this.setSitter(false);
            break;
        }
    }

    public void sitDown(EntityLiving entity) {
        EntitySeat seatEntity = new EntitySeat(this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 1.0, this.field_174879_c.func_177952_p(), this);
        this.field_145850_b.func_72838_d((Entity)seatEntity);
        entity.func_184220_m((Entity)seatEntity);
        this.setSitter(true);
    }

    public void setSitter(boolean sit) {
        this.hasSitter = sit;
        this.updateSurroundingBlocks((Block)BlockSeat.instance);
    }

    public boolean getHasSitter() {
        return this.hasSitter;
    }

    public void removeBack() {
        this.hasBack = 0;
        this.customBackTex = "none";
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void removeCover() {
        this.seatColor = EnumColor.WHITE;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public BiblioWoodBlock.EnumWoodType getBackWoodType() {
        return this.backWoodType;
    }

    public int addSeatCover(ItemStack cloth) {
        if (this.func_70301_a(0) == null) {
            int clothStackSize = cloth.field_77994_a;
            if (clothStackSize == 1) {
                this.func_70299_a(0, cloth);
                clothStackSize = 0;
            } else {
                ItemStack clothCopy = cloth.func_77946_l();
                clothCopy.field_77994_a = 1;
                this.func_70299_a(0, clothCopy);
                --clothStackSize;
            }
            this.seatColor = EnumColor.getColorFromCarpetOrWool(cloth);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            return clothStackSize;
        }
        return -1;
    }

    public int addSeatBack(ItemStack back) {
        if (this.func_70301_a(1) == null) {
            int backStackSize = back.field_77994_a;
            if (backStackSize == 1) {
                this.func_70299_a(1, back);
                backStackSize = 0;
            } else {
                ItemStack backCopy = back.func_77946_l();
                backCopy.field_77994_a = 1;
                this.func_70299_a(1, backCopy);
                --backStackSize;
            }
            Item backType = back.func_77973_b();
            if (backType instanceof ItemSeatBack) {
                this.hasBack = 1;
            }
            if (backType instanceof ItemSeatBack2) {
                this.hasBack = 2;
            }
            if (backType instanceof ItemSeatBack3) {
                this.hasBack = 3;
            }
            if (backType instanceof ItemSeatBack4) {
                this.hasBack = 4;
            }
            if (backType instanceof ItemSeatBack5) {
                this.hasBack = 5;
            }
            this.backWoodType = BiblioWoodBlock.EnumWoodType.getEnum(back.func_77952_i());
            NBTTagCompound tags = back.func_77978_p();
            if (tags != null && tags.func_74764_b("renderTexture")) {
                this.customBackTex = tags.func_74779_i("renderTexture");
            }
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            return backStackSize;
        }
        return -1;
    }

    public void setCustomBackTex(String tex) {
        this.customBackTex = tex;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public String getCustomBackTexture() {
        return this.customBackTex;
    }

    public void removeSeatAddon(int slot) {
        this.func_70299_a(slot, null);
        if (slot == 0) {
            this.seatColor = EnumColor.WHITE;
        }
        if (slot == 1) {
            this.hasBack = 0;
            this.backWoodType = BiblioWoodBlock.EnumWoodType.OAK;
        }
        this.setCustomBackTex("none");
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void rotateConnections(boolean down, EnumFacing oldAngle) {
        if (this.getAngle() != oldAngle) {
            boolean oldN = this.northConnect;
            boolean oldE = this.eastConnect;
            boolean oldS = this.southConnect;
            boolean oldW = this.westConnect;
            this.northConnect = false;
            this.eastConnect = false;
            this.southConnect = false;
            this.westConnect = false;
            if (down) {
                if (oldN) {
                    this.westConnect = true;
                }
                if (oldE) {
                    this.northConnect = true;
                }
                if (oldS) {
                    this.eastConnect = true;
                }
                if (oldW) {
                    this.southConnect = true;
                }
            } else {
                if (oldN) {
                    this.eastConnect = true;
                }
                if (oldE) {
                    this.southConnect = true;
                }
                if (oldS) {
                    this.westConnect = true;
                }
                if (oldW) {
                    this.northConnect = true;
                }
            }
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public void setBack(int back) {
        this.hasBack = back;
    }

    public int getHasBack() {
        return this.hasBack;
    }

    public void setSeatColor(EnumColor color) {
        this.seatColor = color;
    }

    public EnumColor getSeatColor() {
        return this.seatColor;
    }

    public void setNorthConnect(boolean nCon) {
        this.northConnect = nCon;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setSouthConnect(boolean sCon) {
        this.southConnect = sCon;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setEastConnect(boolean eCon) {
        this.eastConnect = eCon;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setWestConnect(boolean wCon) {
        this.westConnect = wCon;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean getNorthConnect() {
        return this.northConnect;
    }

    public boolean getSouthConnect() {
        return this.southConnect;
    }

    public boolean getEastConnect() {
        return this.eastConnect;
    }

    public boolean getWestConnect() {
        return this.westConnect;
    }

    public int setCarpet(ItemStack stack) {
        int stacksize = 0;
        if (stack == null) {
            if (this.isCarpetFull()) {
                this.func_70299_a(2, null);
            }
            stacksize = -1;
            return stacksize;
        }
        if (!this.isCarpetFull()) {
            stacksize = stack.field_77994_a > 1 ? stack.field_77994_a - 1 : 0;
            ItemStack carpetpiece = stack.func_77946_l();
            carpetpiece.field_77994_a = 1;
            this.func_70299_a(2, carpetpiece);
        } else {
            stacksize = stack.field_77994_a;
        }
        return stacksize;
    }

    public EnumColor getCarpetColor() {
        if (this.isCarpetFull()) {
            return EnumColor.getColorFromCarpetOrWool(this.func_70301_a(2));
        }
        return EnumColor.WHITE;
    }

    public boolean isCarpetFull() {
        return this.inventory[2] != null;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public String func_70005_c_() {
        return "Seat";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.hasBack = nbt.func_74762_e("hasBack");
        this.northConnect = nbt.func_74767_n("northConnect");
        this.southConnect = nbt.func_74767_n("southConnect");
        this.eastConnect = nbt.func_74767_n("eastConnect");
        this.westConnect = nbt.func_74767_n("westConnect");
        this.seatColor = EnumColor.getColorEnumFromID(nbt.func_74762_e("seatColor"));
        this.backWoodType = BiblioWoodBlock.EnumWoodType.getEnum(nbt.func_74762_e("backWoodType"));
        this.hasSitter = nbt.func_74767_n("hasSitter");
        this.customBackTex = nbt.func_74779_i("customBackTexture");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74768_a("hasBack", this.hasBack);
        nbt.func_74757_a("northConnect", this.northConnect);
        nbt.func_74757_a("southConnect", this.southConnect);
        nbt.func_74757_a("eastConnect", this.eastConnect);
        nbt.func_74757_a("westConnect", this.westConnect);
        nbt.func_74768_a("seatColor", this.seatColor.getID());
        nbt.func_74768_a("backWoodType", this.backWoodType.getID());
        nbt.func_74757_a("hasSitter", this.hasSitter);
        nbt.func_74778_a("customBackTexture", this.customBackTex);
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        TextComponentString chat = new TextComponentString(this.func_70005_c_());
        return chat;
    }
}

