/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.blocks.BlockClock;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityClock
extends BiblioTileEntity
implements ITickable {
    public int secondCount = 0;
    public int hourCount = 0;
    public float pendulumCount = 0.0f;
    public int activityCount = 0;
    public boolean chimePerformed = false;
    public int chimeLastPerformed = -1;
    public boolean redstonePerformed = false;
    public int redstoneLastPerformed = -1;
    public boolean redstoneActive = false;
    public int redstoneCount = 0;
    public boolean tickSound = true;
    public boolean chimes = false;
    public boolean redstone = false;
    public int[] chimeSettings = new int[48];
    public int[] redstoneSettings = new int[48];
    public boolean isRedstonePulse = true;

    public TileEntityClock() {
        super(0, true);
    }

    public void setSettingFromGui(int[] dings, int[] powers, boolean tickToggle, boolean chimeToggle, boolean redstoneToggle, boolean ispulsing) {
        this.chimeSettings = dings;
        this.redstoneSettings = powers;
        this.tickSound = tickToggle;
        this.chimes = chimeToggle;
        this.redstone = redstoneToggle;
        this.isRedstonePulse = ispulsing;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.chimeSettings = nbt.func_74759_k("chimeSettings");
        this.redstoneSettings = nbt.func_74759_k("redstoneSettings");
        this.tickSound = nbt.func_74767_n("tickSound");
        this.chimes = nbt.func_74767_n("chimeSound");
        this.redstone = nbt.func_74767_n("toggleRedstone");
        this.isRedstonePulse = nbt.func_74767_n("redstonePulse");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74783_a("chimeSettings", this.chimeSettings);
        nbt.func_74783_a("redstoneSettings", this.redstoneSettings);
        nbt.func_74757_a("tickSound", this.tickSound);
        nbt.func_74757_a("chimeSound", this.chimes);
        nbt.func_74757_a("toggleRedstone", this.redstone);
        nbt.func_74757_a("redstonePulse", this.isRedstonePulse);
        return nbt;
    }

    public void func_73660_a() {
        if (this.getVertPosition() != EnumVertPosition.FLOOR) {
            long time = this.field_145850_b.func_72820_D();
            this.activityCount = (int)(time % 24000L / 500L) + 24;
            if (this.activityCount >= 48) {
                this.activityCount -= 48;
            }
            if (this.field_145850_b.field_72995_K) {
                this.hourCount = (int)(time % 24000L / 1000L) * 15;
                this.secondCount = (int)((double)(time % 24000L) / 16.667) * 6;
                double coscount = Math.PI * 2 * ((double)(time % 40L) / 40.0);
                if (this.getVertPosition() == EnumVertPosition.WALL) {
                    this.pendulumCount = (float)(0.17453292519943295 * Math.cos(coscount) * 114.59155902616465);
                }
                if (this.getVertPosition() == EnumVertPosition.CEILING) {
                    this.pendulumCount = (float)(0.04363323129985824 * Math.cos(coscount) * 114.59155902616465);
                }
                if (this.tickSound) {
                    if (time % 40L == 37L) {
                        this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CommonProxy.SOUND_CLOCK_TOCK, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
                    } else if (time % 40L == 17L) {
                        this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CommonProxy.SOUND_CLOCK_TICK, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
                    }
                }
                if (this.chimes) {
                    if (this.chimePerformed && this.chimeLastPerformed != this.activityCount) {
                        this.chimePerformed = false;
                        this.chimeLastPerformed = -1;
                    }
                    if (!this.chimePerformed && this.chimeSettings[this.activityCount] == 1) {
                        this.chimePerformed = true;
                        this.chimeLastPerformed = this.activityCount;
                        this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CommonProxy.SOUND_CLOCK_CHIME, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
                    }
                }
            } else if (this.redstone) {
                this.redstoneAlgo();
            }
        }
    }

    public void redstoneAlgo() {
        TileEntityClock bottomClock;
        TileEntity tile;
        if (this.redstonePerformed && this.redstoneLastPerformed != this.activityCount) {
            this.redstonePerformed = false;
            this.redstoneLastPerformed = -1;
        }
        if (!this.redstonePerformed && this.redstoneSettings[this.activityCount] == 1) {
            if (this.isRedstonePulse) {
                this.redstonePerformed = true;
                this.redstoneLastPerformed = this.activityCount;
            }
            if (!this.redstoneActive) {
                this.setActivateRedstone(true);
                if (this.getVertPosition() == EnumVertPosition.CEILING && (tile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()))) != null && tile instanceof TileEntityClock) {
                    bottomClock = (TileEntityClock)tile;
                    bottomClock.setActivateRedstone(true);
                }
            }
        }
        if (!this.redstonePerformed && this.redstoneSettings[this.activityCount] == 0 && !this.isRedstonePulse && this.redstoneActive) {
            this.setActivateRedstone(false);
            if (this.getVertPosition() == EnumVertPosition.CEILING && (tile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()))) != null && tile instanceof TileEntityClock) {
                bottomClock = (TileEntityClock)tile;
                bottomClock.setActivateRedstone(false);
            }
        }
        if (this.redstoneActive) {
            if (this.redstonePerformed && this.redstoneCount < 40) {
                ++this.redstoneCount;
            } else if (this.redstonePerformed) {
                this.redstoneCount = 0;
                this.setActivateRedstone(false);
                if (this.getVertPosition() == EnumVertPosition.CEILING && (tile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()))) != null && tile instanceof TileEntityClock) {
                    bottomClock = (TileEntityClock)tile;
                    bottomClock.setActivateRedstone(false);
                }
            }
        }
    }

    public void setActivateRedstone(boolean toggle) {
        this.redstoneActive = toggle;
        this.updateSurroundingBlocks((Block)BlockClock.instance);
    }

    public String func_70005_c_() {
        return "Clock";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        TextComponentString chat = new TextComponentString(this.func_70005_c_());
        return chat;
    }
}

