/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.gui.GuiAtlasMap;
import jds.bibliocraft.gui.GuiAtlasWaypointTransfer;
import jds.bibliocraft.gui.GuiBigBook;
import jds.bibliocraft.gui.GuiClipboard;
import jds.bibliocraft.gui.GuiRecipeBook;
import jds.bibliocraft.gui.GuiScreenBookDesk;
import jds.bibliocraft.gui.GuiStockCatalog;
import jds.bibliocraft.helpers.BiblioRenderHelper;
import jds.bibliocraft.helpers.BiblioSortingHelper;
import jds.bibliocraft.helpers.SortedListItem;
import jds.bibliocraft.items.ItemBigBook;
import jds.bibliocraft.items.ItemClipboard;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientPacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FMLProxyPacket packet = event.getPacket();
        if (packet != null) {
            if (packet.channel().equals("BiblioAStand")) {
                this.handlePlayerArmorUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioDrillText")) {
                this.handPlayerDrillTextUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handPlayerAtlasUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasSWP")) {
                this.handleAtlasSwap(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasTGUI")) {
                this.handleAtlasTransferGUI(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioPaneler")) {
                this.handlePanelerTextureStringPacket(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioRecipeText")) {
                this.handleRecipeBookText(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioStockLog")) {
                this.handleBiblioStockroomCatalog(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioDeskOpenGUI")) {
                this.handleDeskOpenGUI(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioUpdateInv")) {
                this.handleInvStackUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioOpenBook")) {
                this.handleOpenBook(packet.payload(), (EntityPlayer)player);
            }
        }
    }

    private void handleOpenBook(ByteBuf packet, EntityPlayer player) {
        final boolean canCraft = packet.readBoolean();
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                ItemStack stackMain = player.func_184586_b(EnumHand.MAIN_HAND);
                ItemStack stackOff = player.func_184586_b(EnumHand.OFF_HAND);
                if (stackMain.func_77973_b() == ItemRecipeBook.instance) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRecipeBook(stackMain, false, 0, 0, 0, player.field_71071_by.field_70461_c, canCraft));
                } else if (stackOff.func_77973_b() == ItemRecipeBook.instance) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRecipeBook(stackOff, false, 0, 0, 0, player.field_71071_by.field_70461_c, canCraft));
                }
            }
        });
    }

    private void handleInvStackUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)packet);
        ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != null && playerStack != null && stack.func_77973_b() == playerStack.func_77973_b()) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
        }
    }

    private void handleDeskOpenGUI(ByteBuf packet, EntityPlayer player) {
        final int x = packet.readInt();
        final int y = packet.readInt();
        final int z = packet.readInt();
        final ItemStack book = ByteBufUtils.readItemStack((ByteBuf)packet);
        final boolean canCraft = packet.readBoolean();
        if (book != null) {
            final Item signedtest = book.func_77973_b();
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (signedtest instanceof ItemWrittenBook) {
                        ClientPacketHandler.this.openWritingGUI((EntityPlayer)player, book, x, y, z, false);
                    }
                    if (signedtest instanceof ItemWritableBook) {
                        ClientPacketHandler.this.openWritingGUI((EntityPlayer)player, book, x, y, z, true);
                    }
                    if (signedtest instanceof ItemClipboard) {
                        ClientPacketHandler.this.openClipboardGUI(book, false, x, y, z);
                    }
                    if (signedtest instanceof ItemBigBook) {
                        ClientPacketHandler.this.openBigBookGUI(book, x, y, z);
                    }
                    if (signedtest instanceof ItemRecipeBook) {
                        ClientPacketHandler.this.openRecipeBookGUI(book, x, y, z, -1, canCraft);
                    }
                    if (Loader.isModLoaded((String)"Thaumcraft") && book.toString().contains("Thaumonomicon")) {
                        signedtest.func_77659_a(book, player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
                    }
                    if (Loader.isModLoaded((String)"Railcraft") && book.toString().contains("railcraft.routing.table")) {
                        signedtest.func_77659_a(book, player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
                    }
                    if (Loader.isModLoaded((String)"craftguide") && book.toString().contains("craftguide")) {
                        signedtest.func_77659_a(book, player.func_130014_f_(), (EntityPlayer)player, EnumHand.MAIN_HAND);
                    }
                    if (!Loader.isModLoaded((String)"Botania") || book.func_77977_a().contentEquals("item.lexicon")) {
                        // empty if block
                    }
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openWritingGUI(EntityPlayer player, ItemStack book, int x, int y, int z, boolean signed) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBookDesk(player, book, signed, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void openClipboardGUI(ItemStack stack, boolean inInv, int x, int y, int z) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiClipboard(stack, inInv, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void openRecipeBookGUI(ItemStack stack, int x, int y, int z, int slot, boolean canCraft) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRecipeBook(stack, true, x, y, z, slot, canCraft));
    }

    @SideOnly(value=Side.CLIENT)
    public void openBigBookGUI(ItemStack stack, int x, int y, int z) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBigBook(stack, false, x, y, z));
    }

    private void handleBiblioStockroomCatalog(ByteBuf packet, EntityPlayer player) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)packet);
        if (tags != null) {
            NBTTagList comp = tags.func_150295_c("compasses", 10);
            int[] compasses = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
            ItemStack[] compassStacks = new ItemStack[]{null, null, null, null, null, null, null, null};
            for (int i = 0; i < comp.func_74745_c(); ++i) {
                int compSlot;
                NBTTagCompound compTag = comp.func_150305_b(i);
                if (compTag == null) continue;
                String invName = "compass" + i;
                String invSlotName = "slot" + i;
                compasses[i] = compSlot = compTag.func_74762_e(invSlotName);
                if (compSlot == -1) continue;
                compassStacks[i] = ItemStack.func_77949_a((NBTTagCompound)compTag);
            }
            NBTTagList alphaTagList = tags.func_150295_c("alphaList", 10);
            final ArrayList<SortedListItem> alphaList = BiblioSortingHelper.convertNBTTagListToArrayList(alphaTagList);
            NBTTagList quanaTagList = tags.func_150295_c("quantaList", 10);
            final ArrayList<SortedListItem> quantaList = BiblioSortingHelper.convertNBTTagListToArrayList(quanaTagList);
            final int[] finalCompasses = compasses;
            final ItemStack[] finalCompassStacks = compassStacks;
            final String title = tags.func_74779_i("title");
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ClientPacketHandler.this.openCatalogGUI((EntityPlayer)Minecraft.func_71410_x().field_71439_g, alphaList, quantaList, finalCompassStacks, finalCompasses, title);
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openCatalogGUI(EntityPlayer player, ArrayList<SortedListItem> AlphaList, ArrayList<SortedListItem> QuantaList, ItemStack[] stacks, int[] compasses, String title) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStockCatalog(player, AlphaList, QuantaList, stacks, compasses, title));
    }

    private void handleRecipeBookText(ByteBuf packet, EntityPlayer player) {
        String text = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int currentSlot = packet.readInt();
        ItemStack currentBook = player.field_71071_by.func_70301_a(currentSlot);
        if (currentBook != null && currentBook.func_77973_b() instanceof ItemRecipeBook) {
            ItemRecipeBook book = (ItemRecipeBook)currentBook.func_77973_b();
            book.updateFromPacket(text);
        }
    }

    private void handlePanelerTextureStringPacket(ByteBuf packet, EntityPlayer player) {
        TileEntity tile;
        ItemStack panels = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        String panelTextureName = "none";
        if (panels != null) {
            panelTextureName = BiblioRenderHelper.getBlockTextureString(panels);
        }
        if ((tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z))) != null && tile instanceof TileEntityFurniturePaneler) {
            TileEntityFurniturePaneler paneler = (TileEntityFurniturePaneler)tile;
            paneler.setCustomCraftingTex(panelTextureName);
        }
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)panelTextureName);
        buffer.writeInt(x);
        buffer.writeInt(y);
        buffer.writeInt(z);
        PacketBuffer payload = new PacketBuffer(buffer);
        BiblioCraft.ch_BiblioPaneler.sendToServer(new FMLProxyPacket(payload, "BiblioPaneler"));
    }

    private void handleAtlasTransferGUI(ByteBuf packet, EntityPlayer player) {
        int z;
        int y;
        final ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        final TileEntityMapFrame tile = (TileEntityMapFrame)player.field_70170_p.func_175625_s(new BlockPos(x, y = packet.readInt(), z = packet.readInt()));
        if (tile != null) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ClientPacketHandler.this.openWaypointTransferGUI((World)Minecraft.func_71410_x().field_71441_e, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, atlas, tile);
                }
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openWaypointTransferGUI(World world, EntityPlayer player, ItemStack stack, TileEntityMapFrame tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasWaypointTransfer(world, player, stack, tile));
    }

    private void handleAtlasSwap(ByteBuf packet, EntityPlayer player) {
        player.field_70125_A = 50.0f;
        final ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ClientPacketHandler.this.openMapGUI((EntityPlayer)Minecraft.func_71410_x().field_71439_g, atlas);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void openMapGUI(EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap((World)Minecraft.func_71410_x().field_71441_e, player, stack));
    }

    private void handPlayerAtlasUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
    }

    private void handlePlayerArmorUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack armor = null;
        int armorslot = -1;
        armor = ByteBufUtils.readItemStack((ByteBuf)packet);
        armorslot = packet.readInt();
        if (armorslot != -1) {
            player.field_71071_by.field_70460_b[armorslot] = armor;
        }
    }

    private void handPlayerDrillTextUpdate(ByteBuf packet, EntityPlayer player) {
        String displayText = ByteBufUtils.readUTF8String((ByteBuf)packet);
        ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
        if (playerhand != null && playerhand.func_77973_b() instanceof ItemDrill) {
            ItemDrill drill = (ItemDrill)playerhand.func_77973_b();
            drill.updateFromPacket(displayText);
        }
    }
}

