/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioLightBlock;
import jds.bibliocraft.blocks.BlockLampGold;
import jds.bibliocraft.blocks.BlockLampIron;
import jds.bibliocraft.blocks.BlockLanternGold;
import jds.bibliocraft.blocks.BlockLanternIron;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.helpers.EnumMetalType;
import jds.bibliocraft.helpers.ModelCache;
import jds.bibliocraft.states.MetalTypeProperty;
import jds.bibliocraft.states.MetalTypeState;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BiblioModelColor
implements IPerspectiveAwareModel {
    private IModel model = null;
    private IBakedModel baseModel;
    private String modelLocation = " ";
    private EnumColor blockColor = EnumColor.WHITE;
    private EnumMetalType metalType = EnumMetalType.GOLD;
    private String innerColor = "minecraft:blocks/wool_colored_white";
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IPerspectiveAwareModel wrapper;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(BiblioModelColor.this.getTextureLocation(BiblioModelColor.this.blockColor, BiblioModelColor.this.metalType, location.toString()));
        }
    };

    public BiblioModelColor(String modelLoc) {
        this.modelLocation = modelLoc;
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private void getModel(IBlockState state, int attempt) {
        block12: {
            if (this.model == null || this.model != null && !this.model.toString().contains("obj.OBJModel")) {
                try {
                    this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(this.modelLocation));
                    this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    this.gotOBJ = true;
                }
                catch (Exception e) {
                    this.model = ModelLoaderRegistry.getMissingModel();
                    this.gotOBJ = false;
                    if (attempt >= 6) break block12;
                    this.getModel(state, attempt + 1);
                    return;
                }
            }
        }
        OBJModel.OBJState modelState = new OBJModel.OBJState(this.getDefaultVisiableModelParts(), true);
        if (state != null && state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(OBJModel.OBJProperty.INSTANCE)) {
                modelState = (OBJModel.OBJState)exState.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
            }
            if (modelState == null) {
                return;
            }
            if (exState.getUnlistedNames().contains((Object)MetalTypeProperty.instance)) {
                MetalTypeState metal = (MetalTypeState)exState.getValue((IUnlistedProperty)MetalTypeProperty.instance);
                this.metalType = metal.getMetalType();
            }
            this.blockColor = (EnumColor)((Object)exState.func_177229_b((IProperty)BiblioLightBlock.COLOR));
        }
        Function<ResourceLocation, TextureAtlasSprite> texture = this.textureGetter;
        if (state != null && state instanceof IExtendedBlockState) {
            IBakedModel bakedModel;
            this.baseModel = bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, texture);
        } else {
            String name = this.blockColor.func_176610_l() + this.metalType.getID();
            if (this.cache.hasModel(name)) {
                this.baseModel = this.cache.getCurrentMatch();
            } else {
                IBakedModel bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, texture);
                if (this.gotOBJ) {
                    this.cache.addToCache(bakedModel, name);
                }
                this.baseModel = bakedModel;
            }
        }
    }

    public abstract List<String> getDefaultVisiableModelParts();

    public abstract String getTextureLocation(EnumColor var1, EnumMetalType var2, String var3);

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.5f, 0.25f, 0.9f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.75f, 0.2f, -1.37f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                transform = this.getTweakedLEFTHANDTransform(transform);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.9f, 0.4f, 0.2f), new Quat4f(0.0f, 0.0f, -0.25f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.28f, 1.2f, 0.2f), new Quat4f(0.0f, 0.0f, -0.25f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                transform = this.getTweakedLEFTHANDTransform(transform);
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.75f, 0.0f), new Quat4f(0.25f, 1.0f, 0.25f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.4f, 0.0f, 1.0f));
                transform = this.getTweakedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.55f, 0.1f, 0.55f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.83f, 0.15f, -0.8f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        transform = this.getTweakedMasterTransfer(transform);
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public TRSRTransformation getTweakedMasterTransfer(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedGUITransform(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedLEFTHANDTransform(TRSRTransformation transform) {
        return transform;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        this.getModel(state, 0);
        try {
            List q = this.baseModel.func_188616_a(state, side, rand);
            return q;
        }
        catch (NullPointerException e) {
            return new ArrayList<BakedQuad>();
        }
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            BiblioModelColor.this.blockColor = EnumColor.getColorEnumFromID(stack.func_77952_i());
            if (stack != null) {
                Item item = stack.func_77973_b();
                if (item == Item.func_150898_a((Block)BlockLampGold.instance) || item == Item.func_150898_a((Block)BlockLanternGold.instance)) {
                    BiblioModelColor.this.metalType = EnumMetalType.GOLD;
                } else if (item == Item.func_150898_a((Block)BlockLampIron.instance) || item == Item.func_150898_a((Block)BlockLanternIron.instance)) {
                    BiblioModelColor.this.metalType = EnumMetalType.IRON;
                }
            }
            BiblioModelColor.this.getModel(null, 0);
            return BiblioModelColor.this.wrapper;
        }
    }
}

