/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BlockLoader;
import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.helpers.EnumMetalType;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.states.MetalTypeProperty;
import jds.bibliocraft.states.MetalTypeState;
import jds.bibliocraft.tileentities.BiblioLightTileEntity;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiblioLightBlock
extends BiblioBlock {
    public static String name = "bibliolight";
    public static final PropertyEnum COLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);

    public BiblioLightBlock(String name) {
        super(Material.field_151573_f, SoundType.field_185852_e, BlockLoader.biblioLightsTab, name);
        this.func_149715_a(1.0f);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BiblioLightTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int x = 0; x < 16; ++x) {
            subItems.add(new ItemStack(item, 1, x));
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{COLOR}, new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, MetalTypeProperty.instance});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumColor color = EnumColor.getColorEnumFromID(meta);
        return this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)((Object)color));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumColor color = (EnumColor)((Object)state.func_177229_b((IProperty)COLOR));
        return color.getID();
    }

    @Override
    public ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState state) {
        ExtendedBlockState exstate = new ExtendedBlockState((Block)this, new IProperty[]{COLOR}, new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, MetalTypeProperty.instance});
        return exstate;
    }

    @Override
    public IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity biblioTile, IExtendedBlockState state) {
        MetalTypeState metal = new MetalTypeState(EnumMetalType.GOLD);
        if (biblioTile instanceof BiblioLightTileEntity) {
            BiblioLightTileEntity tile = (BiblioLightTileEntity)biblioTile;
            metal = new MetalTypeState(tile.getLightType());
        }
        EnumColor color = EnumColor.getColorEnumFromID(biblioTile.func_145832_p());
        state = (IExtendedBlockState)state.withProperty((IUnlistedProperty)MetalTypeProperty.instance, (Object)metal).func_177226_a((IProperty)COLOR, (Comparable)((Object)color));
        return state;
    }

    @Override
    public abstract List<String> getModelParts(BiblioTileEntity var1);

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        int pitch = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++pitch;
        if ((pitch %= 4) == 0) {
            biblioTile.setVertPosition(EnumVertPosition.CEILING);
        } else if (pitch == 1) {
            biblioTile.setVertPosition(EnumVertPosition.WALL);
        } else {
            biblioTile.setVertPosition(EnumVertPosition.FLOOR);
        }
        this.additionalLightPlacmentCommands(biblioTile);
    }

    public abstract void additionalLightPlacmentCommands(BiblioTileEntity var1);

    @Override
    public ItemStack getPickBlockExtras(ItemStack stack, World world, BlockPos pos) {
        return stack;
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    @Override
    public IBlockState getFinalBlockstate(IBlockState state, IBlockState newState) {
        return newState;
    }
}

