/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.world.generator.tree.GeneratorHugeTree;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GeneratorMegaJungleTree
extends GeneratorHugeTree {
    protected GeneratorMegaJungleTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos startPos) {
        int y;
        int height = this.chooseHeight(rand);
        if (!this.canGrowHere(worldIn, rand, startPos, height)) {
            return false;
        }
        this.addTop(worldIn, startPos.func_177981_b(height), 2);
        for (y = startPos.func_177956_o() + height - 2 - rand.nextInt(4); y > startPos.func_177956_o() + height / 2; y -= 2 + rand.nextInt(4)) {
            float direction = rand.nextFloat() * (float)Math.PI * 2.0f;
            float cosDir = MathHelper.func_76134_b((float)direction);
            float sinDir = MathHelper.func_76126_a((float)direction);
            int x = 0;
            int z = 0;
            for (int s = 0; s < 5; ++s) {
                x = startPos.func_177958_n() + (int)(1.5f + cosDir * (float)s);
                z = startPos.func_177952_p() + (int)(1.5f + sinDir * (float)s);
                this.setLog(worldIn, new BlockPos(x, y - 3 + s / 2, z));
            }
            int clusterHeight = 1 + rand.nextInt(2);
            for (int i = 0; i <= clusterHeight; ++i) {
                this.addLeafLayer(worldIn, new BlockPos(x, y - i, z), i + 1);
            }
        }
        for (y = 0; y < height; ++y) {
            BlockPos trunkPosSW;
            BlockPos trunkPosSE;
            BlockPos trunkPosNW = startPos.func_177981_b(y);
            if (this.setLog(worldIn, trunkPosNW) && y > 0) {
                this.maybeAddVine(worldIn, rand, trunkPosNW.func_177976_e(), EnumFacing.EAST);
                this.maybeAddVine(worldIn, rand, trunkPosNW.func_177978_c(), EnumFacing.SOUTH);
            }
            if (y >= height - 1) continue;
            BlockPos trunkPosNE = trunkPosNW.func_177974_f();
            if (this.setLog(worldIn, trunkPosNE) && y > 0) {
                this.maybeAddVine(worldIn, rand, trunkPosNE.func_177974_f(), EnumFacing.WEST);
                this.maybeAddVine(worldIn, rand, trunkPosNE.func_177978_c(), EnumFacing.SOUTH);
            }
            if (this.setLog(worldIn, trunkPosSE = trunkPosNW.func_177968_d().func_177974_f()) && y > 0) {
                this.maybeAddVine(worldIn, rand, trunkPosSE.func_177974_f(), EnumFacing.WEST);
                this.maybeAddVine(worldIn, rand, trunkPosSE.func_177968_d(), EnumFacing.NORTH);
            }
            if (!this.setLog(worldIn, trunkPosSW = trunkPosNW.func_177968_d()) || y <= 0) continue;
            this.maybeAddVine(worldIn, rand, trunkPosSW.func_177976_e(), EnumFacing.EAST);
            this.maybeAddVine(worldIn, rand, trunkPosSW.func_177968_d(), EnumFacing.NORTH);
        }
        return true;
    }

    private void maybeAddVine(World worldIn, Random rand, BlockPos pos, EnumFacing side) {
        if (this.vine == null) {
            return;
        }
        if (rand.nextInt(8) > 0) {
            this.setVine(worldIn, rand, pos, side, 1);
        }
    }

    private void addTop(World worldIn, BlockPos pos, int radius) {
        for (int j = -2; j <= 0; ++j) {
            this.addWideLeafLayer(worldIn, pos.func_177981_b(j), radius + 1 - j);
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.vine = conf.getBlockState("vinesState", this.vine);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorMegaJungleTree>
    implements IGenerator.IGeneratorBuilder<GeneratorMegaJungleTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 6;
            this.maxHeight = 20;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log(BlockPlanks.EnumType.JUNGLE);
            this.leaves(BlockPlanks.EnumType.JUNGLE);
            this.vine = Blocks.field_150395_bd.func_176223_P();
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
        }

        @Override
        public GeneratorMegaJungleTree create() {
            return new GeneratorMegaJungleTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight);
        }
    }
}

