/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorBayouTree
extends GeneratorTreeBase {
    private int minLeavesRadius;
    private int leavesGradient;
    private int vineAttempts;
    private int maxVineLength;
    private IBlockPosQuery rootsReplace;

    public GeneratorBayouTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, int minLeavesRadius, int leavesGradient, int vineAttempts, int maxVineLength, IBlockPosQuery rootsReplace) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight);
        this.minLeavesRadius = minLeavesRadius;
        this.leavesGradient = leavesGradient;
        this.vineAttempts = vineAttempts;
        this.maxVineLength = maxVineLength;
        this.rootsReplace = rootsReplace;
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return GeneratorUtils.ScatterYMethod.AT_GROUND.getBlockPos(world, random, x, z);
    }

    public boolean setRoot(World world, BlockPos pos) {
        if (this.rootsReplace.matches(world, pos)) {
            world.func_180501_a(pos, this.log, 2);
            return true;
        }
        return false;
    }

    public boolean checkRootViable(World world, BlockPos pos, int rootHeight, EnumFacing direction) {
        pos = pos.func_177972_a(direction).func_177981_b(rootHeight - 1);
        for (int i = 0; i < rootHeight; ++i) {
            if (!this.rootsReplace.matches(world, pos)) {
                return false;
            }
            if (!this.placeOn.matches(world, pos = pos.func_177977_b())) continue;
            return true;
        }
        return false;
    }

    public boolean checkSpace(World world, BlockPos pos, int rootHeight, int middleHeight, int height) {
        int rootsOk = 0;
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            if (!this.checkRootViable(world, pos, rootHeight, direction)) continue;
            ++rootsOk;
        }
        if (rootsOk < 2) {
            return false;
        }
        for (int y = rootHeight; y <= height; ++y) {
            int radius = y <= rootHeight + middleHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateTop(World world, Random random, BlockPos pos, int topHeight) {
        for (int y = 0; y < topHeight; ++y) {
            int radius = Math.min(3, this.minLeavesRadius + (topHeight - y) / this.leavesGradient);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int dist = Math.abs(x) + Math.abs(z);
                    if (dist >= 4 && (dist != 4 || random.nextInt(2) != 0)) continue;
                    this.setLeaves(world, pos.func_177982_a(x, y, z));
                }
            }
            if (y < topHeight - 1) {
                this.setLog(world, pos.func_177982_a(0, y, 0));
                continue;
            }
            this.setLeaves(world, pos.func_177982_a(0, y, 0));
        }
    }

    public void generateRoots(World world, Random random, BlockPos pos, int rootHeight) {
        for (int i = 0; i < rootHeight; ++i) {
            this.setRoot(world, pos.func_177978_c());
            this.setRoot(world, pos.func_177974_f());
            this.setRoot(world, pos.func_177968_d());
            this.setRoot(world, pos.func_177976_e());
            pos = pos.func_177984_a();
        }
        this.setRoot(world, pos.func_177977_b());
    }

    public boolean func_180709_b(World world, Random random, BlockPos startPos) {
        int rootHeight;
        int topHeight;
        if (!this.placeOn.matches(world, startPos.func_177977_b())) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        int middleHeight = height - (topHeight = Math.min(6, GeneratorUtils.nextIntBetween(random, height / 5, height / 3))) - (rootHeight = Math.min(5, GeneratorUtils.nextIntBetween(random, height / 4, height / 2)));
        if (middleHeight < 1) {
            return false;
        }
        BlockPos pos = startPos.func_177977_b();
        if (!this.checkSpace(world, pos, rootHeight, middleHeight, height)) {
            return false;
        }
        this.generateRoots(world, random, pos, rootHeight);
        pos = pos.func_177981_b(rootHeight);
        for (int i = 0; i < middleHeight; ++i) {
            this.setLog(world, pos);
            pos = pos.func_177984_a();
        }
        this.generateTop(world, random, pos, topHeight);
        if (this.vine != null) {
            int maxLeavesRadius = this.minLeavesRadius + topHeight / this.leavesGradient;
            this.addVines(world, random, startPos, height, maxLeavesRadius, this.vineAttempts);
        }
        return true;
    }

    protected void addVines(World world, Random rand, BlockPos startPos, int height, int leavesRadius, int generationAttempts) {
        block0: for (int i = 0; i < generationAttempts; ++i) {
            EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            EnumFacing back = direction.func_176734_d();
            EnumFacing sideways = direction.func_176746_e();
            BlockPos pos = startPos.func_177981_b(GeneratorUtils.nextIntBetween(rand, 2, height)).func_177967_a(direction, leavesRadius + 1).func_177967_a(sideways, GeneratorUtils.nextIntBetween(rand, -leavesRadius, leavesRadius));
            for (int l = 0; l < leavesRadius; ++l) {
                IBlockState state = world.func_180495_p(pos.func_177967_a(back, 1 + l));
                if (state != this.leaves && state != this.log) continue;
                this.setVine(world, rand, pos.func_177967_a(back, l), back, this.maxVineLength);
                continue block0;
            }
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.minLeavesRadius = conf.getInt("minLeavesRadius", this.minLeavesRadius);
        this.leavesGradient = conf.getInt("leavesGradient", this.leavesGradient);
        this.vineAttempts = conf.getInt("vineAttempts", this.vineAttempts);
        this.maxVineLength = conf.getInt("maxVineLength", this.maxVineLength);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.rootsReplace = conf.getBlockPosQuery("rootsReplace", this.rootsReplace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.vine = conf.getBlockState("vinesState", this.vine);
        this.trunkFruit = conf.getBlockState("trunkFruitState", this.trunkFruit);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorBayouTree>
    implements IGenerator.IGeneratorBuilder<GeneratorBayouTree> {
        protected int minLeavesRadius;
        protected int leavesGradient;
        protected int vineAttempts;
        protected int maxVineLength;
        protected IBlockPosQuery rootsReplace;

        public Builder minLeavesRadius(int a) {
            this.minLeavesRadius = a;
            return (Builder)this.self();
        }

        public Builder leavesGradient(int a) {
            this.leavesGradient = a;
            return (Builder)this.self();
        }

        public Builder vineAttempts(int a) {
            this.vineAttempts = a;
            return (Builder)this.self();
        }

        public Builder maxVineLength(int a) {
            this.maxVineLength = a;
            return (Builder)this.self();
        }

        public Builder rootsReplace(IBlockPosQuery a) {
            this.replace = a;
            return (Builder)this.self();
        }

        public Builder rootsReplace(String a) throws BlockQuery.BlockQueryParseException {
            this.replace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder rootsReplace(Block a) {
            this.replace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder rootsReplace(IBlockState a) {
            this.replace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.rootsReplace = BlockQueries.rootsCanDigThrough;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = Blocks.field_150395_bd.func_176223_P();
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.minHeight = 8;
            this.maxHeight = 18;
            this.minLeavesRadius = 2;
            this.leavesGradient = 4;
            this.vineAttempts = 20;
            this.maxVineLength = 20;
        }

        @Override
        public GeneratorBayouTree create() {
            return new GeneratorBayouTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.minLeavesRadius, this.leavesGradient, this.vineAttempts, this.maxVineLength, this.rootsReplace);
        }
    }
}

