/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLilypad;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorFlora
extends GeneratorReplacing {
    protected int generationAttempts;

    public GeneratorFlora(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Block block = this.with.func_177230_c();
        for (int i = 0; i < this.generationAttempts; ++i) {
            boolean canStay;
            BlockPos genPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!this.placeOn.matches(world, genPos.func_177977_b()) || !this.replace.matches(world, genPos) || genPos.func_177956_o() >= 255 || !(canStay = block instanceof BlockBOPDecoration ? ((BlockBOPDecoration)block).canBlockStay(world, genPos, this.with) : (block instanceof BlockBush ? ((BlockBush)block).func_176196_c(world, genPos) : block.func_176196_c(world, genPos)))) continue;
            world.func_180501_a(genPos, this.with, 2);
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
    }

    public static class Builder
    extends InnerBuilder<Builder, GeneratorFlora>
    implements IGenerator.IGeneratorBuilder<GeneratorFlora> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = Blocks.field_150328_O.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.generationAttempts = 32;
        }

        @Override
        public GeneratorFlora create() {
            return new GeneratorFlora(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.generationAttempts);
        }
    }

    protected static abstract class InnerBuilder<T extends GeneratorReplacing.InnerBuilder<T, G>, G extends GeneratorFlora>
    extends GeneratorReplacing.InnerBuilder<T, G> {
        protected int generationAttempts;

        protected InnerBuilder() {
        }

        public T with(BOPPlants a) {
            this.with = BlockBOPPlant.paging.getVariantState(a);
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T with(BOPFlowers a) {
            this.with = BlockBOPFlower.paging.getVariantState(a);
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T with(BlockBOPMushroom.MushroomType a) {
            this.with = BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)((Object)a));
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T with(BlockBOPLilypad.LilypadType a) {
            this.with = BOPBlocks.waterlily.func_176223_P().func_177226_a((IProperty)BlockBOPLilypad.VARIANT, (Comparable)((Object)a));
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T with(BlockFlower.EnumFlowerType a) {
            BlockFlower flowerBlock = a.func_176964_a().func_180346_a();
            this.with = flowerBlock.func_176223_P().func_177226_a(flowerBlock.func_176494_l(), (Comparable)a);
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T with(BlockTallGrass.EnumType a) {
            this.with = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)a);
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T withNonDecayingLeaf(BlockPlanks.EnumType a) {
            IBlockState leafState = a.func_176839_a() < 4 ? Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)a) : Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)a);
            this.with = leafState.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T withNonDecayingLeaf(BOPTrees a) {
            this.with = BlockBOPLeaves.paging.getVariantState(a).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }

        public T generationAttempts(int a) {
            this.generationAttempts = a;
            return (T)((GeneratorReplacing.InnerBuilder)this.self());
        }
    }
}

