/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.item.ItemBOPBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPMushroom
extends BlockBOPDecoration {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", MushroomType.class);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l();
    }

    public BlockBOPMushroom() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)MushroomType.TOADSTOOL)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)MushroomType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public int func_149750_m(IBlockState state) {
        switch ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case GLOWSHROOM: {
                return 6;
            }
        }
        return super.func_149750_m(state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        MushroomType plant = (MushroomType)((Object)state.func_177229_b((IProperty)VARIANT));
        switch (plant) {
            case GLOWSHROOM: 
            case SHADOW_SHROOM: {
                return new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
            }
            case TOADSTOOL: 
            case FLAT_MUSHROOM: {
                return new AxisAlignedBB(0.20000001788, 0.0, 0.20000001788, 0.79999998211, (double)0.6f, 0.79999998211);
            }
        }
        return new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.4f, (double)0.7f);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        switch ((MushroomType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case TOADSTOOL: {
                return BlockQueries.fertileOrNetherrack.matches(world, pos.func_177977_b());
            }
            case GLOWSHROOM: {
                return BlockQueries.sustainsCave.matches(world, pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150348_b;
            }
            case SHADOW_SHROOM: {
                return BlockQueries.endish.matches(world, pos.func_177977_b());
            }
        }
        return BlockQueries.fertile.matches(world, pos.func_177977_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public static enum MushroomType implements IStringSerializable
    {
        TOADSTOOL,
        PORTOBELLO,
        BLUE_MILK_CAP,
        GLOWSHROOM,
        FLAT_MUSHROOM,
        SHADOW_SHROOM;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

