/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.network;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.network.Packet;
import com.amadornes.rscircuits.part.PartCircuit;
import com.google.common.base.Function;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketPlacementData
extends Packet<PacketPlacementData> {
    private ResourceLocation factoryType;
    private BlockPos offset;
    private EnumFacing face;
    private byte[] data;
    private IComponentFactory.EnumPlacementType type;

    public PacketPlacementData(ResourceLocation factoryType, BlockPos offset, EnumFacing face, byte[] data, IComponentFactory.EnumPlacementType type) {
        this.factoryType = factoryType;
        this.offset = offset;
        this.face = face;
        this.data = data;
        this.type = type;
    }

    public PacketPlacementData() {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.handle(player));
    }

    private <T> void handle(EntityPlayer player) {
        IComponentFactory factory = ComponentRegistry.INSTANCE.getFactory(this.factoryType);
        HashMap<BlockPos, Object> map = new HashMap<BlockPos, Object>();
        PartCircuit circuit = PartCircuit.getCircuitAt(player.field_70170_p, this.offset, this.face);
        if (circuit == null) {
            return;
        }
        factory.deserialize(new PacketBuffer(Unpooled.copiedBuffer((byte[])this.data)), map, (Function<BlockPos, ICircuit>)((Function)p -> circuit.circuit.getCircuit((BlockPos)p)), player);
        ItemStack stack = player.func_184614_ca();
        if (stack != null) {
            map.forEach((pos, d) -> {
                if (stack.field_77994_a > 0 && factory.placeComponent(circuit.circuit, (BlockPos)pos, d, this.type, map, false) && !player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            });
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.factoryType.toString());
        buf.func_179255_a(this.offset);
        buf.func_179249_a((Enum)this.face);
        buf.func_179250_a(this.data);
        buf.func_179249_a((Enum)this.type);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.factoryType = new ResourceLocation(buf.func_150789_c(128));
        this.offset = buf.func_179259_c();
        this.face = (EnumFacing)buf.func_179257_a(EnumFacing.class);
        this.data = buf.func_179251_a();
        this.type = (IComponentFactory.EnumPlacementType)buf.func_179257_a(IComponentFactory.EnumPlacementType.class);
    }
}

