/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.network;

import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.network.LocatedPacket;
import com.amadornes.rscircuits.part.PartCircuit;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketCustomPayload
extends LocatedPacket<PacketCustomPayload> {
    private UUID partID;
    private BlockPos pos;
    private EnumComponentSlot slot;
    private byte[] data;

    public PacketCustomPayload(PartCircuit circuit, BlockPos pos, EnumComponentSlot slot, byte[] data) {
        super(circuit.getPos());
        this.partID = circuit.getContainer().getPartID((IMultipart)circuit);
        this.pos = pos;
        this.slot = slot;
        this.data = data;
    }

    public PacketCustomPayload() {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            IMultipart part;
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)player.field_70170_p, (BlockPos)((LocatedPacket)this).pos);
            if (container != null && (part = container.getPartFromID(this.partID)) != null & part instanceof PartCircuit) {
                ((PartCircuit)part).circuit.handleCustomPayload(this.pos, this.slot, Unpooled.copiedBuffer((byte[])this.data));
            }
        });
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.partID);
        buf.func_179255_a(this.pos);
        buf.func_179249_a((Enum)this.slot);
        buf.func_179250_a(this.data);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.partID = buf.func_179253_g();
        this.pos = buf.func_179259_c();
        this.slot = (EnumComponentSlot)buf.func_179257_a(EnumComponentSlot.class);
        this.data = buf.func_179251_a();
    }
}

