/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.circuit;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.circuit.Circuit;
import com.amadornes.rscircuits.circuit.ICircuitContainer;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.circuit.ComponentCircuitSlave;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.part.PartCircuit;
import com.google.common.base.Function;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ComponentCircuit
extends ComponentFace
implements ICircuitContainer {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "circuit");
    final Circuit circuit = new Circuit(this);
    int size;
    boolean removing = false;

    public ComponentCircuit(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    public ComponentCircuit(ICircuit circuit, NBTTagCompound tag) {
        super(circuit, EnumComponentSlot.BOTTOM);
        this.circuit.readFromNBT(tag, true);
        this.size = Circuit.getSize(this.circuit.computeComplexity() + 0.25f);
        if (tag.func_74764_b("complexity")) {
            this.size = Circuit.getSize(tag.func_74760_g("complexity"));
        }
        if (tag.func_74764_b("size")) {
            this.size = Math.max(this.size, Math.min(tag.func_74762_e("size"), 3));
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.25f + this.circuit.computeComplexity();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public float getSize() {
        return super.getSize() * (float)this.size;
    }

    @Override
    public Vec3d getOffset() {
        return new Vec3d(1.0, 0.0, 1.0).func_186678_a((double)(this.size - 1) * 0.5 / (double)this.size);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PartCircuit.PROPERTY_IO_MODE, (Object)this.circuit.getIOModes()).withProperty(PartCircuit.PROPERTY_NAME, (Object)this.circuit.getName());
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y;
    }

    @Override
    public IRedstoneConductor.EnumConnectionType getBundledConnection(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y ? IRedstoneConductor.EnumConnectionType.BIDIRECTIONAL : IRedstoneConductor.EnumConnectionType.NONE;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return this.circuit.getOutput(side, color, bundled);
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
        if (slot == EnumComponentSlot.BOTTOM && side.face.func_176740_k() != EnumFacing.Axis.Y && !(component instanceof ComponentCircuit) && !(component instanceof ComponentCircuitSlave)) {
            this.circuit.forEachEdge(IComponent::onWorldChange, side, 0, 0, EnumComponentSlot.VALUES);
        }
    }

    @Override
    public void onAddedPost() {
        this.circuit.forEach(IComponent::onLoaded);
        this.circuit.forEach(IComponent::onCircuitAdded);
        for (EnumCircuitSide side : EnumCircuitSide.HORIZONTALS) {
            this.circuit.forEachEdge(IComponent::onWorldChange, side, 0, 0, EnumComponentSlot.VALUES);
        }
    }

    @Override
    public void onCircuitAdded() {
        this.circuit.forEach(IComponent::onLoaded);
        this.circuit.forEach(IComponent::onCircuitAdded);
        for (EnumCircuitSide side : EnumCircuitSide.HORIZONTALS) {
            this.circuit.forEachEdge(IComponent::onWorldChange, side, 0, 0, EnumComponentSlot.VALUES);
        }
    }

    @Override
    public void onRemoved() {
        this.circuit.forEach(IComponent::onCircuitRemoved);
        if (!this.removing) {
            this.removing = true;
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.getCircuit().removeComponent(this.getCircuit().getComponent(this.getPos().func_177982_a(x, 0, z), this.slot));
                }
            }
            this.removing = false;
        }
    }

    @Override
    public void onCircuitRemoved() {
        this.circuit.forEach(IComponent::onCircuitRemoved);
    }

    @Override
    public void tick() {
        this.circuit.tickScheduled();
        this.circuit.tick();
        this.circuit.tickEnd();
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, (double)this.size, (double)(2 * this.size) / 16.0, (double)this.size));
    }

    @Override
    public ItemStack getPickedItem() {
        ItemStack stack = new ItemStack(SCMItems.circuit);
        if (!this.circuit.isEmpty()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.circuit.writeToNBT(tag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public List<ItemStack> getPlacementItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(SCMItems.circuit));
        this.circuit.forEach(c -> list.addAll(c.getPlacementItems()));
        return list;
    }

    @Override
    public void rotatePre(Rotation rotation) {
        this.circuit.rotate(rotation);
    }

    @Override
    public void rotatePost() {
    }

    @Override
    public boolean isInWorld() {
        return false;
    }

    @Override
    public World getWorld() {
        return this.getCircuit().getWorld();
    }

    @Override
    public EnumFacing getFace() {
        return EnumFacing.DOWN;
    }

    @Override
    public Circuit getCircuitAt(BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            IComponent c = this.getCircuit().getComponent(pos, this.slot);
            return c instanceof ComponentCircuit ? ((ComponentCircuit)c).circuit : null;
        }
        return null;
    }

    @Override
    public void markDirty() {
        this.getCircuit().markDirty();
    }

    @Override
    public void markRenderUpdate() {
    }

    @Override
    public void notifyNeighbors() {
        this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
    }

    @Override
    public void notifyNeighbor(EnumCircuitSide side, boolean strong) {
        for (int i = 0; i < this.size; ++i) {
            BlockPos p = this.getPos().func_177982_a(side == EnumCircuitSide.RIGHT ? 0 : (side == EnumCircuitSide.LEFT ? this.size - 1 : i), 0, side == EnumCircuitSide.BACK ? 0 : (side == EnumCircuitSide.FRONT ? this.size - 1 : i));
            this.getCircuit().notifyUpdate(p, this.slot, side);
        }
    }

    @Override
    public void sendUpdatePacket() {
    }

    @Override
    public boolean isEncapsulated() {
        return true;
    }

    @Override
    public void sendCustomPayload(BlockPos pos, EnumComponentSlot slot, ByteBuf buf) {
    }

    @Override
    public byte getInput(EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        if (side.face.func_176740_k() != EnumFacing.Axis.Y) {
            int input = 0;
            for (int i = 0; i < this.size; ++i) {
                BlockPos p = this.getPos().func_177982_a(side == EnumCircuitSide.RIGHT ? 0 : (side == EnumCircuitSide.LEFT ? this.size - 1 : i), 0, side == EnumCircuitSide.BACK ? 0 : (side == EnumCircuitSide.FRONT ? this.size - 1 : i));
                IComponent c = ComponentCircuit.getNeighbor(this.getCircuit(), p, this.slot, side);
                if (c == null || !c.isOutput(this.slot, side.getOpposite()) || !c.isStrongOutput(this.slot, side.getOpposite())) continue;
                if (!bundled && c.getBundledConnection(EnumComponentSlot.BOTTOM, side.getOpposite()) == IRedstoneConductor.EnumConnectionType.NONE) {
                    for (EnumDyeColor col : EnumDyeColor.values()) {
                        input = Math.max(input, c.getOutputSignal(this.slot, side.getOpposite(), col, false) & 0xFF);
                    }
                    continue;
                }
                input = Math.max(input, c.getOutputSignal(this.slot, side.getOpposite(), color, bundled) & 0xFF);
            }
            return (byte)input;
        }
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = this.circuit.writeToNBT(super.writeToNBT(tag));
        tag.func_74768_a("size", this.size);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.circuit.readFromNBT(tag);
        this.size = tag.func_74762_e("size");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.func_150786_a(this.circuit.writeToNBT(new NBTTagCompound()));
        buf.writeInt(this.size);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        try {
            this.circuit.readFromNBT(buf.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.size = buf.readInt();
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
        super.serializePlacement(buf);
        buf.func_150786_a(this.circuit.writeToNBT(new NBTTagCompound()));
        buf.writeInt(this.size);
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
        super.deserializePlacement(buf);
        try {
            this.circuit.readFromNBT(buf.func_150793_b(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.size = buf.readInt();
    }

    @Override
    public void spawnMagicSmoke(BlockPos pos) {
        this.circuit.spawnMagicSmoke(this.getPos());
    }

    @Override
    public void spawnStack(ItemStack stack) {
        this.circuit.spawnStack(stack);
    }

    @Override
    public void onCleared() {
    }

    @Override
    public void debug(EntityPlayer player) {
        super.debug(player);
    }

    public static class Factory
    extends SimpleFactory<ComponentCircuit> {
        @Override
        public BlockStateContainer createBlockState() {
            return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{PartCircuit.PROPERTY_NAME, PartCircuit.PROPERTY_IO_MODE});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/circuit");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.circuit && stack.func_77942_o() && stack.func_77978_p().func_74764_b("complexity");
        }

        @Override
        public boolean placeComponent(ICircuit circuit, BlockPos pos, ComponentCircuit data, IComponentFactory.EnumPlacementType type, Map<BlockPos, ComponentCircuit> otherData, boolean simulate) {
            int z;
            int x;
            if (data.size <= 0 || data.size > 3) {
                return false;
            }
            int size = Math.max(1, data.size);
            IComponent[][] components = new IComponent[size][size];
            for (x = 0; x < size; ++x) {
                for (z = 0; z < size; ++z) {
                    ComponentFace componentFace = x == 0 && z == 0 ? data : new ComponentCircuitSlave(circuit, data, new BlockPos(x, 0, z));
                    components[x][z] = componentFace;
                    ComponentFace c = componentFace;
                    if (circuit.addComponent(pos.func_177982_a(x, 0, z), c, true)) continue;
                    return false;
                }
            }
            if (!simulate) {
                for (x = 0; x < size; ++x) {
                    for (z = 0; z < size; ++z) {
                        circuit.addComponent(pos.func_177982_a(x, 0, z), components[x][z], false);
                    }
                }
            }
            return true;
        }

        @Override
        public ComponentCircuit instantiate(ICircuit circuit) {
            return new ComponentCircuit(circuit);
        }

        @Override
        public ComponentCircuit instantiate(ICircuit circuit, ItemStack stack) {
            return new ComponentCircuit(circuit, stack.func_77978_p());
        }

        @Override
        public void serialize(PacketBuffer buf, Map<BlockPos, ComponentCircuit> data, EntityPlayer player) {
            super.serialize(buf, data, player);
            buf.writeInt(player.field_71071_by.field_70461_c);
        }

        @Override
        public void deserialize(PacketBuffer buf, Map<BlockPos, ComponentCircuit> data, Function<BlockPos, ICircuit> circuitProvider, EntityPlayer player) {
            super.deserialize(buf, data, circuitProvider, player);
            ItemStack curItem = player.field_71071_by.func_70301_a(buf.readInt());
            if (curItem != null && curItem.func_77973_b() == SCMItems.circuit && curItem.func_77942_o()) {
                data.values().iterator().next().circuit.readFromNBT(curItem.func_77978_p());
            }
        }
    }
}

