/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component;

import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IComponentRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public enum ComponentRegistry implements IComponentRegistry
{
    INSTANCE;

    private final BiMap<ResourceLocation, IComponentFactory<?>> factories = HashBiMap.create();
    private final Map<ResourceLocation, BlockStateContainer> states = new HashMap<ResourceLocation, BlockStateContainer>();

    @Override
    public void registerFactory(ResourceLocation name, IComponentFactory<?> factory) {
        this.factories.put((Object)name, factory);
        this.states.put(name, factory.createBlockState());
    }

    public IComponentFactory<?> getFactory(ItemStack stack, EntityPlayer player) {
        for (IComponentFactory factory : this.factories.values()) {
            if (!factory.isValidPlacementStack(stack, player)) continue;
            return factory;
        }
        return null;
    }

    public <T> IComponentFactory<T> getFactory(ResourceLocation name) {
        return (IComponentFactory)this.factories.get((Object)name);
    }

    public ResourceLocation getName(IComponentFactory<?> factory) {
        return (ResourceLocation)this.factories.inverse().get(factory);
    }

    @Override
    public BlockStateContainer getState(ResourceLocation name) {
        return this.states.get(name);
    }

    public Map<ResourceLocation, IComponentFactory<?>> getRegisteredFactories() {
        return this.factories;
    }
}

