/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.component.ComponentFace;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class ComponentButton
extends ComponentFace {
    public static final EnumCircuitSide[] INPUT_SIDES = new EnumCircuitSide[]{EnumCircuitSide.BOTTOM, EnumCircuitSide.BACK, EnumCircuitSide.FRONT, EnumCircuitSide.RIGHT, EnumCircuitSide.LEFT};

    public ComponentButton(ICircuit circuit, EnumComponentSlot slot) {
        super(circuit, slot);
    }

    public ComponentButton(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public EnumSet<EnumComponentSlot> getSlots() {
        return EnumSet.of(this.slot, EnumComponentSlot.CENTER);
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0));
        boxes.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4375, 0.9375));
    }

    @Override
    public AxisAlignedBB getSelectionBox(AxisAlignedBB box) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    }

    protected byte getInput() {
        int input = 0;
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            input = Math.max(input, this.getInputAny(EnumComponentSlot.BOTTOM, s) & 0xFF);
        }
        IComponent c = this.getCircuit().getComponent(this.getPos().func_177977_b(), EnumComponentSlot.TOP);
        if (c != null) {
            input = Math.max(input, c.getOutputSignalAny(EnumComponentSlot.TOP, EnumCircuitSide.TOP) & 0xFF);
        }
        return (byte)input;
    }
}

