/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.client.MSRCircuit;
import com.amadornes.rscircuits.client.ModelTransformer;
import com.amadornes.rscircuits.client.SimpleModelFontRenderer;
import com.amadornes.rscircuits.part.PartCircuit;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.IntUnaryOperator;
import java.util.stream.Stream;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Triple;

public class ModelWrapperCircuit
implements IBakedModel {
    private final IBakedModel parent;
    private final Cache<Map<BlockPos, List<Triple<IBlockState, IBlockState, Triple<Float, Vec3d, IntUnaryOperator>>>>, List<BakedQuad>> modelCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public ModelWrapperCircuit(IBakedModel parent) {
        this.parent = parent;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        Map states;
        if (side == null && (states = (Map)((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_COMPONENTS)) != null) {
            try {
                BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
                return this.processQuads(state, side, (List)this.modelCache.get((Object)states, () -> {
                    ArrayList quads = new ArrayList(this.parent.func_188616_a(state, side, rand));
                    states.forEach((pos, l) -> l.forEach(st -> {
                        IBakedModel model = brd.func_184389_a((IBlockState)st.getLeft());
                        if (model != null) {
                            float size = ((Float)((Triple)st.getRight()).getLeft()).floatValue();
                            Vec3d offset = (Vec3d)((Triple)st.getRight()).getMiddle();
                            IntUnaryOperator colorProvider = (IntUnaryOperator)((Triple)st.getRight()).getRight();
                            Stream stream = model.func_188616_a((IBlockState)st.getMiddle(), null, rand).stream();
                            for (EnumFacing f : EnumFacing.field_82609_l) {
                                stream = Stream.concat(stream, model.func_188616_a((IBlockState)st.getMiddle(), f, rand).stream());
                            }
                            stream.forEach(q -> {
                                int multiplier = q.func_178212_b() ? colorProvider.applyAsInt(q.func_178211_c()) : -1;
                                Color colorMultiplier = multiplier != -1 ? new Color(multiplier, false) : null;
                                int[] data = (int[])q.func_178209_a().clone();
                                for (int i = 0; i < 4; ++i) {
                                    Point3f point = new Point3f((Float.intBitsToFloat(data[i * 7 + 0]) - 0.5f + (offset != null ? (float)offset.field_72450_a : 0.0f)) * size + ((float)pos.func_177958_n() + 0.5f) * 0.125f + 0.0625f, (Float.intBitsToFloat(data[i * 7 + 1]) + (offset != null ? (float)offset.field_72448_b : 0.0f)) * size + (float)pos.func_177956_o() * 0.125f + 0.125f, (Float.intBitsToFloat(data[i * 7 + 2]) - 0.5f + (offset != null ? (float)offset.field_72449_c : 0.0f)) * size + ((float)pos.func_177952_p() + 0.5f) * 0.125f + 0.0625f);
                                    MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()].transform(point);
                                    data[i * 7 + 0] = Float.floatToRawIntBits(point.x);
                                    data[i * 7 + 1] = Float.floatToRawIntBits(point.y);
                                    data[i * 7 + 2] = Float.floatToRawIntBits(point.z);
                                    if (colorMultiplier == null) continue;
                                    Color color = new Color(data[i * 7 + 3]);
                                    data[i * 7 + 3] = color.getAlpha() << 24 | color.getRed() * colorMultiplier.getBlue() / 255 << 16 | color.getGreen() * colorMultiplier.getGreen() / 255 << 8 | color.getBlue() * colorMultiplier.getRed() / 255 << 0;
                                }
                                quads.add(new BakedQuad(data, q.func_178211_c(), q.func_178210_d(), q.func_187508_a(), q.shouldApplyDiffuseLighting(), q.getFormat()));
                            });
                        }
                    }));
                    return quads;
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.processQuads(state, side, this.parent.func_188616_a(state, side, rand));
    }

    private List<BakedQuad> processQuads(IBlockState state, EnumFacing side, List<BakedQuad> quads) {
        if (side == null && ((Boolean)state.func_177229_b(PartCircuit.PROPERTY_CAPSULE)).booleanValue() && !((Boolean)state.func_177229_b(PartCircuit.PROPERTY_SAD)).booleanValue()) {
            quads = new ArrayList<BakedQuad>(quads);
            EnumCircuitIOMode[] modes = (EnumCircuitIOMode[])((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_IO_MODE);
            ArrayList<BakedQuad> added = new ArrayList<BakedQuad>();
            ListIterator<BakedQuad> li = quads.listIterator();
            while (li.hasNext()) {
                BakedQuad q2 = li.next();
                try {
                    if (q2.func_187508_a().func_94215_i().equals("rscircuits:blocks/overlay_normal")) {
                        this.doTheThing(state, modes, EnumCircuitIOMode.REGULAR, li, added, q2);
                        continue;
                    }
                    if (!q2.func_187508_a().func_94215_i().equals("rscircuits:blocks/overlay_combo")) continue;
                    this.doTheThing(state, modes, EnumCircuitIOMode.BUNDLED, li, added, q2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            quads.addAll(added);
            added.clear();
            String name = (String)((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_NAME);
            if (name != null && name.length() > 0) {
                SimpleModelFontRenderer fontRenderer = SimpleModelFontRenderer.get(quads.iterator().next().getFormat());
                fontRenderer.setFillBlanks(true);
                int width = fontRenderer.func_78256_a(name) - 1;
                int size = Math.max(width, fontRenderer.field_78288_b + 2);
                fontRenderer.func_78276_b(name, 0, 0, -1);
                ModelTransformer.IVertexTransformer transformer = (q, type, usage, data) -> {
                    if (usage == VertexFormatElement.EnumUsage.POSITION) {
                        Point3f p = new Point3f(data[0], data[1], data[2]);
                        p.x = (p.x - (1.0f - (float)(fontRenderer.field_78288_b - 2) / 16.0f / 16.0f)) * (57.6f / (float)size) + 0.5f;
                        p.y = p.y - 1.0f + 0.171875f + 0.002f;
                        p.z = (p.z - (float)width / 16.0f / 16.0f) * (57.6f / (float)size) + 0.5f;
                        Matrix4f mat = new Matrix4f(MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()]);
                        if (((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176740_k() != EnumFacing.Axis.Y) {
                            Matrix4f mat2 = new Matrix4f();
                            mat2.setIdentity();
                            mat2.rotY((float)Math.PI);
                            p.x = (float)((double)p.x - 0.5);
                            p.z = (float)((double)p.z - 0.5);
                            mat2.transform(p);
                            p.x = (float)((double)p.x + 0.5);
                            p.z = (float)((double)p.z + 0.5);
                        }
                        mat.transform(p);
                        return new float[]{p.x, p.y, p.z, data[3]};
                    }
                    return data;
                };
                fontRenderer.build().stream().map(q -> ModelTransformer.transform(q, transformer)).forEach(quads::add);
            }
        }
        return quads;
    }

    public void doTheThing(IBlockState state, EnumCircuitIOMode[] modes, EnumCircuitIOMode mode, ListIterator<BakedQuad> li, List<BakedQuad> quads, BakedQuad quad) {
        int k = ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176740_k() == EnumFacing.Axis.Y ? 0 : 1;
        for (int i = 0; i < 4; ++i) {
            Matrix4f matrix;
            int j;
            int n = i == 2 ? 0 : (i == 0 ? 1 : (j = i == 1 ? 2 : 3));
            if (modes[(j + k) % 4] != mode || (matrix = ModelRotation.func_177524_a((int)0, (int)(i * 90)).getMatrix()) == null) continue;
            quads.add(ModelTransformer.transform(quad, (q, type, usage, data) -> {
                if (usage == VertexFormatElement.EnumUsage.POSITION) {
                    Point3f point = new Point3f(data[0], data[1], data[2]);
                    Matrix4f mat = new Matrix4f(MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()]);
                    mat.invert();
                    mat.transform(point);
                    point.y += 0.001f;
                    matrix.transform(point);
                    MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()].transform(point);
                    return new float[]{point.x, point.y, point.z, data[3]};
                }
                return data;
            }));
        }
        li.remove();
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }
}

