/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.amadornes.rscircuits.CommonProxy;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.api.component.IPaintableComponent;
import com.amadornes.rscircuits.circuit.Circuit;
import com.amadornes.rscircuits.client.CircuitStateMapper;
import com.amadornes.rscircuits.client.EmptyModelLoader;
import com.amadornes.rscircuits.client.MSRCircuit;
import com.amadornes.rscircuits.client.ModelTransformer;
import com.amadornes.rscircuits.client.ModelWrapperCircuit;
import com.amadornes.rscircuits.client.ModelWrapperInnerCircuit;
import com.amadornes.rscircuits.client.SimpleModelFontRenderer;
import com.amadornes.rscircuits.client.gui.GuiColorPalette;
import com.amadornes.rscircuits.client.gui.GuiRegulate;
import com.amadornes.rscircuits.client.gui.GuiTutorial;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.component.circuit.ComponentCircuit;
import com.amadornes.rscircuits.component.digital.ComponentLever;
import com.amadornes.rscircuits.init.SCMBlocks;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.item.IScrollableItem;
import com.amadornes.rscircuits.item.ItemMonocle;
import com.amadornes.rscircuits.network.NetworkHandler;
import com.amadornes.rscircuits.network.PacketColorPick;
import com.amadornes.rscircuits.network.PacketPlacementData;
import com.amadornes.rscircuits.part.PartCircuit;
import com.amadornes.rscircuits.util.BoolFunction;
import com.amadornes.rscircuits.util.IntBoolFunction;
import com.amadornes.rscircuits.util.RedstoneUtils;
import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    private SoundEvent sound_place;
    private SoundEvent sound_xycraft;
    private SoundEvent sound_dw20;
    private BlockPos placePosLast;
    private ItemStack drawStack;
    private EnumHand drawHand;
    private ICircuit drawCircuit;
    private Map<BlockPos, Object> drawDataMap;
    private IComponentFactory<?> drawFactory;
    private int breakHeight = -1;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register(SimpleModelFontRenderer.class);
        ItemMonocle.initClient();
        for (EnumResourceType res : EnumResourceType.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)SCMItems.resource, (int)res.ordinal(), (ModelResourceLocation)new ModelResourceLocation("rscircuits:resource", "inventory_" + res.name().toLowerCase()));
        }
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.circuit, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:circuit", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.component_tray, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:component_tray", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.palette_and_brush, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:pallette_and_brush", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.screwdriver, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:screwdriver", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.screwdriver, (int)1, (ModelResourceLocation)new ModelResourceLocation("rscircuits:screwdriver", "inventory_clippy"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.redwire, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:redwire", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.monocle, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:monocle", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.monocle, (int)1, (ModelResourceLocation)new ModelResourceLocation("rscircuits:monocle", "inventory_magnificent"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.blueprint, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:blueprint", "inventory_blueprint_empty"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.blueprint, (int)1, (ModelResourceLocation)new ModelResourceLocation("rscircuits:blueprint", "inventory_blueprint"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.blueprint, (int)2, (ModelResourceLocation)new ModelResourceLocation("rscircuits:blueprint", "inventory_redprint_empty"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.blueprint, (int)3, (ModelResourceLocation)new ModelResourceLocation("rscircuits:blueprint", "inventory_redprint"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.blueprint, (int)4, (ModelResourceLocation)new ModelResourceLocation("rscircuits:blueprint", "inventory_blueprint"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.multimeter, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:multimeter", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMItems.squeegee, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:squeegee", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SCMBlocks.update_detector_item, (int)0, (ModelResourceLocation)new ModelResourceLocation("rscircuits:update_detector", "inventory"));
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)EmptyModelLoader.INSTANCE);
        MultipartRegistryClient.registerSpecialPartStateMapper((ResourceLocation)new ResourceLocation("rscircuits", "circuit"), (IStateMapper)new CircuitStateMapper());
        MultipartRegistryClient.bindMultipartSpecialRenderer(PartCircuit.class, (MultipartSpecialRenderer)new MSRCircuit());
        ResourceLocation location = new ResourceLocation("rscircuits", "component.place");
        this.sound_place = new SoundEvent(location);
        GameRegistry.register((IForgeRegistryEntry)this.sound_place, (ResourceLocation)location);
        location = new ResourceLocation("rscircuits", "component.place.soaryn");
        this.sound_xycraft = new SoundEvent(location);
        GameRegistry.register((IForgeRegistryEntry)this.sound_xycraft, (ResourceLocation)location);
        location = new ResourceLocation("rscircuits", "component.place.dire");
        this.sound_dw20 = new SoundEvent(location);
        GameRegistry.register((IForgeRegistryEntry)this.sound_dw20, (ResourceLocation)location);
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public RayTraceResult getHit() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @Override
    public void playPlaceSound(BlockPos pos) {
        float vol = 0.125f;
        Minecraft mc = Minecraft.func_71410_x();
        UUID uuid = mc.field_71439_g.func_146103_bH().getId();
        if (uuid.toString().equalsIgnoreCase("4f3a8d1e-33c1-44e7-bce8-e683027c7dac")) {
            vol *= 0.125f;
            if (Math.random() < 0.005) {
                mc.field_71441_e.func_184156_a(pos, this.sound_xycraft, SoundCategory.BLOCKS, vol, 1.0f, false);
                return;
            }
        } else if (uuid.toString().equalsIgnoreCase("bbb87dbe-690f-4205-bdc5-72ffb8ebc29d") && Math.random() < 0.002) {
            mc.field_71441_e.func_184156_a(pos, this.sound_dw20, SoundCategory.BLOCKS, vol, 1.0f, false);
            return;
        }
        mc.field_71441_e.func_184156_a(pos, this.sound_place, SoundCategory.BLOCKS, vol, 0.85f + (float)(Math.random() * 0.05), false);
    }

    @Override
    public void displayTimerGui(IntBoolFunction<String> titleSupplier, BoolFunction<String> shortSupplier, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, double shiftMul) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRegulate(titleSupplier, shortSupplier, getter, setter, min, max, shiftMul));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ResourceLocation circuit = new ResourceLocation("rscircuits", "circuit");
        for (IBlockState state : MultipartRegistry.getDefaultState((ResourceLocation)circuit).func_177619_a()) {
            ModelResourceLocation mrl = new ModelResourceLocation(circuit, MultipartStateMapper.instance.func_178131_a((Map)state.func_177228_b()));
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)new ModelWrapperCircuit((IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
        }
        ResourceLocation innerCircuit = new ResourceLocation("rscircuits", "component/circuit");
        for (IBlockState state : ComponentRegistry.INSTANCE.getState(ComponentCircuit.NAME).func_177619_a()) {
            ModelResourceLocation mrl = new ModelResourceLocation(innerCircuit, MultipartStateMapper.instance.func_178131_a((Map)state.func_177228_b()).replace("multipart", "normal"));
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)new ModelWrapperInnerCircuit((IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl)));
        }
        ResourceLocation lever = new ResourceLocation("rscircuits", "component/lever");
        for (IBlockState state : ComponentRegistry.INSTANCE.getState(ComponentLever.NAME).func_177619_a()) {
            ModelResourceLocation mrl = new ModelResourceLocation(lever, MultipartStateMapper.instance.func_178131_a((Map)state.func_177228_b()));
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)ModelTransformer.transform((IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl), (quad, type, usage, data) -> {
                if (usage == VertexFormatElement.EnumUsage.POSITION) {
                    data[0] = data[0] - 0.5f;
                    data[2] = data[2] - 0.5f;
                    float ratio = 2.0f;
                    data[0] = data[0] * ratio;
                    data[1] = data[1] * ratio;
                    data[2] = data[2] * ratio;
                    data[0] = data[0] + 0.5f;
                    data[2] = data[2] + 0.5f;
                }
                return data;
            }, state, 0L));
        }
    }

    @SubscribeEvent
    public <T> void drawInteractionPrevention(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld() != null && event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
            if (event.getItemStack() != null && (event.getItemStack().func_77973_b() == SCMItems.screwdriver || event.getItemStack().func_77973_b() == SCMItems.multimeter)) {
                return;
            }
            RayTraceResult hit = Minecraft.func_71410_x().field_71476_x;
            if (hit instanceof PartMOP && ((PartMOP)hit).partHit instanceof PartCircuit) {
                PartMOP mop = (PartMOP)hit;
                PartCircuit partCircuit = (PartCircuit)mop.partHit;
                if (partCircuit.isEncapsulated()) {
                    return;
                }
                Vec3d extrudedProjection = RedstoneUtils.projectComponent(new Vec3d(hit.field_72307_f.field_72450_a - (double)hit.func_178782_a().func_177958_n(), hit.field_72307_f.field_72448_b - (double)hit.func_178782_a().func_177956_o(), hit.field_72307_f.field_72449_c - (double)hit.func_178782_a().func_177952_p()), partCircuit.getFace(), BlockPos.field_177992_a);
                BlockPos clickedPos = new BlockPos(extrudedProjection);
                Circuit circuit = partCircuit.circuit.getCircuit(clickedPos);
                if (circuit != null && !partCircuit.isSad() && !partCircuit.isEncapsulated() && circuit.getPos() != null && circuit.getFace() != null) {
                    if (this.handleDrawTick(event, circuit, clickedPos = RedstoneUtils.limitPositionToBounds(clickedPos), extrudedProjection = RedstoneUtils.limitPositionToBounds(extrudedProjection), mop)) {
                        event.setCanceled(true);
                    } else if (this.handlePaint(event, circuit, clickedPos, extrudedProjection, mop)) {
                        event.setCanceled(true);
                    }
                }
            } else {
                this.drawStack = null;
                this.drawHand = null;
                this.drawDataMap = null;
                if (this.drawFactory instanceof IComponentFactory.IDrawListener) {
                    ((IComponentFactory.IDrawListener)this.drawFactory).onFinishDrawing(event.getEntityPlayer());
                }
                this.drawFactory = null;
            }
        }
    }

    private boolean handlePaint(PlayerInteractEvent.RightClickBlock event, ICircuit circuit, BlockPos clickedPos, Vec3d extrudedProjection, PartMOP hit) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        EnumHand hand = EnumHand.MAIN_HAND;
        if (stack == null || stack.func_77973_b() != SCMItems.palette_and_brush) {
            stack = player.func_184592_cb();
            hand = EnumHand.OFF_HAND;
        }
        if (stack != null && stack.func_77973_b() == SCMItems.palette_and_brush) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            int active = tag.func_74762_e("color");
            if (hit.hitInfo instanceof IPaintableComponent && ((IPaintableComponent)hit.hitInfo).paint(EnumDyeColor.func_176764_b((int)active))) {
                player.func_184609_a(hand);
                return true;
            }
        }
        return false;
    }

    private <T> boolean handleDrawTick(PlayerInteractEvent.RightClickBlock event, ICircuit circuit, BlockPos clickedPos, Vec3d extrudedProjection, PartMOP hit) {
        IComponentFactory.EnumPlacementType type;
        IComponentFactory<?> factory;
        ItemStack heldItem;
        if (hit.hitInfo != null && hit.hitInfo instanceof IComponent && ((IComponent)hit.hitInfo).getPos().equals((Object)clickedPos)) {
            Vec3d subPos = extrudedProjection.func_178788_d(new Vec3d((Vec3i)clickedPos));
            if (subPos.field_72450_a == 0.0) {
                clickedPos = clickedPos.func_177982_a(-1, 0, 0);
            } else if (subPos.field_72449_c == 0.0) {
                clickedPos = clickedPos.func_177982_a(0, 0, -1);
            }
        }
        if ((heldItem = RedstoneUtils.unwrap(event.getEntityPlayer().func_184586_b(event.getHand()))) != null && event.getHand() == EnumHand.MAIN_HAND && (factory = ComponentRegistry.INSTANCE.getFactory(heldItem, event.getEntityPlayer())) != null && (type = factory.getPlacementType(heldItem, event.getEntityPlayer())) != null) {
            if (type == IComponentFactory.EnumPlacementType.SINGLE) {
                HashMap dataMap = new HashMap();
                Object data = factory.getPlacementData(circuit, clickedPos, EnumCircuitSide.BOTTOM, extrudedProjection, heldItem, event.getEntityPlayer(), type, null, dataMap, IComponentFactory.EnumInstantanceUse.PLACEMENT);
                if (data != null && dataMap.get(clickedPos) != data && factory.placeComponent(circuit, clickedPos, data, type, dataMap, true)) {
                    event.getEntityPlayer().func_184609_a(event.getHand());
                    event.setCanceled(true);
                    event.setUseItem(Event.Result.DENY);
                    this.placePosLast = new BlockPos(hit.func_178782_a().func_177958_n() * 8 + clickedPos.func_177958_n(), hit.func_178782_a().func_177956_o() * 8 + clickedPos.func_177956_o(), hit.func_178782_a().func_177952_p() * 8 + clickedPos.func_177952_p());
                    this.playPlaceSound(circuit.getPos());
                    dataMap.put(clickedPos, data);
                    ByteBuf buf = Unpooled.buffer();
                    factory.serialize(new PacketBuffer(buf), dataMap, this.getPlayer());
                    NetworkHandler.instance.sendToServer(new PacketPlacementData(ComponentRegistry.INSTANCE.getName(factory), circuit.getPos(), circuit.getFace(), buf.array(), IComponentFactory.EnumPlacementType.SINGLE));
                    return true;
                }
            } else if (type == IComponentFactory.EnumPlacementType.DRAW) {
                BlockPos packedCoords = RedstoneUtils.packCoords(RedstoneUtils.correctOffset(circuit.getPos().func_177973_b((Vec3i)(this.drawCircuit != null ? this.drawCircuit : circuit).getPos()), circuit.getFace()), circuit.getFace(), clickedPos);
                if (factory instanceof IComponentFactory.IDrawListener) {
                    ((IComponentFactory.IDrawListener)factory).onStartDrawing(event.getEntityPlayer());
                }
                HashMap<BlockPos, Object> drawDataMap = this.drawDataMap != null ? (HashMap)this.drawDataMap : new HashMap<BlockPos, Object>();
                Object data = factory.getPlacementData(circuit, clickedPos, EnumCircuitSide.BOTTOM, extrudedProjection, heldItem, event.getEntityPlayer(), type, drawDataMap.get(packedCoords), drawDataMap, IComponentFactory.EnumInstantanceUse.PLACEMENT);
                if (data != null && drawDataMap.get(clickedPos) != data && factory.placeComponent(circuit, clickedPos, data, type, drawDataMap, true)) {
                    event.setCanceled(true);
                    event.setUseItem(Event.Result.DENY);
                    drawDataMap.put(packedCoords, data);
                    if (this.drawStack == null) {
                        this.drawStack = heldItem;
                        this.drawHand = event.getHand();
                        this.drawCircuit = circuit;
                        this.drawDataMap = drawDataMap;
                        this.drawFactory = factory;
                    }
                    return true;
                }
                if (factory instanceof IComponentFactory.IDrawListener) {
                    ((IComponentFactory.IDrawListener)factory).onFinishDrawing(event.getEntityPlayer());
                }
            } else if (type == IComponentFactory.EnumPlacementType.LINE) {
                // empty if block
            }
        }
        return false;
    }

    @SubscribeEvent
    public <T> void drawBreakPrevention(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (event.getWorld() != null && event.getWorld().field_72995_K && stack != null && stack.func_77973_b() == SCMItems.screwdriver) {
            event.setCanceled(true);
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public <T> void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        ItemStack heldStackMain = mc.field_71439_g.func_184614_ca();
        ItemStack heldStackOff = mc.field_71439_g.func_184592_cb();
        ItemStack heldStack = heldStackMain;
        if (heldStack == null || heldStack.func_77973_b() != SCMItems.palette_and_brush) {
            heldStack = heldStackOff;
        }
        if (heldStack != null && heldStack.func_77973_b() == SCMItems.palette_and_brush && Keyboard.isKeyDown((int)56) && mc.field_71462_r == null) {
            NBTTagCompound tag = heldStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                heldStack.func_77982_d(tag);
            }
            int active = tag.func_74762_e("color");
            mc.func_147108_a((GuiScreen)new GuiColorPalette(active, i -> NetworkHandler.instance.sendToServer(new PacketColorPick(i))));
        }
        if (heldStackMain != null && heldStackMain.func_77973_b() == SCMItems.screwdriver && Keyboard.isKeyDown((int)56) && mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)new GuiTutorial());
        }
        if (this.breakHeight != -1 && !mc.field_71474_y.field_74312_F.func_151470_d()) {
            this.breakHeight = -1;
        }
        if (this.drawStack != null) {
            Minecraft.func_71410_x().field_71439_g.func_184811_cZ().func_185142_b(this.drawStack.func_77973_b());
            if (!mc.field_71474_y.field_74313_G.func_151470_d()) {
                IComponentFactory<?> drawFactory = this.drawFactory;
                EntityPlayerSP player = mc.field_71439_g;
                if (drawFactory instanceof IComponentFactory.IDrawHandler) {
                    if (((IComponentFactory.IDrawHandler)drawFactory).finishDrawing(this.drawCircuit, this.drawDataMap, this.drawStack, (EntityPlayer)player)) {
                        player.func_184609_a(this.drawHand);
                    }
                } else {
                    boolean success = false;
                    for (Map.Entry<BlockPos, Object> e : this.drawDataMap.entrySet()) {
                        success |= drawFactory.placeComponent(this.drawCircuit, e.getKey(), e.getValue(), IComponentFactory.EnumPlacementType.DRAW, this.drawDataMap, true);
                    }
                    if (success) {
                        player.func_184609_a(this.drawHand);
                        this.playPlaceSound(this.drawCircuit.getPos());
                        ByteBuf buf = Unpooled.buffer();
                        drawFactory.serialize(new PacketBuffer(buf), this.drawDataMap, (EntityPlayer)player);
                        NetworkHandler.instance.sendToServer(new PacketPlacementData(ComponentRegistry.INSTANCE.getName(drawFactory), this.drawCircuit.getPos(), this.drawCircuit.getFace(), buf.array(), IComponentFactory.EnumPlacementType.DRAW));
                    }
                }
                if (drawFactory instanceof IComponentFactory.IDrawListener) {
                    ((IComponentFactory.IDrawListener)drawFactory).onFinishDrawing((EntityPlayer)player);
                }
                this.drawStack = null;
                this.drawCircuit = null;
                this.drawDataMap = null;
                this.drawFactory = null;
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (stack != null && stack.func_77973_b() == SCMItems.component_tray && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            int slot = tag.func_74762_e("slot");
            GuiIngame igg = mc.field_71456_v;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/widgets.png"));
            int i = event.getResolution().func_78326_a() / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(i - 91), (float)(event.getResolution().func_78328_b() - 23 - (mc.field_71439_g.field_71075_bZ.field_75098_d ? 21 : 48)), (float)0.0f);
            GlStateManager.func_179137_b((double)91.0, (double)11.0, (double)0.0);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)1.0);
            GlStateManager.func_179137_b((double)-91.0, (double)-11.0, (double)0.0);
            igg.func_73729_b(0, 0, 0, 0, 182, 22);
            igg.func_73729_b(-1 + slot * 20, -1, 0, 22, 24, 24);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
        }
        if ((stack = mc.field_71439_g.func_184614_ca()) != null && stack.func_77973_b() == SCMItems.palette_and_brush && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.renderPalette(mc.field_71439_g.func_184591_cq(), stack, event);
        } else {
            stack = mc.field_71439_g.func_184592_cb();
            if (stack != null && stack.func_77973_b() == SCMItems.palette_and_brush && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                this.renderPalette(mc.field_71439_g.func_184591_cq().func_188468_a(), stack, event);
            }
        }
    }

    private void renderPalette(EnumHandSide hand, ItemStack stack, RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        int active = tag.func_74762_e("color");
        int size = 62;
        int off = 17;
        int b = 1;
        int cOff = 3;
        int cSize = (size - b * 2 - cOff * 5) / 4;
        int selInactive = -1609560049;
        int x = hand == EnumHandSide.LEFT ? off : event.getResolution().func_78326_a() - size - off;
        int y = event.getResolution().func_78328_b() - size - off;
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + size), (int)(y + size), (int)1880100879, (int)1880100879);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + size), (int)(y + b), (int)-1609560049, (int)-1609560049);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)(y + size - b), (int)(x + size), (int)(y + size), (int)-1609560049, (int)-1609560049);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)(y + b), (int)(x + b), (int)(y + size - b), (int)-1609560049, (int)-1609560049);
        GuiUtils.drawGradientRect((int)0, (int)(x + size - b), (int)(y + b), (int)(x + size), (int)(y + size - b), (int)-1609560049, (int)-1609560049);
        for (int x_ = 0; x_ < 4; ++x_) {
            int xOff = x + b + cOff * (x_ + 1) + cSize * x_;
            for (int y_ = 0; y_ < 4; ++y_) {
                int yOff = y + b + cOff * (y_ + 1) + cSize * y_;
                EnumDyeColor dye = EnumDyeColor.func_176764_b((int)(y_ * 4 + x_));
                int color = dye.func_176768_e().field_76291_p | 0xFF000000;
                if (active == y_ * 4 + x_) {
                    GuiUtils.drawGradientRect((int)0, (int)xOff, (int)yOff, (int)(xOff + cSize), (int)(yOff + cSize), (int)color, (int)color);
                    GuiUtils.drawGradientRect((int)0, (int)(xOff - b), (int)(yOff - b), (int)(xOff + cSize + b), (int)yOff, (int)selInactive, (int)selInactive);
                    GuiUtils.drawGradientRect((int)0, (int)(xOff - b), (int)(yOff + cSize), (int)(xOff + cSize + b), (int)(yOff + cSize + b), (int)selInactive, (int)selInactive);
                    GuiUtils.drawGradientRect((int)0, (int)(xOff - b), (int)yOff, (int)xOff, (int)(yOff + cSize), (int)selInactive, (int)selInactive);
                    GuiUtils.drawGradientRect((int)0, (int)(xOff + cSize), (int)yOff, (int)(xOff + cSize + b), (int)(yOff + cSize), (int)selInactive, (int)selInactive);
                    continue;
                }
                GuiUtils.drawGradientRect((int)0, (int)(xOff + b), (int)(yOff + b), (int)(xOff + cSize - b), (int)(yOff + cSize - b), (int)color, (int)color);
                GuiUtils.drawGradientRect((int)0, (int)xOff, (int)yOff, (int)(xOff + cSize), (int)(yOff + b), (int)selInactive, (int)selInactive);
                GuiUtils.drawGradientRect((int)0, (int)xOff, (int)(yOff + cSize - b), (int)(xOff + cSize), (int)(yOff + cSize), (int)selInactive, (int)selInactive);
                GuiUtils.drawGradientRect((int)0, (int)xOff, (int)(yOff + b), (int)(xOff + b), (int)(yOff + cSize - b), (int)selInactive, (int)selInactive);
                GuiUtils.drawGradientRect((int)0, (int)(xOff + cSize - b), (int)(yOff + b), (int)(xOff + cSize), (int)(yOff + cSize - b), (int)selInactive, (int)selInactive);
            }
        }
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent event) {
        int dwheel = event.getDwheel();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (dwheel != 0 && stack != null && stack.func_77973_b() instanceof IScrollableItem) {
            event.setCanceled(((IScrollableItem)stack.func_77973_b()).scroll((EntityPlayer)player, stack, dwheel));
        }
    }
}

