/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.microblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import reborncore.mcmultipart.microblock.IMicroMaterial;
import reborncore.mcmultipart.microblock.IMicroblockPlacementGrid;
import reborncore.mcmultipart.microblock.MicroblockPlacement;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.multipart.IPartFactory;

public abstract class MicroblockClass
implements IPartFactory.IAdvancedPartFactory {
    private final ResourceLocation fullQualifiedType;

    public MicroblockClass() {
        String type = this.getType();
        this.fullQualifiedType = type.contains(":") ? new ResourceLocation(type) : new ResourceLocation(Loader.instance().activeModContainer().getModId(), type);
    }

    public abstract String getType();

    public abstract String getLocalizedName(IMicroMaterial var1, int var2);

    public abstract ItemStack createStack(IMicroMaterial var1, int var2, int var3);

    public abstract MicroblockPlacement getPlacement(World var1, BlockPos var2, IMicroMaterial var3, int var4, RayTraceResult var5, EntityPlayer var6);

    public abstract IMicroblockPlacementGrid getPlacementGrid();

    public abstract IMultipart create(boolean var1);

    public final ResourceLocation getFullQualifiedType() {
        return this.fullQualifiedType;
    }

    @Override
    public IMultipart createPart(ResourceLocation type, PacketBuffer buf) {
        IMultipart part;
        IMultipart iMultipart = part = type.equals((Object)this.getFullQualifiedType()) ? this.create(true) : null;
        if (part != null) {
            part.readUpdatePacket(buf);
        }
        return part;
    }

    @Override
    public IMultipart createPart(ResourceLocation type, NBTTagCompound tag) {
        IMultipart part;
        IMultipart iMultipart = part = type.equals((Object)this.getFullQualifiedType()) ? this.create(false) : null;
        if (part != null) {
            part.readFromNBT(tag);
        }
        return part;
    }
}

