/*
 * Decompiled with CFR 0.152.
 */
package reborncore.jtraits;

import reborncore.jtraits.Annotation;
import reborncore.jtraits.ClassLoadingHelper;
import reborncore.jtraits.Mixin;

public class MixinFactory {
    public static boolean debug = false;

    @SafeVarargs
    public static <T> Class<? extends T> mixin(Class<T> clazz, Class<?> ... traits) {
        Class<T> cl = clazz;
        Class<?> closingTrait = null;
        do {
            Annotation.ClosingTrait a;
            if ((a = cl.getAnnotation(Annotation.ClosingTrait.class)) == null) continue;
            try {
                closingTrait = Class.forName(a.value());
                break;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Couldn't find the closing trait \"" + a.value() + "\"!");
            }
        } while ((cl = cl.getSuperclass()) != null && cl != Object.class);
        Class<Object> c = clazz;
        for (Class<?> t : traits) {
            Mixin<Object> mixin = ClassLoadingHelper.instance.findMixin(c, t);
            if (mixin == null) {
                mixin = new Mixin<T>(c, t);
            }
            c = mixin.mixin();
        }
        if (closingTrait != null) {
            Mixin<Object> mixin = ClassLoadingHelper.instance.findMixin(c, closingTrait);
            if (mixin == null) {
                mixin = new Mixin<T>(c, closingTrait);
            }
            c = mixin.mixin();
        }
        return c;
    }
}

