/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.multiblock.rectangular;

import net.minecraft.util.EnumFacing;
import reborncore.common.multiblock.CoordTriplet;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockTileEntityBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.PartPosition;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockTileEntityBase {
    PartPosition position = PartPosition.Unknown;
    EnumFacing outwards = null;

    public EnumFacing getOutwardsDir() {
        return this.outwards;
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        CoordTriplet maxCoord = controller.getMaximumCoord();
        CoordTriplet minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = null;
    }

    public void recalculateOutwardsDirection(CoordTriplet minCoord, CoordTriplet maxCoord) {
        this.outwards = null;
        this.position = PartPosition.Unknown;
        int facesMatching = 0;
        if (maxCoord.x == this.func_174877_v().func_177958_n() || minCoord.x == this.func_174877_v().func_177958_n()) {
            ++facesMatching;
        }
        if (maxCoord.y == this.func_174877_v().func_177956_o() || minCoord.y == this.func_174877_v().func_177956_o()) {
            ++facesMatching;
        }
        if (maxCoord.z == this.func_174877_v().func_177952_p() || minCoord.z == this.func_174877_v().func_177952_p()) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.Interior;
        } else if (facesMatching >= 3) {
            this.position = PartPosition.FrameCorner;
        } else if (facesMatching == 2) {
            this.position = PartPosition.Frame;
        } else if (maxCoord.x == this.func_174877_v().func_177958_n()) {
            this.position = PartPosition.EastFace;
            this.outwards = EnumFacing.EAST;
        } else if (minCoord.x == this.func_174877_v().func_177958_n()) {
            this.position = PartPosition.WestFace;
            this.outwards = EnumFacing.WEST;
        } else if (maxCoord.z == this.func_174877_v().func_177952_p()) {
            this.position = PartPosition.SouthFace;
            this.outwards = EnumFacing.SOUTH;
        } else if (minCoord.z == this.func_174877_v().func_177952_p()) {
            this.position = PartPosition.NorthFace;
            this.outwards = EnumFacing.NORTH;
        } else if (maxCoord.y == this.func_174877_v().func_177956_o()) {
            this.position = PartPosition.TopFace;
            this.outwards = EnumFacing.UP;
        } else {
            this.position = PartPosition.BottomFace;
            this.outwards = EnumFacing.DOWN;
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

