/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility.math;

import com.infinityraider.infinitylib.utility.math.Vector;
import javax.vecmath.Matrix4f;
import net.minecraft.util.math.Vec3d;

public final class TransformationMatrix {
    private static final int SIZE = 4;
    private static final int ELEMENTS = 16;
    private double[] matrix = new double[16];

    public TransformationMatrix() {
        for (int i = 0; i < 4; ++i) {
            TransformationMatrix.set(this.matrix, i, i, 1.0);
        }
    }

    public TransformationMatrix(TransformationMatrix other) {
        System.arraycopy(other.matrix, 0, this.matrix, 0, 16);
    }

    public TransformationMatrix(double angle, double x, double y, double z) {
        this.setRotation(angle, x, y, z);
        TransformationMatrix.set(this.matrix, 3, 3, 1.0);
    }

    public TransformationMatrix(double x, double y, double z) {
        this.setTranslation(x, y, z);
        for (int i = 0; i < 4; ++i) {
            TransformationMatrix.set(this.matrix, i, i, 1.0);
        }
    }

    public TransformationMatrix(Vec3d translation) {
        this(translation.field_72450_a, translation.field_72448_b, translation.field_72449_c);
    }

    public TransformationMatrix(Vector translation) {
        this(translation.getX(), translation.getY(), translation.getZ());
    }

    public TransformationMatrix(double angle, double x, double y, double z, Vector translation) {
        this.setRotation(angle, x, y, z);
        this.setTranslation(translation);
        TransformationMatrix.set(this.matrix, 3, 3, 1.0);
    }

    private static void set(double[] m, int r, int c, double e) {
        m[c + r * 4] = e;
    }

    private static void inc(double[] m, int r, int c, double e) {
        int n = c + r * 4;
        m[n] = m[n] + e;
    }

    private static double get(double[] m, int r, int c) {
        return m[c + r * 4];
    }

    public void setRotation(double angle, double x, double y, double z) {
        Vector axis = new Vector(x, y, z).normalize();
        angle = Math.toRadians(angle);
        x = axis.getX();
        y = axis.getY();
        z = axis.getZ();
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        TransformationMatrix.set(this.matrix, 0, 0, x * x * (1.0 - cos) + cos);
        TransformationMatrix.set(this.matrix, 0, 1, y * x * (1.0 - cos) - z * sin);
        TransformationMatrix.set(this.matrix, 0, 2, z * x * (1.0 - cos) + y * sin);
        TransformationMatrix.set(this.matrix, 1, 0, x * y * (1.0 - cos) + z * sin);
        TransformationMatrix.set(this.matrix, 1, 1, y * y * (1.0 - cos) + cos);
        TransformationMatrix.set(this.matrix, 1, 2, y * z * (1.0 - cos) - x * sin);
        TransformationMatrix.set(this.matrix, 2, 0, x * z * (1.0 - cos) - y * sin);
        TransformationMatrix.set(this.matrix, 2, 1, y * z * (1.0 - cos) + x * sin);
        TransformationMatrix.set(this.matrix, 2, 2, z * z * (1.0 - cos) + cos);
    }

    public void setTranslation(Vector v) {
        this.setTranslation(v.getX(), v.getY(), v.getZ());
    }

    public void setTranslation(double x, double y, double z) {
        TransformationMatrix.set(this.matrix, 0, 3, x);
        TransformationMatrix.set(this.matrix, 1, 3, y);
        TransformationMatrix.set(this.matrix, 2, 3, z);
    }

    public double[] getTranslation() {
        return new double[]{TransformationMatrix.get(this.matrix, 0, 3), TransformationMatrix.get(this.matrix, 1, 3), TransformationMatrix.get(this.matrix, 2, 3)};
    }

    public TransformationMatrix scale(double x, double y, double z) {
        TransformationMatrix m = new TransformationMatrix();
        TransformationMatrix.set(m.matrix, 0, 0, x);
        TransformationMatrix.set(m.matrix, 1, 1, y);
        TransformationMatrix.set(m.matrix, 2, 2, z);
        this.multiplyRightWith(m);
        return this;
    }

    public TransformationMatrix multiplyLeftWith(TransformationMatrix m) {
        this.matrix = TransformationMatrix.multi(m, this);
        return this;
    }

    public TransformationMatrix multiplyRightWith(TransformationMatrix m) {
        this.matrix = TransformationMatrix.multi(this, m);
        return this;
    }

    private static double[] multi(TransformationMatrix a, TransformationMatrix b) {
        double[] newValues = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double value = 0.0;
                for (int k = 0; k < 4; ++k) {
                    value += TransformationMatrix.get(a.matrix, i, k) * TransformationMatrix.get(b.matrix, k, j);
                }
                TransformationMatrix.set(newValues, i, j, value);
            }
        }
        return newValues;
    }

    public double[] transform(double x, double y, double z) {
        double[] coords = new double[]{x, y, z, 1.0};
        double[] result = new double[3];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                result[n] = result[n] + TransformationMatrix.get(this.matrix, i, j) * coords[j];
            }
        }
        return result;
    }

    public Matrix4f toMatrix4f() {
        return new Matrix4f((float)this.matrix[0], (float)this.matrix[1], (float)this.matrix[2], (float)this.matrix[3], (float)this.matrix[4], (float)this.matrix[5], (float)this.matrix[6], (float)this.matrix[7], (float)this.matrix[8], (float)this.matrix[9], (float)this.matrix[10], (float)this.matrix[11], (float)this.matrix[12], (float)this.matrix[13], (float)this.matrix[14], (float)this.matrix[15]);
    }
}

